<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/googleads/v18/common/audience_insights_attribute.proto

namespace Google\Ads\GoogleAds\V18\Common;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An audience attribute, with metadata about it, returned in response to a
 * search.
 *
 * Generated from protobuf message <code>google.ads.googleads.v18.common.AudienceInsightsAttributeMetadata</code>
 */
class AudienceInsightsAttributeMetadata extends \Google\Protobuf\Internal\Message
{
    /**
     * The type of the attribute.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v18.enums.AudienceInsightsDimensionEnum.AudienceInsightsDimension dimension = 1;</code>
     */
    protected $dimension = 0;
    /**
     * The attribute itself.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v18.common.AudienceInsightsAttribute attribute = 2;</code>
     */
    protected $attribute = null;
    /**
     * The human-readable name of the attribute.
     *
     * Generated from protobuf field <code>string display_name = 3;</code>
     */
    protected $display_name = '';
    /**
     * A string that supplements the display_name to identify the attribute.
     * If the dimension is TOPIC, this is a brief description of the
     * Knowledge Graph entity, such as "American singer-songwriter".
     * If the dimension is CATEGORY, this is the complete path to the category in
     * The Product & Service taxonomy, for example
     * "/Apparel/Clothing/Outerwear".
     *
     * Generated from protobuf field <code>string display_info = 4;</code>
     */
    protected $display_info = '';
    /**
     * An estimate of the number of reachable YouTube users matching this
     * attribute in the requested location, or zero if that information is not
     * available for this attribute. This field is not populated in every
     * response.
     *
     * Generated from protobuf field <code>int64 potential_youtube_reach = 8;</code>
     */
    protected $potential_youtube_reach = 0;
    /**
     * The share of subscribers within this attribute, between and including 0 and
     * 1. This field is not populated in every response.
     *
     * Generated from protobuf field <code>double subscriber_share = 9;</code>
     */
    protected $subscriber_share = 0.0;
    protected $dimension_metadata;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $dimension
     *           The type of the attribute.
     *     @type \Google\Ads\GoogleAds\V18\Common\AudienceInsightsAttribute $attribute
     *           The attribute itself.
     *     @type string $display_name
     *           The human-readable name of the attribute.
     *     @type string $display_info
     *           A string that supplements the display_name to identify the attribute.
     *           If the dimension is TOPIC, this is a brief description of the
     *           Knowledge Graph entity, such as "American singer-songwriter".
     *           If the dimension is CATEGORY, this is the complete path to the category in
     *           The Product & Service taxonomy, for example
     *           "/Apparel/Clothing/Outerwear".
     *     @type int|string $potential_youtube_reach
     *           An estimate of the number of reachable YouTube users matching this
     *           attribute in the requested location, or zero if that information is not
     *           available for this attribute. This field is not populated in every
     *           response.
     *     @type float $subscriber_share
     *           The share of subscribers within this attribute, between and including 0 and
     *           1. This field is not populated in every response.
     *     @type \Google\Ads\GoogleAds\V18\Common\YouTubeChannelAttributeMetadata $youtube_channel_metadata
     *           Special metadata for a YouTube channel.
     *     @type \Google\Ads\GoogleAds\V18\Common\DynamicLineupAttributeMetadata $dynamic_attribute_metadata
     *           Special metadata for a YouTube Dynamic Lineup.
     *     @type \Google\Ads\GoogleAds\V18\Common\LocationAttributeMetadata $location_attribute_metadata
     *           Special metadata for a Location.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Ads\GoogleAds\V18\Common\AudienceInsightsAttribute::initOnce();
        parent::__construct($data);
    }

    /**
     * The type of the attribute.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v18.enums.AudienceInsightsDimensionEnum.AudienceInsightsDimension dimension = 1;</code>
     * @return int
     */
    public function getDimension()
    {
        return $this->dimension;
    }

    /**
     * The type of the attribute.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v18.enums.AudienceInsightsDimensionEnum.AudienceInsightsDimension dimension = 1;</code>
     * @param int $var
     * @return $this
     */
    public function setDimension($var)
    {
        GPBUtil::checkEnum($var, \Google\Ads\GoogleAds\V18\Enums\AudienceInsightsDimensionEnum\AudienceInsightsDimension::class);
        $this->dimension = $var;

        return $this;
    }

    /**
     * The attribute itself.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v18.common.AudienceInsightsAttribute attribute = 2;</code>
     * @return \Google\Ads\GoogleAds\V18\Common\AudienceInsightsAttribute|null
     */
    public function getAttribute()
    {
        return $this->attribute;
    }

    public function hasAttribute()
    {
        return isset($this->attribute);
    }

    public function clearAttribute()
    {
        unset($this->attribute);
    }

    /**
     * The attribute itself.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v18.common.AudienceInsightsAttribute attribute = 2;</code>
     * @param \Google\Ads\GoogleAds\V18\Common\AudienceInsightsAttribute $var
     * @return $this
     */
    public function setAttribute($var)
    {
        GPBUtil::checkMessage($var, \Google\Ads\GoogleAds\V18\Common\AudienceInsightsAttribute::class);
        $this->attribute = $var;

        return $this;
    }

    /**
     * The human-readable name of the attribute.
     *
     * Generated from protobuf field <code>string display_name = 3;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * The human-readable name of the attribute.
     *
     * Generated from protobuf field <code>string display_name = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * A string that supplements the display_name to identify the attribute.
     * If the dimension is TOPIC, this is a brief description of the
     * Knowledge Graph entity, such as "American singer-songwriter".
     * If the dimension is CATEGORY, this is the complete path to the category in
     * The Product & Service taxonomy, for example
     * "/Apparel/Clothing/Outerwear".
     *
     * Generated from protobuf field <code>string display_info = 4;</code>
     * @return string
     */
    public function getDisplayInfo()
    {
        return $this->display_info;
    }

    /**
     * A string that supplements the display_name to identify the attribute.
     * If the dimension is TOPIC, this is a brief description of the
     * Knowledge Graph entity, such as "American singer-songwriter".
     * If the dimension is CATEGORY, this is the complete path to the category in
     * The Product & Service taxonomy, for example
     * "/Apparel/Clothing/Outerwear".
     *
     * Generated from protobuf field <code>string display_info = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayInfo($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_info = $var;

        return $this;
    }

    /**
     * An estimate of the number of reachable YouTube users matching this
     * attribute in the requested location, or zero if that information is not
     * available for this attribute. This field is not populated in every
     * response.
     *
     * Generated from protobuf field <code>int64 potential_youtube_reach = 8;</code>
     * @return int|string
     */
    public function getPotentialYoutubeReach()
    {
        return $this->potential_youtube_reach;
    }

    /**
     * An estimate of the number of reachable YouTube users matching this
     * attribute in the requested location, or zero if that information is not
     * available for this attribute. This field is not populated in every
     * response.
     *
     * Generated from protobuf field <code>int64 potential_youtube_reach = 8;</code>
     * @param int|string $var
     * @return $this
     */
    public function setPotentialYoutubeReach($var)
    {
        GPBUtil::checkInt64($var);
        $this->potential_youtube_reach = $var;

        return $this;
    }

    /**
     * The share of subscribers within this attribute, between and including 0 and
     * 1. This field is not populated in every response.
     *
     * Generated from protobuf field <code>double subscriber_share = 9;</code>
     * @return float
     */
    public function getSubscriberShare()
    {
        return $this->subscriber_share;
    }

    /**
     * The share of subscribers within this attribute, between and including 0 and
     * 1. This field is not populated in every response.
     *
     * Generated from protobuf field <code>double subscriber_share = 9;</code>
     * @param float $var
     * @return $this
     */
    public function setSubscriberShare($var)
    {
        GPBUtil::checkDouble($var);
        $this->subscriber_share = $var;

        return $this;
    }

    /**
     * Special metadata for a YouTube channel.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v18.common.YouTubeChannelAttributeMetadata youtube_channel_metadata = 5;</code>
     * @return \Google\Ads\GoogleAds\V18\Common\YouTubeChannelAttributeMetadata|null
     */
    public function getYoutubeChannelMetadata()
    {
        return $this->readOneof(5);
    }

    public function hasYoutubeChannelMetadata()
    {
        return $this->hasOneof(5);
    }

    /**
     * Special metadata for a YouTube channel.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v18.common.YouTubeChannelAttributeMetadata youtube_channel_metadata = 5;</code>
     * @param \Google\Ads\GoogleAds\V18\Common\YouTubeChannelAttributeMetadata $var
     * @return $this
     */
    public function setYoutubeChannelMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Ads\GoogleAds\V18\Common\YouTubeChannelAttributeMetadata::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Special metadata for a YouTube Dynamic Lineup.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v18.common.DynamicLineupAttributeMetadata dynamic_attribute_metadata = 6;</code>
     * @return \Google\Ads\GoogleAds\V18\Common\DynamicLineupAttributeMetadata|null
     */
    public function getDynamicAttributeMetadata()
    {
        return $this->readOneof(6);
    }

    public function hasDynamicAttributeMetadata()
    {
        return $this->hasOneof(6);
    }

    /**
     * Special metadata for a YouTube Dynamic Lineup.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v18.common.DynamicLineupAttributeMetadata dynamic_attribute_metadata = 6;</code>
     * @param \Google\Ads\GoogleAds\V18\Common\DynamicLineupAttributeMetadata $var
     * @return $this
     */
    public function setDynamicAttributeMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Ads\GoogleAds\V18\Common\DynamicLineupAttributeMetadata::class);
        $this->writeOneof(6, $var);

        return $this;
    }

    /**
     * Special metadata for a Location.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v18.common.LocationAttributeMetadata location_attribute_metadata = 7;</code>
     * @return \Google\Ads\GoogleAds\V18\Common\LocationAttributeMetadata|null
     */
    public function getLocationAttributeMetadata()
    {
        return $this->readOneof(7);
    }

    public function hasLocationAttributeMetadata()
    {
        return $this->hasOneof(7);
    }

    /**
     * Special metadata for a Location.
     *
     * Generated from protobuf field <code>.google.ads.googleads.v18.common.LocationAttributeMetadata location_attribute_metadata = 7;</code>
     * @param \Google\Ads\GoogleAds\V18\Common\LocationAttributeMetadata $var
     * @return $this
     */
    public function setLocationAttributeMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Ads\GoogleAds\V18\Common\LocationAttributeMetadata::class);
        $this->writeOneof(7, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getDimensionMetadata()
    {
        return $this->whichOneof("dimension_metadata");
    }

}

