(function($) {
	$(function() {
		$('.motta-builder__toggle-button').on('change', '.motta-builder__enabled', function(e) {
			e.preventDefault();
			var $button = $(this),
				newState = 0,
				post_ID = $button.data("builder-id"),
				nonce = $button.data("nonce");

			if (true === e.target.checked) {
				newState = 1;
			}

			$(this).closest('table').addClass('motta-loading');

			$.ajax({
				type: "POST",
				dataType: "json",
				url: ajaxurl,
				data: {
					action: "motta_save_builder_enable",
					nonce: nonce,
					post_ID: post_ID,
					enabled: newState
				},
				success: function (response) {
					var $id = response.data;

					if( $id != '' ) {
						$('#builder_enabled_' + $id).prop('checked', false);
					}
					$button.closest('table').removeClass('motta-loading');
				}
			});
		});


		$( 'body.post-type-motta_builder #wpcontent' ).on( 'click', '.page-title-action', function(e) {
			e.preventDefault();
			var $button = $(this),
				$modal = $('#motta-builder-template-modal');

			$modal.fadeIn().addClass('modal--open');
		} );

		$( '#motta-builder-template-modal').on( 'click', '.modal__button-close, .modal__backdrop', function(e) {
			e.preventDefault();
			var $modal = $('#motta-builder-template-modal');

			$modal.fadeOut().removeClass('modal--open');
		} );

		$( '#motta-builder-template-modal__submit').on( 'click', function(e) {
			e.preventDefault();
			var $button = $(this),
				$form = $button.closest('.modal-content__form'),
				nonce = $form.find('._wpnonce').val(),
				post_title = $form.find('#motta-builder-template-modal__post-title').val(),
				template_type = $form.find('#motta-builder-template-modal-type').val(),
				set_default = $form.find('#motta-builder-template-modal__post-default').is(":checked") ? 'yes' : 'no';

			$form.find('.modal-content-form-message').html('');

			if( ! post_title ) {
				$form.find('#motta-builder-template-modal__post-title').focus();
				return false;
			}

			$button.addClass('motta-loading');

			$button.prop( 'disabled', true );

			$.ajax({
				type: "POST",
				dataType: "json",
				url: ajaxurl,
				data: {
					action: "motta_builder_template_type",
					nonce: nonce,
					post_title: post_title,
					template_type: template_type,
					set_default: set_default
				},
				success: function (response) {
					var $data = response.data;

					if( $data.id ) {
						var $action = $form.attr('action') + '?post=' + $data.id + '&action=elementor';
						window.location.replace($action);
					} else if( $data.message ) {
						$form.find('.modal-content-form-message').html( $data.message );
						$button.removeClass('motta-loading');
						$button.prop( 'disabled', false );
					} else {
						$button.removeClass('motta-loading');
						$button.prop( 'disabled', false );
					}

				}
			});
		} );

	});
})(jQuery);