class MottaProductViewWidgetHandler extends elementorModules.frontend.handlers.Base {
	getDefaultSettings() {
		return {
			selectors: {
				productView: '.motta-toolbar-view',
			}
		};
	}

	getDefaultElements() {
		const selectors = this.getSettings('selectors');
		return {
		  $productView: this.$element.find(selectors.productView),
		};
	}

	productView() {
		var self = this;
		this.elements.$productView.on('click', 'a', function (e) {
            e.preventDefault();
            var $el = jQuery(this),
                view = $el.data('view');

            if ($el.hasClass( 'current' )) {
                return;
            }

            $el.addClass( 'current' ).siblings().removeClass( 'current' );

			if( ! $el.hasClass( 'list' ) ) {
				$el.closest( '.site-main' ).find( '.product-actions' ).addClass( 'hidden' );
			}

            jQuery('body').removeClass('catalog-view-grid-2 catalog-view-grid-3 catalog-view-default catalog-view-grid-5 catalog-view-list').addClass('catalog-view-' + view);

            self.productViewSwich();

			if( ! $el.hasClass( 'list' ) ) {
				setTimeout( function() {
					$el.closest( '.site-main' ).find( '.product-actions' ).removeClass( 'hidden' );
				}, 100 );
			}

            document.cookie = 'catalog_view=' + view + ';domain=' + window.location.host + ';path=/';
        });

		self.productViewSwich();
	}

	productViewSwich() {
        if ( jQuery('body').hasClass( 'catalog-view-grid-2' ) ) {
            jQuery('body').find( 'ul.products' ).removeClass( 'columns-1 columns-3 columns-4 columns-5').addClass( 'columns-2'  );
		} else if ( jQuery('body').hasClass( 'catalog-view-grid-3' ) ) {
            jQuery('body').find( 'ul.products' ).removeClass( 'columns-1 columns-2 columns-4 columns-5').addClass( 'columns-3' );
        } else if( jQuery('body').hasClass( 'catalog-view-default' ) ) {
            jQuery('body').find( 'ul.products' ).removeClass( 'columns-1 columns-2 columns-3 columns-5' ).addClass( 'columns-4' );
        } else if( jQuery('body').hasClass( 'catalog-view-grid-5' ) ) {
            jQuery('body').find( 'ul.products' ).removeClass( 'columns-1 columns-2 columns-3 columns-4' ).addClass( 'columns-5' );
        } else if( jQuery('body').hasClass( 'catalog-view-list' ) ) {
            jQuery('body').find( 'ul.products' ).removeClass( 'columns-2 columns-3 columns-4 columns-5' ).addClass( 'columns-1' );
        }
    }

	onInit() {
		super.onInit();
		this.productView();
	}
}

class MottaArchiveProductsWidgetHandler extends elementorModules.frontend.handlers.Base {
	getDefaultSettings() {
		return {
			selectors: {
				products: '.motta-archive-products',
				navigation: '.woocommerce-navigation',
			}
		};
	}

	getDefaultElements() {
		const selectors = this.getSettings('selectors');
		return {
			$products: this.$element.find(selectors.products),
			$navigation: this.$element.find(selectors.navigation),
		};
	}

	ajaxLoadMore() {
		if ( ! this.elements.$navigation.hasClass( 'ajax-loadmore' ) ) {
			return;
		}
		var	self = this;
		this.elements.$navigation.on( 'click', 'a', function (event) {
			event.preventDefault();
			self.infiniteScroll();
		});
    }

	ajaxInfinite() {
		if ( ! this.elements.$navigation.hasClass( 'ajax-infinite' ) ) {
			return;
		}
		var	self = this,
			waiting = false,
			endScrollHandle;

		jQuery( window ).on( 'scroll', function() {
			if ( waiting ) {
				return;
			}

			waiting = true;

			clearTimeout( endScrollHandle );

			self.infiniteScroll();

			setTimeout( function() {
				waiting = false;
			}, 100 );

			endScrollHandle = setTimeout( function() {
				waiting = false;
				self.infiniteScroll();
			}, 200 );
		});

    }

	infiniteScroll() {
		if( ! this.elements.$navigation.hasClass('ajax-navigation') ) {
			return;
		}
		var	self = this,
			$navigation =  this.elements.$navigation,
			$button = jQuery( 'a', $navigation );

		if ( self.isVisible( $navigation ) && $button.length && !$navigation.hasClass( 'loading' ) ) {
			$navigation.addClass( 'loading' );

			self.loadProducts( $button, function( respond ) {
				$button = $navigation.find( 'a' );
			});
		}
	}

	loadProducts( $el, callback ) {
		var	self = this,
			$nav = this.elements.$navigation,
			totalProduct = $nav.closest('.motta-archive-products').children().find('.product').length,
			url = $el.attr( 'href' );

		jQuery.get( url, function( response ) {
			var $content = jQuery( '.motta-archive-products', response ),
				$list = jQuery( 'ul.products', $content ),
				numberPosts = $list.find( '.product' ).length + totalProduct,
				$products = $list.children(),
				$found = jQuery('.motta-posts-found'),
				$newNav = jQuery( '.woocommerce-navigation.ajax-navigation', $content );

			$products.each( function( index, product ) {
				jQuery( product ).css( 'animation-delay', index * 100 + 'ms' );
			} );

			$products.appendTo( $nav.parent().find( 'ul.products' ) );
			$products.addClass( 'animated mottaFadeInUp' );

			if ( $newNav.length ) {
				$el.replaceWith( jQuery( 'a', $newNav ) );
			} else {
				$nav.fadeOut( function() {
					$nav.remove();
				} );
			}

			if ( 'function' === typeof callback ) {
				callback( response );
			}

			jQuery('body').trigger( 'motta_products_loaded', [$products, true] );

			$found.find('.current-post').html(' ' + numberPosts);

			self.postsFound();

			$nav.removeClass( 'loading' );

			if ( mottaData.shop_nav_ajax_url_change ) {
				window.history.pushState( null, '', url );
			}
		});
	}

	postsFound () {
		var $found = jQuery( '.motta-posts-found__inner' ),
			$foundEls = $found.find( '.count-bar' ),
			$current = $found.find( '.current-post' ).html(),
			$total = $found.find( '.found-post' ).html(),
			pecent = ($current / $total) * 100;

		$foundEls.css( 'width', pecent + '%' );
	};

	isVisible( el ) {
		if ( el instanceof jQuery ) {
			el = el[0];
		}

		if ( ! el ) {
			return false;
		}

		var rect = el.getBoundingClientRect();

		return rect.bottom > 0 &&
			rect.right > 0 &&
			rect.left < (window.innerWidth || document.documentElement.clientWidth) &&
			rect.top < (window.innerHeight || document.documentElement.clientHeight);
	};

	onInit() {
		super.onInit();
		this.postsFound();
		this.ajaxInfinite();
		this.ajaxLoadMore();
	}
}

class MottaProductsFilterWidgetHandler extends elementorModules.frontend.handlers.Base {
	getDefaultSettings() {
		return {
			selectors: {
				filter: '.motta-products-filter',
			}
		};
	}

	getDefaultElements() {
		const selectors = this.getSettings('selectors');
		return {
			$filter: this.$element.find(selectors.filter),
		};
	}

	searchTerms() {
		var $this = jQuery( this ),
		term = $this.val().toLowerCase(),
		$list = $this.next( '.products-filter__options' ).find( '.products-filter__option' );

		if ( term ) {
			$list.hide().filter( function() {
				return jQuery( '.name', this ).text().toLowerCase().indexOf( term ) !== -1;
			} ).show();
		} else {
			$list.show();
		}
    }

	updatePrice(event) {
		event.preventDefault();
		var $item = jQuery( this ).closest( '.products-filter__option' ),
			$filter = $item.closest( '.filter' ),
			$value = $item.data('value'),
			$box = $filter.find('.product-filter-box');

		if ( ! $filter.hasClass( 'price' ) ) {
			return;
		}

		$box.find('input[name="min_price"]').val($value.min);
		$box.find('input[name="max_price"]').val($value.max);
	}

	toggleItem (event) {
		event.preventDefault();

		var $item = jQuery( this ).closest( '.products-filter__option' ),
			$filter = $item.closest( '.filter' ),
			$input = $item.closest( '.products-filter__options' ).next( 'input[type=hidden]' ),
			current = $input.val(),
			value = $item.data( 'value' ),
			form = $item.closest( 'form' ).get( 0 ),
			index = -1;

		if ( $filter.hasClass( 'multiple' ) ) {
			current = current ? current.split( ',' ) : [];
			index = current.indexOf( value );
			index = (-1 !== index) ? index : current.indexOf( value.toString() );

			if ( index !== -1 ) {
				current = _.without( current, value );
			} else {
				current.push( value );
			}

			$input.val( current.join( ',' ) );
			$item.toggleClass( 'selected' );

			$input.prop( 'disabled', current.length <= 0 );

			if ( $filter.hasClass( 'attribute' ) ) {
				var $queryTypeInput = $input.next( 'input[name^=query_type_]' );

				if ( $queryTypeInput.length ) {
					$queryTypeInput.prop( 'disabled', current.length <= 1 );
				}
			}
		} else {
			// @note: Ranges are always single selection.
			if ( $item.hasClass( 'selected' ) ) {
				$input.val( '' ).prop( 'disabled', true );
				$item.removeClass( 'selected' );
				if ( $filter.hasClass( 'ranges' ) ) {
					$input.next( 'input[type=hidden]' ).val( '' ).prop( 'disabled', true );

					$filter.find('input[name="min_price"]').val( '' ).prop( 'disabled', true );
					$filter.find('input[name="max_price"]').val( '' ).prop( 'disabled', true );
				}
			} else {
				$filter.find( '.products-filter__option.selected' );
				$item.addClass( 'selected' );
				$input.val( value ).prop( 'disabled', false );

				if ( $filter.hasClass( 'ranges' ) ) {
					$input.val( value.min ).prop( 'disabled', ! value.min );
					$input.next( 'input[type=hidden]' ).val( value.max ).prop( 'disabled', ! value.max );
				}

			}
		}

		if ( $filter.hasClass( 'products-filter--collapsible' ) && $item.children( 'ul' ).length ) {
			event.data.widget.checkToggleCollapse( $item );
		}

		jQuery( document.body ).trigger( 'motta_products_filter_change', [form] );
	}

	checkToggleCollapse( $item ) {
		var $children = $item.children( 'ul' );

		if ( ! $children.length ) {
			return;
		}

		if ( $item.hasClass( 'selected' ) && ! $item.hasClass( 'active' ) ) {
			$children.stop( true, true ).slideDown( function() {
				$item.addClass( 'active' );
			} );
		}

		if ( ! $item.hasClass( 'selected' ) && $item.hasClass( 'active' ) ) {
			// Don't close if subitems are selected.
			if ( $item.find( '.products-filter__option.selected' ).length ) {
				return;
			}

			$children.stop( true, true ).slideUp( function() {
				$item.removeClass( 'active' );
			} );
		}
	}

	toggleCollapse( event ) {
		var $option = jQuery( this ).closest( '.products-filter__option' ),
			$children = $option.children( 'ul' );

		if ( ! $children.length ) {
			return;
		}

		event.preventDefault();

		$children.stop( true, true ).slideToggle( function() {
			$option.toggleClass( 'active' );
		} );
	}

	triggerItemChange() {
		var form = jQuery( this ).closest( 'form' ).get( 0 );
		jQuery( document.body ).trigger( 'motta_products_filter_change', [form] );
	}

	resetFilters() {
		var $form = jQuery( this ).closest( 'form' );

		$form.get( 0 ).reset();
		$form.find( '.selected' ).removeClass( 'selected' );
		$form.find( 'select' ).val( '' ).trigger( 'change' ).prop('disabled', true);
		$form.find( ':input' ).not( '[type="button"], [type="submit"], [type="reset"]' )
			.val( '' )
			.trigger( 'change' )
			.filter('[type="hidden"],[name="min_price"], [name="max_price"]').prop('disabled', true);

		$form.trigger( 'submit' );
		jQuery( document.body ).trigger( 'motta_products_filter_reseted', [$form] );
	}

	removeFiltered( event ) {
		event.preventDefault();

		var $el = jQuery( this ),
			$widget = $el.closest( ' .products-filter-widget' ),
			$form = $widget.find( 'form' ),
			name = $el.data( 'name' ),
			key = name.replace( /^filter_/g, '' ),
			value = $el.data( 'value' ),
			$filter = $widget.find( '.filter.' + key );

		$el.remove();

		if ( $filter.length ) {
			var $input = $filter.find( ':input[name=' + name + ']' ),
				current = $input.val();

			if( name == 'price' ) {
				$filter.find(':input[name=min_price]').val('');
				$filter.find(':input[name=max_price]').val('');
				$filter.find('.products-filter__option').removeClass('selected');
			} else {
				if ( $input.is( 'select' ) ) {
					$input.prop( 'selectedIndex', 0 );
					$input.trigger( 'change' );
				} else {
					current = current.replace( ',' + value, '' );
					current = current.replace( value, '' );
					$input.val( current );

					if ( '' == current ) {
						$input.prop( 'disabled', true );
					}

					$filter.find( '[data-value="' + value + '"]' ).removeClass( 'selected' );
				}
			}

			$form.trigger( 'submit' );
		}
	}

	ajaxSearch( event ) {
		event.data.widget.sendAjaxRequest( this );
		return false;
	}

	collapseFilterWidget( event ) {
		if ( ! jQuery(this).closest( 'form' ).hasClass('has-collapse')) {
            return;
        }

		event.preventDefault();

		jQuery(this).next().slideToggle();
		jQuery(this).closest('.products-filter__filter').toggleClass('motta-active');
	}

	addListenerToSlider() {
		var $slider = this.elements.$filter.find( '.price_slider.ui-slider' );

		$slider.each( function() {
			var $el = jQuery( this ),
				form = $el.closest( 'form' ).get( 0 ),
				onChange = $el.slider( 'option', 'change' );

			$el.slider( 'option', 'change', function( event, ui ) {
				onChange( event, ui );

				jQuery( document.body ).trigger( 'motta_products_filter_change', [form] );
			} );
		} );
	}

	instantSearch( event, form ) {
		var settings = jQuery( form ).data( 'settings' );

		if ( ! settings.instant ) {
			return;
		}

		event.data.widget.sendAjaxRequest( form );
	}

	updateURL( event, response, url, form ) {
		var settings = jQuery( form ).data( 'settings' );

		if ( ! settings.change_url ) {
			return;
		}

		if ( '?' === url.slice( -1 ) ) {
			url = url.slice( 0, -1 );
		}

		url = url.replace( /%2C/g, ',' );

		history.pushState( null, '', url );
	}

	updateForm( event, response, url, form ) {
		var $widget = jQuery( form ).closest( '.elementor-widget-motta-wc-products-filter' ),
			widgetId = $widget.data( 'id' ),
			$newWidget = jQuery( '.elementor-widget-motta-wc-products-filter[data-id="' + widgetId + '"', response );

		if ( ! $newWidget.length ) {
			return;
		}

		jQuery( '.filters', form ).html( jQuery( '.filters', $newWidget ).html() );
		jQuery( '.products-filter__activated', $widget ).html( jQuery( '.products-filter__activated', $newWidget ).html() );

		jQuery( document.body ).trigger( 'motta_products_filter_widget_updated', [form] );
	}

	sendAjaxRequest( form ) {
		var self = this,
			$form = jQuery( form ),
			$container = jQuery('.motta-archive-products ul.products'),
			$notice = jQuery('.motta-archive-products .woocommerce-notices-wrapper'),
			$count = jQuery('.motta-result-count'),
			$page_header = jQuery('.page-header-elementor'),
			$breadcrumb = jQuery('.motta-woocommerce-breadcrumb'),
			$top_catetories = jQuery('.catalog-top-categories'),
			$inputs = $form.find(':input:not(:checkbox):not(:button)'),
			params = {},
			action = $form.attr('action'),
			separator = action.indexOf('?') !== -1 ? '&' : '?',
			url = action;

		params = $inputs.filter( function() {
			return this.value != '' && this.name != '';
		} ).serializeObject();


		if (params.min_price && params.min_price == $inputs.filter('[name=min_price]').data('min')) {
			delete params.min_price;
		}

		if (params.max_price && params.max_price == $inputs.filter('[name=max_price]').data('max')) {
			delete params.max_price;
		}

		// the filer always contains "filter" param
		// so it is empty if the size less than 2
		if ( _.size( params ) > 1 ) {
			url += separator + jQuery.param(params, true);
		}

		if ($container.hasClass('layout-carousel')) {
			window.location.href = url;
			return false;
		}

		if (!$container.length) {
			$container = jQuery('<ul class="products"/>');
			jQuery('#site-content .woocommerce-info').replaceWith($container);
		}

		if ( self.ajax ) {
			self.ajax.abort();
		}

		$form.addClass('filtering');
		$container.addClass('loading').append('<li class="loading-screen"><span class="mottaSpinner"></span></li>');

		if( $form.closest('.motta-products-filter--sidebar').hasClass('close-sidebar') ) {
			$form.closest('.motta-products-filter__form').fadeOut().removeClass('offscreen-panel--open');
			jQuery(document.body).removeClass('offcanvas-opened');
		}

		jQuery(document.body).trigger('motta_products_filter_before_send_request', $container);

		self.ajax = jQuery.get(url, function (response) {
			var $html = jQuery(response),
				$products = $html.find('.motta-archive-products ul.products'),
				$pagination = $container.next('.woocommerce-pagination'),
				$nav = $html.find('.woocommerce-navigation, .woocomerce-pagination');

			if (!$products.length) {
				var $info = $html.find('.motta-archive-products .woocommerce-info');
				$pagination.fadeOut();
				$container.fadeOut();
				$count.fadeOut();
				$notice.html($info);
				$notice.fadeIn();

			} else {
				var $nav = $products.next('.woocommerce-pagination'),
					$order = jQuery('form.woocommerce-ordering');

				if ($nav.length) {
					if ($pagination.length) {
						$pagination.replaceWith($nav).fadeIn();
					} else {
						$container.after($nav);
					}
				} else {
					$pagination.fadeOut();
				}
				$count.fadeIn();
				$notice.fadeOut();
				$container.fadeIn();
				$products.children().each(function (index, product) {
					jQuery(product).css('animation-delay', index * 100 + 'ms');
				});

				// Modify the ordering form.
				$inputs.each(function () {
					var $input = jQuery(this),
						name = $input.attr('name'),
						value = $input.val();

					if (name === 'orderby') {
						return;
					}

					if ('min_price' === name && value == $input.data('min')) {
						$order.find('input[name="min_price"]').remove();
						return;
					}

					if ('max_price' === name && value == $input.data('max')) {
						$order.find('input[name="max_price"]').remove();
						return;
					}

					$order.find('input[name="' + name + '"]').remove();

					if (value !== '' && value != 0) {
						jQuery('<input type="hidden" name="' + name + '">').val(value).appendTo($order);
					}
				});

				// Replace result count.
				$count.replaceWith($html.find('.motta-result-count'));

				$page_header.replaceWith($html.find('.page-header-elementor'));

				$breadcrumb.replaceWith($html.find('.motta-woocommerce-breadcrumb'));

				$top_catetories.replaceWith($html.find('.catalog-top-categories'));

				$container.replaceWith($products);
				$products.find('li.product').addClass('animated mottaFadeInUp');

				jQuery(document.body).trigger('motta_products_loaded', [$products.children(), false]); // appended = false
			}

			$form.removeClass('filtering');
			jQuery(document.body).trigger('motta_products_filter_request_success', [response, url, form]);
		});
	}

	viewMoreCats(event) {
		var $filter = event ? event.data.widget.elements.$filter : this.elements.$filter,
			$widget = $filter.find('.product_cat'),
			$widgetChild = $filter.find('.products-filter--show-children-only'),
			$items = $widget.find('.products-filter--list > .filter-list-item, .products-filter--checkboxes > .filter-checkboxes-item'),
			catNumbers = parseInt($widget.find('input.widget-cat-numbers').val(), 10);

		if (!$widget.hasClass('products-filter--view-more')) {
			return;
		}

		if ( $widgetChild.find('.products-filter__option').hasClass('selected') ) {
			$items = $widgetChild.find('ul.products-filter--list li.selected .children > .filter-list-item, ul.products-filter--checkboxes li.selected .children > .filter-checkboxes-item');
		}

		var count = $widget.find( $items ).size();

		if (count > catNumbers) {
			$widget.find('.show-more').show();

			if ( $widgetChild.find('ul.products-filter__options > .products-filter__option').hasClass( 'selected' ) ) {
				$widgetChild.find( '.motta-widget-product-cats-btn' ).addClass( 'btn-children' );
			}
		}

		$widget.find('ul.products-filter--list > .filter-list-item:lt(' + catNumbers + ')').show();
		$widget.find('ul.products-filter--checkboxes > .filter-checkboxes-item:lt(' + catNumbers + ')').show();

		$widgetChild.find('ul.products-filter--list li.selected .children > .filter-list-item:lt(' + catNumbers + ')').show();
		$widgetChild.find('ul.products-filter--checkboxes li.selected .children > .filter-checkboxes-item:lt(' + catNumbers + ')').show();

		$widget.on('click', '.show-more', function () {
			$widget.find( $items ).show();
			jQuery(this).hide();
			$widget.find('.show-less').show();
			$widget.find( '.motta-widget-product-cats-btn' ).addClass( 'btn-show-item' );
		});

		$widget.on('click', '.show-less', function () {
			$widget.find( 'ul.products-filter--list > .filter-list-item' ).not(':lt(' + catNumbers + ')').hide();
			$widget.find( 'ul.products-filter--checkboxes > .filter-checkboxes-item' ).not(':lt(' + catNumbers + ')').hide();
			$widgetChild.find( 'ul.products-filter--list li.selected .children > .filter-list-item' ).not(':lt(' + catNumbers + ')').hide();
			$widgetChild.find( 'ul.products-filter--checkboxes li.selected .children > .filter-checkboxes-item' ).not(':lt(' + catNumbers + ')').hide();
			jQuery(this).hide();
			$widget.find('.show-more').show();
			$widget.find( '.motta-widget-product-cats-btn' ).removeClass( 'btn-show-item' );
		});
	}

	initDropdowns( event, form ) {
		if ( ! jQuery.fn.select2 ) {
			return;
		}

		var $container = form ? jQuery( form ) : this.elements.$filter,
			direction = jQuery( document.body ).hasClass( 'rtl' ) ? 'rtl' : 'ltr';

		jQuery( 'select', $container ).each( function() {
			var $select = jQuery( this ),
				$searchBoxText = $select.prev( '.products-filter__search-box' ),
				searchText = $searchBoxText.length ? $searchBoxText.text() : false;

			$select.select2( {
				dir: direction,
				width: '100%',
				minimumResultsForSearch: searchText ? 3 : -1,
				dropdownCssClass: 'products-filter-dropdown',
				dropdownParent: $select.parent()
			} );
		} );
	}

	initSliders( event, form ) {
		jQuery( document.body ).trigger( 'init_price_filter' );

		event.data.widget.removeSliderInputs( form );
	}

	updateActivatedItems( event, form ) {
		var $container = form ? jQuery( form ) : this.elements.$filter;

		if ( jQuery.trim( $container.find( '.products-filter__activated-items' ).html() ) ) {
			$container.find('.products-filter__activated').removeClass( 'hidden' );
		} else {
			$container.find('.products-filter__activated').addClass( 'hidden' );
		}
	}

	removeSliderInputs( form ) {
		var $container = form ? jQuery( form ) : this.elements.$filter;

		jQuery( '.widget_price_filter', $container ).find( 'input[type=hidden]' ).not( '[name=min_price], [name=max_price]' ).remove();
	}


	collapseFilterWidgetMobile( event ) {
		if ( ! this.elements.$filter.find( 'form' ).hasClass('has-collapse')) {
            return;
        }

		var $this = this.elements.$filter.find('.products-filter__filter');
		jQuery(window).on('resize', function () {
			if (jQuery(window).width() < 768) {
				$this.addClass('motta-active');
			} else {
				$this.removeClass('motta-active');
				$this.find('.products-filter__filter-control').removeAttr('style');
			}

		}).trigger('resize');

	}

	scrollFilters() {
		if( ! jQuery(".motta-archive-products").length ) {
			return;
		}

		var $height = 0;

		jQuery(window).on( 'resize', function () {
			if ( jQuery(window).width() < 1024 ) {
				jQuery( '.motta-products-filter__form' ).removeClass( 'offscreen-panel--open' ).fadeOut();
				$height += 100;
			} else {
				var $sticky 	= jQuery( document.body ).hasClass('motta-header-sticky') ? jQuery( '#site-header .header-sticky' ).outerHeight() : 0,
					$wpadminbar = jQuery('#wpadminbar').is(":visible") ? jQuery('#wpadminbar').height() : 0;

					$height 	= $sticky + $wpadminbar + 150;
			}
		}).trigger( 'resize' );

		jQuery( document.body ).removeAttr('style');
		jQuery( document.body ).removeClass( 'offcanvas-opened' );

		jQuery('html,body').stop().animate({
				scrollTop: jQuery(".motta-archive-products").offset().top - $height
			},
		'slow');

	}

	mobileFilters() {
		if( this.elements.$filter.hasClass('motta-products-filter--sidebar') ) {
			return;
		}
		var $selector = this.elements.$filter.find('.motta-products-filter__form');
		jQuery(window).on('resize', function () {
            if (jQuery(window).width() > 1024) {
                if ($selector.hasClass('offscreen-panel')) {
                    $selector.removeClass('offscreen-panel offscreen-panel--side-left').removeAttr('style');
                }
            } else {
                $selector.addClass('offscreen-panel offscreen-panel--side-left');
            }

        }).trigger('resize');
	}

	onInit() {
		super.onInit();
		this.initDropdowns();
		this.removeSliderInputs();
		this.viewMoreCats('');
		this.collapseFilterWidgetMobile();
		this.mobileFilters();

		this.elements.$filter
		.on( 'input', '.products-filter__search-box', this.searchTerms )
		.on( 'click', '.products-filter__option-name', this.updatePrice)
		.on( 'click', '.products-filter__option-name, .products-filter__options .swatch', { widget: this }, this.toggleItem)
		.on( 'click', '.products-filter--collapsible .products-filter__option-toggler', this.toggleCollapse )
		.on( 'change', 'input, select', this.triggerItemChange )
		.on( 'click', '.reset-button', this.resetFilters )
		.on( 'click', '.remove-filtered', this.removeFiltered )
		.on( 'submit', 'form.ajax-filter', { widget: this }, this.ajaxSearch )
		.on( 'click', '.products-filter__filter-name', this.collapseFilterWidget );

		jQuery( document.body )
		.on( 'price_slider_create', this.addListenerToSlider )
		.on( 'motta_products_filter_change', { widget: this }, this.instantSearch )
		.on( 'motta_products_filter_request_success', this.updateURL )
		.on( 'motta_products_filter_request_success', this.updateForm )
		.on( 'motta_products_filter_request_success', { widget: this }, this.viewMoreCats )
		.on( 'motta_products_filter_widget_updated', this.initDropdowns )
		.on( 'motta_products_filter_widget_updated', { widget: this }, this.initSliders )
		.on( 'motta_products_filter_widget_updated', this.updateActivatedItems )
		.on( 'motta_products_filter_before_send_request', this.scrollFilters);
	}
}
class MottaProductsOrderingWidgetHandler extends elementorModules.frontend.handlers.Base {
	getDefaultSettings() {
		return {
			selectors: {
				orderby: '.motta-product-ordering__modal',
			}
		};
	}

	getDefaultElements() {
		const selectors = this.getSettings('selectors');
		return {
		  	$orderby: this.$element.find(selectors.orderby),
		};
	}

	productOrderBy() {
		var $selector = this.elements.$orderby,
			$orderForm = $selector.find('.woocommerce-ordering');

		$selector.find('.orderby-list, .mobile-orderby-list').on('click', 'a', function (e) {
            e.preventDefault();

			var value = jQuery(this).data('id'),
				title = jQuery(this).data('title');

			// Click selectd item popup order list
			$selector.find('.mobile-orderby-list .selected').removeClass('selected');
			jQuery(this).addClass( 'selected' );

			// Change text button sort by
			if(  ! $selector.hasClass('motta-product-ordering__dropdown') ) {
				jQuery('.mobile-catalog-toolbar__sort-button .name').html(title);
			}

			// Select content form order
			$orderForm.find('option:selected').attr("selected", false);
			$orderForm.find('option[value='+ value +']').attr("selected", "selected");

			$orderForm.trigger( 'submit' );

			jQuery(this).closest('.motta-product-ordering__dropdown').toggleClass('show-dropdown');
        });

		// Active Item
		var activeName = $orderForm.find('option:selected').text(),
			activeVal = $orderForm.find('option:selected').val();

		$selector.find('.mobile-catalog-toolbar__sort-button .name').html(activeName);
		$selector.find('.mobile-orderby-list a[data-id='+ activeVal +']').addClass('selected');
	}

	orderByDropdown() {
		var $selector = this.elements.$orderby;
		if( ! $selector.hasClass('motta-product-ordering__dropdown') ) {
			return;
		}
		$selector.on('click', '.motta-product-ordering__button-dropdown', function() {
			jQuery(this).closest('.motta-product-ordering__dropdown').toggleClass('show-dropdown');
		});

		jQuery( document.body ).on( 'click', 'div', function( event ) {
			var $target = jQuery( event.target );

			if ( $target.is( '.motta-product-ordering__dropdown' ) || $target.closest( '.motta-product-ordering__dropdown' ).length ) {
				return;
			}

			$selector.removeClass('show-dropdown');
		} );
	}

	onInit() {
		super.onInit();
		this.productOrderBy();
		this.orderByDropdown();
	}
}

class MottaArchiveProductCategioriesWidgetHandler extends elementorModules.frontend.handlers.Base {
	getDefaultSettings() {
		return {
			selectors: {
				categories: '.catalog-top-categories__layout-v1',
			}
		};
	}

	getDefaultElements() {
		const selectors = this.getSettings('selectors');
		return {
		  	$categories: this.$element.find(selectors.categories),
		};
	}

	topCategories() {
		var $container = this.elements.$categories.find( '.catalog-top-categories__wrapper' );

		$container.addClass( 'swiper-container' ).wrapInner( '<div class="swiper-wrapper"></div>' );
		$container.append( '<div class="swiper-pagination"></div>' );
		$container.find( '.catalog-top-categories__item' ).addClass( 'swiper-slide' );
		$container.after('<span class="motta-svg-icon motta-swiper-button-prev motta-swiper-button swiper-button"><svg viewBox="0 0 19 32"><path d="M13.552 0.72l2.656 1.76-9.008 13.52 9.008 13.52-2.656 1.76-10.192-15.28z"></path></svg></span>');
        $container.after('<span class="motta-svg-icon motta-swiper-button-next motta-swiper-button swiper-button"><svg viewBox="0 0 19 32"><path d="M5.648 31.28l-2.656-1.76 9.008-13.52-9.008-13.52 2.656-1.76 10.192 15.28z"></path></svg></span>');

		var $container,
			options = {
				observer: true,
    			observeParents: true,
				slidesPerView: "auto",
				spaceBetween: 0,
				navigation: {
					nextEl: '.motta-swiper-button-next',
					prevEl: '.motta-swiper-button-prev',
				},
				pagination: {
					el: $container.find( '.swiper-pagination' ).get(0),
					clickable: true,
				},
			};

		new Swiper( $container.get(0), options );

		jQuery(window).resize( function () {
			$container.find( '.swiper-pagination .swiper-pagination-bullet' ).first().trigger( 'click' );
		}).trigger( 'resize' );

		if( $container.find( '.active' ).length == 0 ) {
			$container.find( '.catalog-top-categories__item' ).first().addClass( 'active' );
		}
	};

	onInit() {
		super.onInit();
		this.topCategories();
	}
}

class MottaArchiveProductsFilterActivedsWidgetHandler extends elementorModules.frontend.handlers.Base {
	getDefaultSettings() {
		return {
			selectors: {
				currenActived: '.motta-products-filter-actived',
				filterActived: '.motta-products-filter'
			}
		};
	}

	getDefaultElements() {
		const selectors = this.getSettings('selectors');
		return {
			$currentActived: this.$element.find(selectors.currenActived),
			$filterActived: jQuery(selectors.filterActived),
			$filterItemsActived: jQuery(selectors.filterActived).find('.products-filter__activated-items'),
			$filterRemoveAll: jQuery(selectors.filterActived).find('.products-filter__activated-heading .reset-button'),
		};
	}

	filterActived() {
		if( ! this.elements.$filterItemsActived.length ) {
			return;
		}
		if( jQuery.trim( this.elements.$filterItemsActived.html() ) ) {
			this.elements.$currentActived.html( this.elements.$filterItemsActived.html() );
			this.elements.$filterRemoveAll.addClass('remove-filtered-all');
			this.elements.$currentActived.append( this.elements.$filterRemoveAll );
		}
	};

	updateFilterActived() {
		var $currentActived = this.elements.$currentActived;
		jQuery(document.body).on( 'motta_products_filter_widget_updated', function (e, form) {
			var $filterForm = jQuery(form).closest('.motta-products-filter'),
				$productFilterActived = $filterForm.find('.products-filter__activated-items'),
				$removeAll = $filterForm.find('.products-filter__activated-heading .reset-button');

			if( jQuery.trim( $productFilterActived.html() ) ) {
				$currentActived.html( $productFilterActived.html() );
				$removeAll.addClass('remove-filtered-all');
				$currentActived.append( $removeAll );
			}
        });

		jQuery(document.body).on( 'motta_products_filter_reseted', function (e, form) {
			$currentActived.html('');
        });
	};

	removeFilterActived() {
		var $filterActived = this.elements.$filterActived,
			$currentActived = this.elements.$currentActived;
			$currentActived.on( 'click', '.remove-filtered', function (e) {
            var value = jQuery(this).data( 'value' ),
				$filterItemsActived = $filterActived.find('.products-filter__activated-items');
            if ( value !== 'undefined' ) {
                jQuery(this).remove();
                $filterItemsActived.find( ".remove-filtered[data-value='" + value + "']" ).trigger( 'click' );
            }

			if( ! $currentActived.find('.remove-filtered').length ) {
				$currentActived.html('');
			}

            return false;
        });
	};

	removeAllFilterActived() {
		var $currentActived = this.elements.$currentActived,
			$filterActived = this.elements.$filterActived;
		$currentActived.on( 'click', '.remove-filtered-all', function (e) {
			e.preventDefault();
			var $filterItemsActived = $filterActived.find('.products-filter__activated-items');

			$currentActived.html('');
			if( $filterItemsActived.find( '.products-filter__button .reset-button' ).length ) {
				$filterItemsActived.find( '.products-filter__button .reset-button' ).trigger( 'click' );
			} else {
				$filterActived.find( '.products-filter__button .reset-button' ).trigger( 'click' );
			}

        });
	};

	onInit() {
		super.onInit();
		this.filterActived();
		this.updateFilterActived();
		this.removeFilterActived();
		this.removeAllFilterActived();
	}
}

jQuery( window ).on( 'elementor/frontend/init', () => {
	elementorFrontend.hooks.addAction( 'frontend/element_ready/motta-archive-product-view.default', ( $element ) => {
		elementorFrontend.elementsHandler.addHandler( MottaProductViewWidgetHandler, { $element } );
	} );

	elementorFrontend.hooks.addAction( 'frontend/element_ready/motta-archive-products.default', ( $element ) => {
		elementorFrontend.elementsHandler.addHandler( MottaArchiveProductsWidgetHandler, { $element } );
	} );

	elementorFrontend.hooks.addAction( 'frontend/element_ready/motta-wc-products-filter.default', ( $element ) => {
		elementorFrontend.elementsHandler.addHandler( MottaProductsFilterWidgetHandler, { $element } );
	} );

	elementorFrontend.hooks.addAction( 'frontend/element_ready/motta-archive-product-ordering.default', ( $element ) => {
		elementorFrontend.elementsHandler.addHandler( MottaProductsOrderingWidgetHandler, { $element } );
	} );

	elementorFrontend.hooks.addAction( 'frontend/element_ready/motta-archive-product-categories.default', ( $element ) => {
		elementorFrontend.elementsHandler.addHandler( MottaArchiveProductCategioriesWidgetHandler, { $element } );
	} );

	elementorFrontend.hooks.addAction( 'frontend/element_ready/motta-products-filter-actived.default', ( $element ) => {
		elementorFrontend.elementsHandler.addHandler( MottaArchiveProductsFilterActivedsWidgetHandler, { $element } );
	} );
} );
