class MottaProductImagesWidgetHandler extends elementorModules.frontend.handlers.Base {
	getDefaultSettings() {
		return {
			selectors: {
				productGallery: '.woocommerce-product-gallery',
				parentGallery: '.product-gallery-summary'
			}
		};
	}

	getDefaultElements() {
		const selectors = this.getSettings('selectors');
		return {
		  $productGallery: this.$element.find(selectors.productGallery),
		  $parentGallery: this.$element.find(selectors.parentGallery)
		};
	}

	productThumbnails() {
		const $gallery = this.elements.$productGallery,
			$settings = this.getElementSettings();
		$gallery.imagesLoaded(function () {
			var columns = $settings.thumbnails_per_view ? $settings.thumbnails_per_view : 5,
				thumbnails_position = $settings.thumbnails_position,
				$thumbnail = $gallery.find('.flex-control-thumbs');

			$thumbnail.wrap('<div class="woocommerce-product-gallery__thumbs-carousel"></div>');
			$thumbnail.before('<span class="motta-svg-icon motta-thumbs-button-prev motta-swiper-button"><svg viewBox="0 0 19 32"><path d="M13.552 0.72l2.656 1.76-9.008 13.52 9.008 13.52-2.656 1.76-10.192-15.28z"></path></svg></span>');
			$thumbnail.after('<span class="motta-svg-icon motta-thumbs-button-next motta-swiper-button"><svg viewBox="0 0 19 32"><path d="M5.648 31.28l-2.656-1.76 9.008-13.52-9.008-13.52 2.656-1.76 10.192 15.28z"></path></svg></span>');
			$thumbnail.wrap('<div class="swiper-container" style="opacity:0"></div>');
			$thumbnail.addClass('swiper-wrapper');
			$thumbnail.find('li').addClass('swiper-slide');

			var options = {
				loop: false,
				autoplay: false,
				speed: 800,
				spaceBetween: 15,
				slidesPerView: columns,
				slidesPerGroup: 1,
				watchOverflow: true,
				navigation: {
					nextEl: '.motta-thumbs-button-next',
					prevEl: '.motta-thumbs-button-prev',
				},
				on: {
					init: function () {
						setTimeout(function () {
							$thumbnail.parent().css('opacity', 1);
							$thumbnail.css('opacity', 1);
						}, 100);
					}
				},
				breakpoints: {
					300: {
						slidesPerView: 3,
						spaceBetween: 10,
						allowTouchMove: false,
					},
					768: {
						slidesPerView: 4,
					},
					992: {
						slidesPerView: columns,
						spaceBetween: 15,
					},
				}
			};

			if (thumbnails_position == 'left') {
				options.direction = 'vertical';
			} else {
				options.direction = 'horizontal';
			}

			new Swiper($thumbnail.parent().get(0), options);

			// Add an <span> to thumbnails for responsive bullets.
			jQuery('li', $thumbnail).append('<span/>');
		});
	}

	productDegree () {
        var $product_degrees = this.elements.$parentGallery.find('.motta-button--product-degree');

        if ( $product_degrees.length < 1 ) {
            return;
        }

        var degree = '',
            $pswp = this.elements.$parentGallery.find('.product-degree-pswp');

        $product_degrees.on('click', function (e) {
            e.preventDefault();

			var options = jQuery(this).data('options');

			if( ! options['total_frames'] ) {
				return false;
			}

			$pswp.fadeIn();
			$pswp.addClass('modal--open');

            if ($pswp.hasClass('init')) {
                return;
            }
            $pswp.addClass('init');

            degree = $pswp.find('.motta-product-gallery-degree').ThreeSixty({
                totalFrames: options['total_frames'], // Total no. of image you have for 360 slider
                endFrame: options['total_frames'], // end frame for the auto spin animation
                currentFrame: 1, // This the start frame for auto spin
                imgList: $pswp.find('.product-degree__images'), // selector for image list
                progress: '.motta-gallery-degree__spinner', // selector to show the loading progress
                imgArray: options['images'], // path of the image assets
                height: 500,
                width: 830,
                navigation: false
            });

            $pswp.on('click', '.nav-bar__run', function () {
                jQuery(this).addClass('active');
                degree.play();
            });

            $pswp.on('click', '.nav-bar__run.active', function () {
                jQuery(this).removeClass('active');
                degree.stop();
            });

            $pswp.on('click', '.nav-bar__next', function () {
                degree.stop();
                jQuery('.nav-bar__run').removeClass('active');
                degree.next();
            });

            $pswp.on('click', '.nav-bar__prev', function () {
                degree.stop();
                jQuery('.nav-bar__run').removeClass('active');
                degree.previous();
            });

            $pswp.on('click', '.modal__button-close, .modal__backdrop', function () {
                degree.stop();
                jQuery('.nav-bar__run').removeClass('active');
            });
        });
    };

	productVideo () {
		var $product_video = this.elements.$parentGallery.find('.motta-button--video');

        if ( $product_video.length < 1 ) {
            return;
        }

		var options = {
            type: 'iframe',
            mainClass: 'mfp-fade',
            removalDelay: 300,
            preloader: false,
            fixedContentPos: false,
            iframe: {
                markup: '<div class="mfp-iframe-scaler">' +
                        '<div class="mfp-close"></div>' +
                        '<iframe class="mfp-iframe" frameborder="0" allow="autoplay"></iframe>' +
                        '</div>',
                patterns: {
                    youtube: {
                        index: 'youtube.com/', // String that detects type of video (in this case YouTube). Simply via url.indexOf(index).

                        id: 'v=', // String that splits URL in a two parts, second part should be %id%
                        src: 'https://www.youtube.com/embed/%id%?autoplay=1' // URL that will be set as a source for iframe.
                    },
                    vimeo: {
                        index: 'vimeo.com/',
                        id: '/',
                        src: '//player.vimeo.com/video/%id%?autoplay=1'
                    }
                },

                srcAction: 'iframe_src', // Templating object key. First part defines CSS selector, second attribute. "iframe_src" means: find "iframe" and set attribute "src".
            }
        };

        $product_video.magnificPopup(options);
	}

	productFullScreen() {
		var $parentGallery = this.elements.$parentGallery;
		$parentGallery.find( '.woocommerce-product-gallery__image' ).on( 'click', 'a', function (e) {
            e.preventDefault();
        });

        $parentGallery.on( 'click', '.motta-button--product-lightbox', function() {
            if( $parentGallery.find( '.woocommerce-product-gallery__trigger' ).length > 0 ) {
                $parentGallery.find( '.woocommerce-product-gallery__trigger' ).trigger( 'click' );
            } else {
                $parentGallery.find('.flex-viewport .woocommerce-product-gallery__image.flex-active-slide a').trigger( 'click' );
            }
        });
	}

	fractionsProductSlider() {
        var $gallery = this.elements.$productGallery.find('.woocommerce-product-gallery__wrapper').children(),
            $total   = $gallery.length,
            $current = 0;

        $gallery.each( function ( key ) {
            $current = key + 1;
            jQuery(this).find('a').append( '<span class="motta-product-slider__fractions">' + $current + '/' + $total + '</span>' );
        });
     }

	fixedGallery() {
		if( ! jQuery('body').hasClass('mobile-fixed-product-gallery')) {
			return;
		}

		var $productGallery = this.elements.$productGallery;

		jQuery(window).on('resize', function () {
			if( jQuery(window).width() > 767 ) {
				$productGallery.removeClass('has-scroll');
				$productGallery.removeAttr('style');
			} else {
				$productGallery.addClass('has-scroll');
			}
		}).trigger('resize');

		var noticeHeight = jQuery('.single-product').find('.woocommerce-notices-wrapper').outerHeight(true);
		if( jQuery('body').hasClass('admin-bar') ) {
			noticeHeight += 46;
		}
        if( noticeHeight > 0 ) {
            $productGallery.css({top: noticeHeight + 10})
        }

        setTimeout(function () {
            var imageHeight = jQuery('.woocommerce-product-gallery .woocommerce-product-gallery__image > a').height(),
                imageWidth = jQuery('.woocommerce-product-gallery .woocommerce-product-gallery__image > a').width(),
                ratio = imageHeight && imageWidth ? imageHeight/imageWidth : 0;
            if( ratio && ratio !== 1 ) {
                jQuery('.product-fixed-gallery-spacing').css('--motta-product-fixed-gallery-spacing', ratio * 100 + 'vw' );
            }
        }, 200);

		jQuery(window).on('scroll', function () {
			if( ! $productGallery.hasClass('has-scroll')) {
				return;
			}
            var wScrollTop = jQuery(window).scrollTop(),
                galleryHeight = $productGallery.outerHeight(true),
                opacityValue = 0;
            if (wScrollTop > 0) {
                if( galleryHeight < wScrollTop ) {
                    opacityValue = 0;
                } else {
                    opacityValue = (galleryHeight - wScrollTop) / galleryHeight;
                }
            } else {
                opacityValue = 1;
            }

            $productGallery.css({opacity: opacityValue});

        }).trigger('scroll');
	}

	onInit() {
		super.onInit();

		var self = this;
		self.productThumbnails();
		this.elements.$productGallery.on('product_thumbnails_slider_horizontal', function() {
			self.productThumbnails();
		} );
		this.productDegree();
		this.productVideo();
		this.productFullScreen();
		this.fixedGallery();
		this.fractionsProductSlider();
	}
}

class MottaProductVariationWidgetHandler extends elementorModules.frontend.handlers.Base {
	getDefaultSettings() {
		return {
			selectors: {
				atcfrom: '.motta-elementor-add-to-cart',
			}
		};
	}

	getDefaultElements() {
		const selectors = this.getSettings('selectors');
		return {
		  $atcfrom: this.$element.find(selectors.atcfrom),
		};
	}

	productVariation() {
		var $price = this.elements.$atcfrom.closest('div.product').find( '.elementor-widget-motta-wc-product-price .price' ).html(),
		$stock = this.elements.$atcfrom.closest('div.product').find( '.elementor-widget-motta-wc-product-stock .stock, .elementor-widget-motta-wc-product-add-to-cart .motta-quantity-wrapper .stock' ).clone(),
		$date_onsale_to = this.elements.$atcfrom.closest('div.product').find( '.elementor-widget-motta-wc-product-badge .woocommerce-badge--text' ).html();


		this.elements.$atcfrom.find('.variations_form').on( 'show_variation', function () {
			var $container          = jQuery(this).closest( 'div.product' ),
				$price_new          = jQuery(this).find( '.woocommerce-variation-price .price' ).html(),
				$stock_new          = jQuery(this).find( '.woocommerce-variation-availability .stock' ).clone(),
				$variation_id       = jQuery(this).find( '.variation_id' ).val(),
				$date_onsale_to_new = jQuery(this).find( '.variation-id-' + $variation_id ).html();

			$container.find( '.elementor-widget-motta-wc-product-price .price' ).html( $price_new );
			$container.find( '.elementor-widget-motta-wc-product-stock .stock, .elementor-widget-motta-wc-product-add-to-cart .motta-quantity-wrapper .stock' ).replaceWith( $stock_new );

			if( $date_onsale_to && $variation_id !== '0' ) {
				$container.find( '.woocommerce-badge--text' ).html( $date_onsale_to_new );
			}
		});

		this.elements.$atcfrom.find('.variations_form').on( 'hide_variation', function () {
			var $container          = jQuery(this).closest( 'div.product' );
			$container.find( '.elementor-widget-motta-wc-product-price .price' ).html( $price );
			$container.find( '.elementor-widget-motta-wc-product-stock .stock, .elementor-widget-motta-wc-product-add-to-cart .motta-quantity-wrapper .stock' ).replaceWith( $stock );

			if( $date_onsale_to ) {
				$container.find( '.elementor-widget-motta-wc-product-badge .woocommerce-badge--text' ).html( $date_onsale_to );
			}
		});
	}

	productQty() {
		if( ! this.elements.$atcfrom.find( '.quantity__label-number' ).length ) {
			return;
		}
		var	$quantity = this.elements.$atcfrom.find( '.quantity input[name="quantity"]' );

		this.elements.$atcfrom.find( '.quantity__label-number' ).text( $quantity.val() );

		$quantity.on( 'change', function() {
			jQuery(this).closest( '.motta-elementor-add-to-cart' ).find( '.quantity__label-number' ).text( jQuery(this).val() );
		});
	}

	onInit() {
		super.onInit();
		this.productVariation();
		this.productQty();
	}
}

class MottaProductDataTabsWidgetHandler extends elementorModules.frontend.handlers.Base {
	getDefaultSettings() {
		return {
			selectors: {
				tabs: '.woocommerce-tabs',
			}
		};
	}

	getDefaultElements() {
		const selectors = this.getSettings('selectors');
		return {
		  $tabs: this.$element.find(selectors.tabs),
		};
	}

	productTabsToggle() {
		if( ! this.$element.hasClass('motta-product-tabs-type--toggle') ) {
			return;
		}

		this.productTabsSlide();

	}

	responsiveProductTabs() {
		if( this.$element.hasClass('motta-product-tabs-type--toggle') ) {
			return;
		}
		var	self = this,
			$tabs = this.elements.$tabs;
		jQuery(window).on( 'resize', function () {
			if( jQuery(window).width() < 767 ) {
				$tabs.find('.motta-dropdown__title').addClass('has-toggle');

				if( self.$element.hasClass('motta-product-first-tab-mobile--yes') ) {
					self.productFirstTab();
				}

			} else {
				$tabs.find('.motta-dropdown__title').removeClass('has-toggle');
				$tabs.find('.motta-dropdown__content').removeAttr('style');
				$tabs.find('.motta-dropdown__title').removeClass( 'active' );
            }
        }).trigger('resize');

		this.productTabsSlide(true);

	}

	productTabsSlide($responsive = false) {
		var $tabs = this.elements.$tabs;
		$tabs.on('click', '.motta-dropdown__title', function (e) {
            e.preventDefault();

			if( $responsive && ! jQuery(this).hasClass('has-toggle') ) {
				return;
			}

            if (jQuery(this).hasClass('active')) {
                jQuery(this).removeClass('active');
                jQuery(this).siblings('.motta-dropdown__content').stop().slideUp("slow");
            } else {
                $tabs.find('.motta-dropdown__title').removeClass('active');
                $tabs.find('.motta-dropdown__content').slideUp();
                jQuery(this).addClass('active');
                jQuery(this).siblings('.motta-dropdown__content').stop().slideDown("slow");
				jQuery('html, body').animate({
                    scrollTop: jQuery(this).offset().top - 50
                }, 300);
            }

        });
	}

	productFirstTab() {
		var $firstTab = this.elements.$tabs.find('.woocommerce-Tabs-panel').first();
		$firstTab.find('.motta-dropdown__title').addClass('active');
		$firstTab.find('.motta-dropdown__content').show().addClass('active');
	}

	productFirstTabDesktop() {
		if( ! this.$element.hasClass('motta-product-first-tab--yes') ) {
			return;
		}
		this.productFirstTab();
	}

	productReview(){
		var $tabs = this.elements.$tabs;
		jQuery('.woocommerce').on( 'click', '.woocommerce-review-link', function (e) {
            e.preventDefault();
            if( ! $tabs.find('#tab-panel-title-reviews').hasClass( 'active' ) ) {
                $tabs.find('#tab-panel-title-reviews').trigger('click');
            }

            jQuery('html, body').stop(true, true).animate({
                scrollTop: jQuery( jQuery(this).attr('href') ).offset().top - 150
            }, 300);
        });

		jQuery('#respond p.stars a').append('<span class="motta-svg-icon"><svg width="24" height="24" aria-hidden="true" role="img" focusable="false" viewBox="0 0 32 32"><path d="M16 1.333l3.467 11.2h11.2l-9.067 6.933 3.467 11.2-9.067-6.933-9.067 6.933 3.467-11.2-9.067-6.933h11.2z"></path></svg></span>');
	}

	onInit() {
		super.onInit();
		this.productTabsToggle();
		this.responsiveProductTabs();
		this.productFirstTabDesktop();
		this.productReview();
	}
}

class MottaProductDescriptionWidgetHandler extends elementorModules.frontend.handlers.Base {
	getDefaultSettings() {
		return {
			selectors: {
				desc: '.short-description',
			}
		};
	}

	getDefaultElements() {
		const selectors = this.getSettings('selectors');
		return {
		  $desc: this.$element.find(selectors.desc),
		};
	}

	productDescriptionMore() {
		var $content = this.elements.$desc.find('.short-description__content');
		if( ! $content.length ) {
			return;
		}

		var  scrollHeight = $content[0].scrollHeight,
		clientheight = $content[0].clientHeight;
		if( scrollHeight > clientheight ) {
			this.elements.$desc.find('.short-description__more').show();
		}
		this.elements.$desc.on('click', '.short-description__more', function(e) {
			e.preventDefault();

			var $settings = jQuery(this).data( 'settings' ),
				$more     = $settings.more,
				$less     = $settings.less,
				$description = jQuery(this).closest( '.short-description' );

			if(  $description.hasClass( 'activate' ) ) {
				$description.removeClass( 'activate' );
				jQuery(this).text( $more )
			} else {
				$description.addClass( 'activate' );
				jQuery(this).text( $less )
			}
		});

	}

	onInit() {
		super.onInit();
		this.productDescriptionMore();
	}
}

function stickyHeaderCompactMobile() {
	if( jQuery(window).width() > 767 ) {
		return;
	}

	var $headerCompact = jQuery('body').find('.product-header-compact');
	if ( ! $headerCompact.length) {
		return;
	}

	jQuery(window).on('scroll', function () {
		var scroll 		= jQuery(window).scrollTop(),
			scrollTop 		= $headerCompact.outerHeight(true);
		if (scroll > scrollTop) {
			$headerCompact.find('.product-sticky-header').addClass('minimized');
		} else {
			$headerCompact.find('.product-sticky-header').removeClass('minimized');
		}
	} );
}

jQuery( window ).on( 'elementor/frontend/init', () => {
	elementorFrontend.hooks.addAction( 'frontend/element_ready/motta-wc-product-images.default', ( $element ) => {
		elementorFrontend.elementsHandler.addHandler( MottaProductImagesWidgetHandler, { $element } );
	} );

	elementorFrontend.hooks.addAction( 'frontend/element_ready/motta-wc-product-add-to-cart.default', ( $element ) => {
		elementorFrontend.elementsHandler.addHandler( MottaProductVariationWidgetHandler, { $element } );
	} );

	elementorFrontend.hooks.addAction( 'frontend/element_ready/motta-wc-product-data-tabs.default', ( $element ) => {
		elementorFrontend.elementsHandler.addHandler( MottaProductDataTabsWidgetHandler, { $element } );
	} );

	elementorFrontend.hooks.addAction( 'frontend/element_ready/motta-wc-product-short-description.default', ( $element ) => {
		elementorFrontend.elementsHandler.addHandler( MottaProductDescriptionWidgetHandler, { $element } );
	} );

	stickyHeaderCompactMobile();

} );
