<?php
/**
 * Motta Addons Modules functions and definitions.
 *
 * @package Motta
 */

namespace Motta\Addons\Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Addons Modules
 */
class Builder {

	/**
	 * Instance
	 *
	 * @var $instance
	 */
	private static $instance;

	private static $is_product_elementor;

	private static $disable_single_product_builder;

	private static $disable_product_archive_builder;

	/**
	 * Initiator
	 *
	 * @since 1.0.0
	 * @return object
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Instantiate the object.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function __construct() {
		$this->includes();
		$this->load_product();
		add_action('init', array( $this, 'actions'));

		add_action('wp', array( $this, 'frontend'), 1);
	}

	/**
	 * Includes files
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	private function includes() {
		\Motta\Addons\Auto_Loader::register( [
			'Motta\Addons\Elementor\Builder\Settings'    	=> MOTTA_ADDONS_DIR . 'inc/elementor/builder/inc/settings.php',
			'Motta\Addons\Elementor\Builder\Post_Type'    	=> MOTTA_ADDONS_DIR . 'inc/elementor/builder/inc/post-type.php',
			'Motta\Addons\Elementor\Builder\Single_Product'    	=> MOTTA_ADDONS_DIR . 'inc/elementor/builder/inc/single-product.php',
			'Motta\Addons\Elementor\Builder\Product_Archive'    	=> MOTTA_ADDONS_DIR . 'inc/elementor/builder/inc/product-archive.php',
			'Motta\Addons\Elementor\Builder\Frontend'    	=> MOTTA_ADDONS_DIR . 'inc/elementor/builder/inc/frontend.php',
			'Motta\Addons\Elementor\Builder\Widgets'    	=> MOTTA_ADDONS_DIR . 'inc/elementor/builder/inc/widgets.php',
			'Motta\Addons\Elementor\Builder\Elementor_Settings' => MOTTA_ADDONS_DIR . 'inc/elementor/builder/inc/elementor-settings.php',
			'Motta\Addons\Elementor\Builder\Helper' => MOTTA_ADDONS_DIR . 'inc/elementor/builder/inc/helper.php',
			'Motta\Addons\Elementor\Builder\Traits\Product_Id_Trait' => MOTTA_ADDONS_DIR . 'inc/elementor/builder/traits/product-id-trait.php',
			'Motta\Addons\Elementor\Builder\Base_Products_Renderer' => MOTTA_ADDONS_DIR . 'inc/elementor/builder/classes/base-products-renderer.php',
			'Motta\Addons\Elementor\Builder\Current_Query_Renderer' => MOTTA_ADDONS_DIR . 'inc/elementor/builder/classes/current-query-renderer.php',
			'Motta\Addons\Elementor\Builder\Products_Renderer' => MOTTA_ADDONS_DIR . 'inc/elementor/builder/classes/products-renderer.php',
		] );

	}

	/**
	 * Add Actions
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function actions() {
		if( is_admin() ) {
			\Motta\Addons\Elementor\Builder\Settings::instance();
		}

		if( $this->is_product_elementor() ) {
			\Motta\Addons\Elementor\Builder\Post_Type::instance();
			\Motta\Addons\Elementor\Builder\Frontend::instance();
			\Motta\Addons\Elementor\Builder\Widgets::instance();

			if( class_exists('Elementor\Core\Base\Module') ) {
				\Motta\Addons\Elementor\Builder\Elementor_Settings::instance();
			}
		}
	}

	/**
	 * Add Frontend
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function frontend() {
		if( $this->is_product_elementor() ) {
			if( is_singular('product') || is_singular('motta_builder') ) {
				\Motta\Addons\Elementor\Builder\Single_Product::instance();
			}

			if( \Motta\Addons\Elementor\Builder\Helper::is_catalog() || is_singular('motta_builder') ) {
				\Motta\Addons\Elementor\Builder\Product_Archive::instance();
			}
		}
	}

	public function is_product_elementor() {
		if ( isset( self::$is_product_elementor ) ) {
			return self::$is_product_elementor;
		}

		self::$is_product_elementor = true;
		if( ! class_exists('\Elementor\Plugin') ) {
			self::$is_product_elementor = false;
		}

		if( ! get_option('motta_builder_enable', false) ) {
			self::$is_product_elementor = false;
		}

		return self::$is_product_elementor;
	}


	private function load_product() {
		add_filter('motta_load_woo_single_product', array( $this, 'load_woo_single_product' ) );
		add_filter('motta_get_single_product_settings', array( $this, 'disable_single_product_builder' ) );
		add_filter('motta_change_compare_button_settings', array( $this, 'wishlist_button_text' ) );
		add_filter('motta_change_wishlist_button_settings', array( $this, 'wishlist_button_text' ) );

		add_filter('motta_load_woo_product_archive', array( $this, 'load_woo_product_archive' ) );
		add_filter('motta_get_product_archive_settings', array( $this, 'product_archive_settings' ) );
		add_filter('motta_products_filter_register', array( $this, 'product_archive_widgets_register' ) );
		add_filter('motta_shop_static_css', array( $this, 'load_woo_product_archive' ) );
	}

	public function load_woo_single_product($is_single_product) {
		$this->disable_single_product_builder();

		if( self::$disable_single_product_builder ) {
			return $is_single_product;
		}

		return self::$disable_single_product_builder;
	}

	public function disable_single_product_builder() {
		if ( isset( self::$disable_single_product_builder ) ) {
			return self::$disable_single_product_builder;
		}
		self::$disable_single_product_builder = false;

		if( ! get_option('motta_builder_enable', false) ) {
			self::$disable_single_product_builder = true;
		} else {
			if( empty(\Motta\Addons\Elementor\Builder\Single_Product::get_product_template_id()) ) {
				self::$disable_single_product_builder = true;
			}
		}

		return self::$disable_single_product_builder;
	}

	public function wishlist_button_text() {
		if( ! is_singular('product') ) {
			return true;
		} else {
			return $this->disable_single_product_builder();
		}
	}

	public function product_archive_settings() {
		if ( isset( self::$disable_product_archive_builder ) ) {
			return self::$disable_product_archive_builder;
		}
		self::$disable_product_archive_builder = false;

		if( ! get_option('motta_builder_enable', false) ) {
			self::$disable_product_archive_builder = true;
		} else {
			if( empty(\Motta\Addons\Elementor\Builder\Product_Archive::get_product_archive_template_id()) ) {
				self::$disable_product_archive_builder = true;
			}
		}

		return self::$disable_product_archive_builder;
	}

	public function load_woo_product_archive($is_catalog) {
		$this->product_archive_settings();

		if( self::$disable_product_archive_builder ) {
			return $is_catalog;
		}

		return self::$disable_product_archive_builder;
	}

	public function product_archive_widgets_register() {
		if( get_option('motta_builder_enable', false) && ! empty(\Motta\Addons\Elementor\Builder\Product_Archive::get_product_archive_template_id()) ) {
			return false;
		}

		return true;
	}
}
