<?php
namespace Motta\Addons\Elementor\Builder;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

use Elementor\Core\Base\Module;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Core\DocumentTypes\PageBase as PageBase;

class Elementor_Settings extends Module {
	/**
	 * Get module name.
	 *
	 * @return string
	 */
	public function get_name() {
		return 'display-settings';
	}

	/**
	 * Module constructor.
	 */
	public function __construct() {
		add_action( 'elementor/documents/register_controls', [ $this, 'register_display_controls' ] );
	}


	/**
	 * Register display controls.
	 *
	 * @param object $document
	 */
	public function register_display_controls( $document ) {
		if ( ! $document instanceof PageBase ) {
			return;
		}

		$post_type = get_post_type( $document->get_main_id() );

		if ( 'motta_builder' != $post_type ) {
			return;
		}

		$terms = get_the_terms( $document->get_main_id(), 'motta_builder_type' );
		$terms = ! is_wp_error( $terms ) &&  $terms ? wp_list_pluck($terms, 'slug') : '';

		if( ! $terms || ! in_array('product', $terms) ) {
			return;
		}

		add_action('elementor/element/after_section_end', [ $this, 'update_controls' ]);

		$this->register_builder_content($document);

	}

	/**
	 * Register template controls of display.
	 *
	 * @param object $document
	 */
	protected function register_builder_content( $document ) {
		$document->start_controls_section(
			'section_display',
			[
				'label' => __( 'Builder Settings', 'motta-addons' ),
				'tab'   => Controls_Manager::TAB_SETTINGS,
			]
		);

		$document->add_control(
			'product_header_mobile_heading',
			[
				'label'        => esc_html__( 'On Mobile', 'motta-addons' ),
				'type'         => Controls_Manager::HEADING,

			]
		);

		$document->add_control(
			'product_header_compact_mobile',
			[
				'label'        => esc_html__( 'Header Compact ', 'motta-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',

			]
		);

		$document->add_control(
			'product_fixed_gallery_mobile',
			[
				'label'        => esc_html__( 'Fixed Product Gallery', 'motta-addons' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition' => [
					'product_header_compact_mobile' => 'yes',
				],

			]
		);


		$document->end_controls_section();

	}

	/**
	 * @param $element    Controls_Stack
	 */
	public function update_controls( $document ) {
		$document->remove_control( 'hide_title' );
		$document->remove_control( 'section_page_style' );
	}

}