<?php

namespace Motta\Addons\Elementor\Builder;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Main class of plugin for admin
 */
class Frontend {

	/**
	 * Instance
	 *
	 * @var $instance
	 */
	private static $instance;


	/**
	 * Initiator
	 *
	 * @since 1.0.0
	 * @return object
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Page Settings
	 *
	 * @var $page_settings
	 */
	private static $page_settings;

	/**
	 * Instantiate the object.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function __construct() {
	   add_filter( 'template_include', array( $this, 'redirect_template' ), 100);
	}

	public function redirect_template( $template ){
        $template_part = '';
        $template_id = 0;

		global $product;
        $product = is_object($product) ? $product : wc_get_product( get_the_ID() );

		if ( is_singular( 'product' ) ) {
			$single_template_id = \Motta\Addons\Elementor\Builder\Single_Product::get_product_template_id();
			if ( $single_template_id ) {
				$template_id = $single_template_id;
				$template_part = 'single_product';
			}
		} elseif( \Motta\Addons\Elementor\Builder\Helper::is_catalog() ) {
			$product_archive_template_id = \Motta\Addons\Elementor\Builder\Product_Archive::get_product_archive_template_id();
			if ( $product_archive_template_id ) {
				$template_id = $product_archive_template_id;
				$template_part = 'product_archive';
			}
		}

		if( !empty( $template_id ) ){

			// // The code snippet originates in Elementor, specifically in /elementor/modules/page-templates/module.php at line 82.
			$document        = \Elementor\Plugin::$instance->documents->get_doc_for_frontend($template_id);
			$template_module = \Elementor\Plugin::$instance->modules_manager->get_modules('page-templates');

			if( $document && $document::get_property('support_wp_page_templates') ) {
				$page_template = $document->get_meta('_wp_page_template');
				$page_template = ( in_array( $page_template, ['elementor_header_footer', 'elementor_canvas'] ) ? $page_template : 'elementor_header_footer');

				$template_path = $template_module->get_template_path( $page_template );

				if( 'elementor_theme' !== $page_template && !$template_path && $document->is_built_with_elementor() ) {
					$kit_default_template = \Elementor\Plugin::$instance->kits_manager->get_current_settings('default_page_template');
					$template_path        = $template_module->get_template_path( $kit_default_template );
				}

				if( $template_path ) {
					$template = $template_path;
				}
			}
			$template_module->set_print_callback(function () use ( $template_id, $template_part ){
				include_once ( $this->get_template_part( $template_part, $template_id ) );
			});

		}

		return $template;
	}

	public function get_template_part( $slug, $template_id ){
        if( empty( $template_id ) ){
            return;
        }
        $template = '';
      	if( $slug === 'single_product' ) {
			$template = MOTTA_ADDONS_DIR . 'inc/elementor/builder/templates/single-template-builder.php';
        } elseif( $slug === 'product_archive' ) {
			$template = MOTTA_ADDONS_DIR . 'inc/elementor/builder/templates/product-archive-template-builder.php';
        }

		return $template;
    }
}