<?php
/**
 * Motta Addons Elementor Builder Helper init
 *
 *
 * @package Motta
 */

namespace Motta\Addons\Elementor\Builder;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Helper
 */
class Helper {

	/**
	 * Instance
	 *
	 * @var $instance
	 */
	private static $instance;


	/**
	 * Initiator
	 *
	 * @since 1.0.0
	 * @return object
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}


	public static function is_preview_mode(){
		if( self::is_elementor_editor_mode() || get_post_type() === 'motta_builder' ) {
			return true;
		} else {
			return false;
		}
	}

	public static function is_elementor_editor_mode(){
		if( class_exists('\Elementor\Plugin') && \Elementor\Plugin::instance()->editor->is_edit_mode() ){
			return true;
		} else {
			return false;
		}
	}

	public static function is_catalog() {
		if ( class_exists( '\Motta\Helper' ) && method_exists( '\Motta\Helper', 'is_catalog' ) ) {
			return \Motta\Helper::is_catalog();
		}

		return false;
	}
}
