<?php
/**
 * Register template builder
 */

namespace Motta\Addons\Elementor\Builder;

class Post_Type {

	/**
	 * Instance
	 *
	 * @var $instance
	 */
	private static $instance;


	/**
	 * Initiator
	 *
	 * @since 1.0.0
	 * @return object
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	const POST_TYPE     = 'motta_builder';
	const OPTION_NAME   = 'motta_builder';
	const TAXONOMY_TYPE     = 'motta_builder_type';

	/**
	 * Class constructor.
	 */
	public function __construct() {
		add_action( 'admin_menu', array( $this, 'register_admin_menu' ), 50 );

		// Make sure the post types are loaded for imports
		add_action( 'import_start', array( $this, 'register_post_type' ) );

		// Register custom post type and custom taxonomy
		$this->register_post_type();

		// Register custom post type and custom taxonomy
		$this->register_taxonomy();

		add_action('admin_init', array( $this, 'create_terms' ));

	}

	/**
	 * Register portfolio post type
	 */
	public function register_post_type() {
		// Template Builder
		$labels = array(
			'name'               => esc_html__( 'Motta Template Builder', 'motta-addons' ),
			'singular_name'      => esc_html__( 'Motta Template', 'motta-addons' ),
			'menu_name'          => esc_html__( 'Motta Template', 'motta-addons' ),
			'name_admin_bar'     => esc_html__( 'Motta Template', 'motta-addons' ),
			'add_new'            => esc_html__( 'Add New', 'motta-addons' ),
			'add_new_item'       => esc_html__( 'Add New Template', 'motta-addons' ),
			'new_item'           => esc_html__( 'New Template', 'motta-addons' ),
			'edit_item'          => esc_html__( 'Edit Template', 'motta-addons' ),
			'view_item'          => esc_html__( 'View Template', 'motta-addons' ),
			'all_items'          => esc_html__( 'All Elementor', 'motta-addons' ),
			'search_items'       => esc_html__( 'Search Templates', 'motta-addons' ),
			'parent_item_colon'  => esc_html__( 'Parent Template:', 'motta-addons' ),
			'not_found'          => esc_html__( 'No Templates found.', 'motta-addons' ),
			'not_found_in_trash' => esc_html__( 'No Templates found in Trash.', 'motta-addons' ),
		);

		$args = array(
			'labels'              => $labels,
			'public'              => true,
			'rewrite'             => false,
			'show_ui'             => true,
			'show_in_menu'        => false,
			'show_in_nav_menus'   => false,
			'exclude_from_search' => true,
			'capability_type'     => 'post',
			'hierarchical'        => false,
			'menu_icon'           => 'dashicons-editor-kitchensink',
			'supports'            => array( 'title', 'editor', 'elementor' ),
		);

		if ( ! post_type_exists( self::POST_TYPE ) ) {
			register_post_type( self::POST_TYPE, $args );
		}
	}

	public function register_admin_menu() {
		add_submenu_page(
			'edit.php?post_type=elementor_library',
			esc_html__( 'Motta Builder', 'motta-addons' ),
			esc_html__( 'Motta Builder', 'motta-addons' ),
			'edit_pages',
			'edit.php?post_type=' . self::POST_TYPE . ''
		);

	}

	/**
	 * Register core taxonomies.
	 */
	public function register_taxonomy() {
		if ( taxonomy_exists( self::TAXONOMY_TYPE ) ) {
			return;
		}

		register_taxonomy(
			self::TAXONOMY_TYPE,
			array( self::POST_TYPE ),
			array(
				'hierarchical'      => false,
				'show_ui'           => false,
				'show_in_nav_menus' => false,
				'query_var'         => is_admin(),
				'rewrite'           => false,
				'public'            => false,
				'label'             => _x( 'Motta Builder Type', 'Taxonomy name', 'motta-addons' ),
			)
		);
	}

	public function create_terms() {
		$terms = array(
			'shop',
			'product',
			'archive',
			'enable'
		);

		foreach ( $terms as $term ) {
			if ( ! get_term_by( 'name', $term, self::TAXONOMY_TYPE ) ) { // @codingStandardsIgnoreLine.
				wp_insert_term( $term, self::TAXONOMY_TYPE );
			}
		}

	}

}