<?php

namespace Motta\Addons\Elementor\Builder;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Main class of plugin for admin
 */
class Product_Archive {

	/**
	 * Instance
	 *
	 * @var $instance
	 */
	private static $instance;


	/**
	 * Initiator
	 *
	 * @since 1.0.0
	 * @return object
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Page Settings
	 *
	 * @var $page_settings
	 */
	private static $page_settings;

	/**
	 * Instantiate the object.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function __construct() {
		add_filter( 'body_class', array( $this, 'body_classes' ), 10 );

		// Scripts and styles.
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );

		add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_styles' ] );

		add_filter( 'motta_get_page_header_elements', array( $this, 'page_header_elements' ) );

	   	add_action( 'motta_woocommerce_archive_product_content', array( $this, 'archive_product_content' ), 5 );

	   	add_filter('motta_is_page_built_with_elementor', array( $this, 'is_page_built_with_elementor' ));

		add_filter( 'loop_shop_columns', array( $this, 'catalog_column' ) );

	}

	public function body_classes( $classes ) {
		if( is_singular( 'motta_builder' ) ) {
			global $post;
			$post_id = $post ? $post->ID : 0;
			if( $post_id ) {
				$terms = get_the_terms( $post_id, 'motta_builder_type' );
				if( ! is_wp_error( $terms ) && $terms ) {
					foreach ( $terms as $term ) {
						if( $term->slug == 'product_archive' ) {
							$classes[] = 'product-archive-elementor motta-catalog-page';
							break;
						}
					}
				}
			}
		}

		if( \Motta\Addons\Elementor\Builder\Helper::is_catalog() && self::get_product_archive_template_id()  ) {
			$classes[] = 'product-archive-elementor';

			$classes[] = 'motta-catalog-page';

			$catalog_view   = isset( $_COOKIE['catalog_view'] ) ? $_COOKIE['catalog_view'] : get_option( 'woocommerce_catalog_columns', 4 );

			$classes[] = 'catalog-view-' . apply_filters( 'motta_catalog_view', $catalog_view );
		}

		return $classes;
	}

	public function catalog_column( $column ) {
		if( empty( $_COOKIE['catalog_view'] ) ) {
			return $column;
		}

		if( $_COOKIE['catalog_view'] == 'list' ) {
			$column = 1;
		}

		if( $_COOKIE['catalog_view'] == 'grid-2' ) {
			$column = 2;
		}

		if( $_COOKIE['catalog_view'] == 'grid-3' ) {
			$column = 3;
		}

		if( $_COOKIE['catalog_view'] == 'default' ) {
			$column = 4;
		}

		if( $_COOKIE['catalog_view'] == 'grid-5' ) {
			$column = 5;
		}

		return $column;
	}

		/**
	 * Products header.
	 *
	 *  @return void
	 */
	public function page_header_elements( $items ) {
		if( self::get_product_archive_template_id()  ) {
			$items = [];
		}

		return $items;
	}


    public function archive_product_content() {
		$template_id = $this->get_product_archive_template_id();
		if ( $template_id ) {
			$elementor_instance = \Elementor\Plugin::instance();
       	 	echo $elementor_instance->frontend->get_builder_content_for_display( intval( $template_id) );
        }
    }

	/**
	 * Enqueue styles
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function enqueue_styles() {
		$template_id = $this->get_product_archive_template_id();
		if ( ! empty( $template_id ) ) {
			wp_enqueue_style( 'motta-product-archive',  MOTTA_ADDONS_URL . 'inc/elementor/builder/assets/css/product-archive.css', array(), '1.0' );
		}
	}

	public function enqueue_scripts() {
		$template_id = $this->get_product_archive_template_id();
		if ( ! empty( $template_id ) ) {
			$css_file = '';
			if ( class_exists( '\Elementor\Core\Files\CSS\Post' ) ) {
				$css_file = new \Elementor\Core\Files\CSS\Post( $template_id );
			} elseif ( class_exists( '\Elementor\Post_CSS_File' ) ) {
				$css_file = new \Elementor\Post_CSS_File( $template_id );
			}
			if( $css_file ) {
				$css_file->enqueue();
			}
		}

	}


	/**
	 * Get product archive template id
     *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public static function get_product_archive_template_id() {
		$product_archive_template_id = get_transient( 'motta_wc_product_archive_template_id');
		if ( false !== $product_archive_template_id ) {
			return $product_archive_template_id;
		}

		$posts = new \WP_Query( array(
			'post_type'      => 'motta_builder',
			'post_status'    => 'publish',
			'posts_per_page' => '1',
			'fields'         => 'ids',
			'no_found_rows'  => true,
			'suppress_filters'       => false,
			'tax_query' => array(
				array(
					'taxonomy' => 'motta_builder_type',
					'field' => 'slug',
					'operator' => 'AND',
					'terms' => array('product_archive', 'enable')
				),
			)
		) );

		$post_ids = $posts->posts;
		wp_reset_postdata();
		$product_archive_template_id = 0;
		if( ! empty( $post_ids ) ) {
			$product_archive_template_id = $post_ids[0];
			set_transient( 'motta_wc_product_archive_template_id', $product_archive_template_id, MONTH_IN_SECONDS );
		}

		return $product_archive_template_id;

	}

	public function is_page_built_with_elementor( $builder ) {
		if (empty($this->get_product_archive_template_id())) {
			$builder = false;
		} else {
			$builder = true;
		}

		return $builder;
	}

}