<?php

namespace Motta\Addons\Elementor\Builder;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Main class of plugin for admin
 */
class Single_Product {

	use \Motta\Addons\Elementor\Builder\Traits\Product_Id_Trait;

	/**
	 * Instance
	 *
	 * @var $instance
	 */
	private static $instance;


	/**
	 * Initiator
	 *
	 * @since 1.0.0
	 * @return object
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Page Settings
	 *
	 * @var $page_settings
	 */
	private static $page_settings;

	/**
	 * Instantiate the object.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function __construct() {
		add_filter( 'body_class', array( $this, 'body_classes' ) );

		// Scripts and styles.
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );

		add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_styles' ] );

		add_filter('motta_builder_classes', array( $this, 'builder_classes' ));

		add_filter( 'motta_get_page_header_elements', array( $this, 'page_header_elements' ) );

	   	add_action( 'motta_woocommerce_product_content', array( $this, 'single_product_content_builder' ), 5 );

	   	add_filter('motta_is_page_built_with_elementor', array( $this, 'is_page_built_with_elementor' ));

	   	add_action( 'motta_before_single_product_image', array(	$this, 'product_gallery_fixed_spacing' ), 20 );

	   	add_action('motta_after_close_site_footer', array( $this, 'product_header_compact_mobile' ), 10 );

	   	add_action('motta_after_close_site_footer', array( $this, 'modal_product_share' ), 20 );
	   	add_action('motta_after_close_site_footer', array( $this, 'modal_product_more' ), 20 );

	}

	public function body_classes( $classes ) {
		if( is_singular( 'motta_builder' ) ) {
			global $post;
			$post_id = $post ? $post->ID : 0;
			if( $post_id ) {
				$terms = get_the_terms( $post_id, 'motta_builder_type' );
				if( ! is_wp_error( $terms ) && $terms ) {
					foreach ( $terms as $term ) {
						if( $term->slug == 'product' ) {
							$classes[] = 'single-product woocommerce single-product-elementor';
							$classes[] = $this->get_product_header_compact_classes();
							break;
						}
					}
				}

			}
		}

		if( is_singular( 'product' ) && self::get_product_template_id()  ) {
			$classes[] = 'single-product-elementor';
			$classes[] = $this->get_product_header_compact_classes();
		}

		return $classes;
	}

		/**
	 * Products header.
	 *
	 *  @return void
	 */
	public function page_header_elements( $items ) {
		if( is_singular( 'product' ) ||  is_singular( 'motta_builder' ) ) {
			$items = [];
		}

		return $items;
	}

	public function builder_classes($classes) {
		if( ! is_singular( 'motta_builder' ) ) {
			return $classes;
		}
		global $product;
		if( empty( $product ) ) {
			$product_template_id = self::get_last_product_id();
			$product = wc_get_product( $product_template_id );
		}

		$classes = wc_get_product_class( 'product', $product );
		if ( get_option( 'motta_buy_now' ) == 'yes' ) {
			$classes[] = 'has-buy-now';
		}

		return $classes;
	}


    public function single_product_content_builder() {
		$template_id = $this->get_product_template_id();
		if ( $template_id ) {
			$elementor_instance = \Elementor\Plugin::instance();
       	 	echo $elementor_instance->frontend->get_builder_content_for_display( intval( $template_id) );
        }
    }

	public function enqueue_scripts() {
		$template_id = $this->get_product_template_id();
		if ( ! empty( $template_id ) && is_singular('product') ) {
			$css_file = '';
			if ( class_exists( '\Elementor\Core\Files\CSS\Post' ) ) {
				$css_file = new \Elementor\Core\Files\CSS\Post( $template_id );
			} elseif ( class_exists( '\Elementor\Post_CSS_File' ) ) {
				$css_file = new \Elementor\Post_CSS_File( $template_id );
			}
			if( $css_file ) {
				$css_file->enqueue();
			}
		}

	}

		/**
	 * Enqueue styles
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function enqueue_styles() {
		$template_id = $this->get_product_template_id();
		if ( ! empty( $template_id ) ) {
			wp_enqueue_style( 'motta-elementor-single-product',  MOTTA_ADDONS_URL . 'inc/elementor/builder/assets/css/single-product.css', array(), '1.0' );
		}
	}

	public function get_product_header_compact_classes() {
		if( ! is_singular( 'product' ) &&  ! is_singular( 'motta_builder' ) ) {
			return;
		}
		$settings = $this->get_product_template_settings();
		$classes = '';
		if( $settings &&  isset($settings['product_header_compact_mobile']) && $settings['product_header_compact_mobile'] == 'yes' ) {
			$classes .= ' mobile-header-compact';

			if( isset($settings['product_fixed_gallery_mobile']) && $settings['product_fixed_gallery_mobile'] == 'yes' ) {
				$classes .= ' mobile-fixed-product-gallery';
			}
		}

		return $classes;
	}

	public function product_gallery_fixed_spacing() {
		if( ! is_singular( 'product' ) &&  ! is_singular( 'motta_builder' ) ) {
			return;
		}

		$settings = $this->get_product_template_settings();
		if(! $settings || ! isset($settings['product_header_compact_mobile']) || $settings['product_header_compact_mobile'] != 'yes' ) {
			return;
		}

		if( ! $settings || ! isset($settings['product_fixed_gallery_mobile']) || $settings['product_fixed_gallery_mobile'] != 'yes' ) {
			return;
		}

		echo '<div class="product-fixed-gallery-spacing"></div>';

	}

	public function product_header_compact_mobile() {
		if( ! is_singular( 'product' )  ) {
			return;
		}
		$settings = $this->get_product_template_settings();
		if( ! isset($settings['product_header_compact_mobile']) || $settings['product_header_compact_mobile'] != 'yes' ) {
			return;
		}

		echo '<div class="product-header-compact">';
			get_template_part('template-parts/mobile/sticky-header', 'compact');
		echo '</div>';

		if( class_exists('\Motta\Theme') ) {
			\Motta\Theme::set_prop( 'modals-addons', 'product-more' );
			\Motta\Theme::set_prop( 'modals-addons', 'product-share' );
		}
	}

	public function modal_product_share() {
		if( ! class_exists('\Motta\Theme') ) {
			return;
		}
		$items = (array) \Motta\Theme::get_prop( 'modals-addons' );

		if ( empty( $items ) || ! in_array( 'product-share', $items ) ) {
			return;
		}

		$output = \Motta\Helper::share_socials();

		get_template_part( 'template-parts/modals/socials', '', $output );
	}

	public function modal_product_more() {
		if( ! class_exists('\Motta\Theme') ) {
			return;
		}

		$items = (array) \Motta\Theme::get_prop( 'modals-addons' );

		if ( empty( $items ) || ! in_array( 'product-more', $items ) ) {
			return;
		}

		get_template_part('template-parts/modals/product', 'more');
	}

	public function get_product_template_settings() {
		if( isset( self::$page_settings )  ) {
			return self::$page_settings;
		}
		if ( \Motta\Addons\Elementor\Builder\Helper::is_elementor_editor_mode() ) {
			$template_id = get_the_ID();
		} else {
			$template_id = $this->get_product_template_id();
		}
		if( empty ( $template_id ) ) {
			self::$page_settings = false;
		} else {
			$page_settings_manager = \Elementor\Core\Settings\Manager::get_settings_managers( 'page' );
			$page_settings_model = $page_settings_manager->get_model( $template_id );
			self::$page_settings = $page_settings_model->get_settings();
		}


		return self::$page_settings;
	}

	/**
	 * Get product template id
     *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public static function get_product_template_id() {
		$product_template_id = get_transient( 'motta_wc_product_template_id');
		if ( false !== $product_template_id ) {
			return $product_template_id;
		}

		$posts = new \WP_Query( array(
			'post_type'      => 'motta_builder',
			'post_status'    => 'publish',
			'posts_per_page' => '1',
			'fields'         => 'ids',
			'no_found_rows'  => true,
			'suppress_filters'       => false,
			'tax_query' => array(
				array(
					'taxonomy' => 'motta_builder_type',
					'field' => 'slug',
					'operator' => 'AND',
					'terms' => array('product', 'enable')
				),
			)
		) );

		$post_ids = $posts->posts;
		wp_reset_postdata();
		$product_template_id = 0;
		if( ! empty( $post_ids ) ) {
			$product_template_id = $post_ids[0];
			set_transient( 'motta_wc_product_template_id', $product_template_id, MONTH_IN_SECONDS );
		}

		return $product_template_id;

	}

	public function is_page_built_with_elementor( $builder ) {
		if(empty($this->get_product_template_id())) {
			$builder = false;
		} else {
			if( is_singular( 'product' ) ||  is_singular( 'motta_builder' ) ) {
				$builder = true;

			}
		}

		return $builder;
	}

}