<?php
/**
 * Register template builder
 */

namespace Motta\Addons\Elementor\Builder;

class Widgets {

	/**
	 * Instance
	 *
	 * @var $instance
	 */
	private static $instance;


	/**
	 * Initiator
	 *
	 * @since 1.0.0
	 * @return object
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

	/**
	 * Class constructor.
	 */
	public function __construct() {
		spl_autoload_register( [ $this, 'autoload' ] );
		add_action( 'elementor/widgets/register', [ $this, 'init_widgets' ] );
		add_action( 'elementor/elements/categories_registered', [ $this, 'add_category' ] );

		add_action( 'elementor/frontend/after_enqueue_styles', [ $this, 'register_styles' ] );
		add_action( 'elementor/frontend/after_register_scripts', [ $this, 'register_scripts' ] );

		if ( ! empty( $_REQUEST['action'] ) && 'elementor' === $_REQUEST['action'] && is_admin() ) {
			add_action( 'init', [ $this, 'register_wc_hooks' ], 5 );
		}

		$this->woocommerce_setup();

	}

	/**
	 * Register styles
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function register_styles() {
		wp_register_style( 'magnific', MOTTA_ADDONS_URL . 'assets/css/magnific-popup.css', array(), '1.1.0' );
	}

	/**
	 * Register styles
	 */
	public function register_scripts() {
		wp_register_script( 'magnific', MOTTA_ADDONS_URL . 'assets/js/plugins/jquery.magnific-popup.js', ['jquery'], '1.1.0', true );
		wp_register_script( 'motta-elementor-single-product', MOTTA_ADDONS_URL . 'inc/elementor/builder/assets/js/single-product.js', ['jquery', 'underscore', 'elementor-frontend', 'regenerator-runtime'], MOTTA_ADDONS_VER, true );
		wp_register_script( 'motta-product-archive', MOTTA_ADDONS_URL . 'inc/elementor/builder/assets/js/product-archive.js', ['jquery', 'underscore', 'elementor-frontend', 'regenerator-runtime'], MOTTA_ADDONS_VER, true );
	}

	/**
	 * Auto load widgets
	 */
	public function autoload( $class ) {
		if ( 0 !== strpos( $class, __NAMESPACE__ ) ) {
			return;
		}

		$path = explode( '\\', $class );
		$filename = strtolower( array_pop( $path ) );
		$filename = str_replace( '_', '-', $filename );

		$module = array_pop( $path );

		if ( 'Widgets' == $module ) {
			$filename = MOTTA_ADDONS_DIR . 'inc/elementor/builder/widgets/' . $filename . '.php';
		} elseif ( 'Traits' == $module ) {
			$filename = MOTTA_ADDONS_DIR . 'inc/elementor/builder/traits/' . $filename . '.php';
		}

		if ( is_readable( $filename ) ) {
			include( $filename );
		}
	}

		/**
	 * Register WC hooks for Elementor editor
	 */
	public function register_wc_hooks() {
		if ( function_exists( 'wc' ) ) {
			wc()->frontend_includes();
		}
	}


	/**
	 * Init Widgets
	 */
	public function init_widgets() {
		$widgets_manager = \Elementor\Plugin::instance()->widgets_manager;

		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Breadcrumb() );
		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Product_Share() );
		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Product_Print() );
		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Product_Images() );
		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Product_Badge() );
		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Product_Title() );
		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Product_Category() );
		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Product_Sku() );
		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Product_Rating() );
		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Product_Price() );
		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Product_Stock() );
		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Product_Add_To_Cart() );
		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Product_Data_Tabs() );
		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Product_Related() );
		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Product_Upsell() );
		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Product_Reviews() );
		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Products_List() );
		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Product_Short_Description() );
		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Product_Content() );
		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Product_Meta() );

		if ( class_exists( 'WeDevs_Dokan' ) || class_exists( 'WCFMmp' ) || class_exists( 'Marketkingcore' ) ) {
			$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Product_Vendor_Info() );
		}

		if ( function_exists('wcboost_wishlist') ) {
			$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Product_Wishlist() );
		}

		if ( function_exists('wcboost_products_compare') ) {
			$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Product_Compare() );
		}

		if ( class_exists( '\Motta\Addons\Modules\Product_Bought_Together\Frontend' ) ) {
			$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Product_FBT() );
		}

		// Product Archive
		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Archive_Page_Header() );
		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Archive_Result_Count() );
		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Archive_Product_Ordering() );
		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Archive_Product_View() );
		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Archive_Products() );
		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Products_Filter() );
		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Products_Filter_Actived() );
		$widgets_manager->register( new \Motta\Addons\Elementor\Builder\Widgets\Archive_Product_Categories() );

	}

	/**
	 * Add Motta category
	 */
	public function add_category( $elements_manager ) {
		$elements_manager->add_category(
			'motta-wc-addons',
			[
				'title' => __( 'Motta WooCommerce', 'motta-addons' )
			]
		);
	}

		/**
	 * WooCommerce setup function.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	public function woocommerce_setup() {
		add_theme_support( 'wc-product-gallery-zoom' );
		add_theme_support( 'wc-product-gallery-lightbox' );
	}

}