<?php
/**
 * The Template for displaying all template type
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?>
<div id="motta-builder-template-modal" class="motta-builder-template-modal">
	<div class="modal__backdrop"></div>
	<div class="modal__content">
		<span class="motta-svg-icon motta-svg-icon--close modal__button-close"><svg width="24" height="24" aria-hidden="true" role="img" focusable="false" viewBox="0 0 32 32"><path d="M28.336 5.936l-2.272-2.272-10.064 10.080-10.064-10.080-2.272 2.272 10.080 10.064-10.080 10.064 2.272 2.272 10.064-10.080 10.064 10.080 2.272-2.272-10.080-10.064z"></path></svg></span>
		<form class="modal-content__form" action="<?php echo esc_url( admin_url('post.php') ); ?>">
			<input type="hidden" class="_wpnonce" value="<?php echo wp_create_nonce( 'motta_buider_new_template' ); ?>">
			<div class="modal-content-form__title"><?php echo esc_html__( 'Choose Template Type', 'motta-addons' ); ?></div>
			<div  class="elementor-form-field">
				<label for="motta-builder-template-modal-type" class="elementor-form-field__label"><?php echo esc_html__( 'Select the type of template you want to work on', 'motta-addons' ); ?></label>
				<select id="motta-builder-template-modal-type" class="elementor-form-field__select" required>
					<option value="product"><?php echo esc_html__( 'Single Product', 'motta-addons' ); ?></option>
					<option value="product_archive"><?php echo esc_html__( 'Product Archive', 'motta-addons' ); ?></option>
				</select>
			</div>
			<div class="elementor-form-field">
				<label for="motta-builder-template-modal__post-title" class="elementor-form-field__label">
					<?php echo esc_html__( 'Name your template', 'motta-addons' ); ?>
				</label>
				<input type="text" placeholder="<?php echo esc_attr__( 'Enter template name (optional)', 'motta-addons' ); ?>" required id="motta-builder-template-modal__post-title" class="elementor-form-field__text">
			</div>
			<div class="elementor-form-field">
				<input class="elementor-form-field__checkbox" type="checkbox" name="woolentor-template-default" id="motta-builder-template-modal__post-default">
				<label for="motta-builder-template-modal__post-default" class="elementor-form-field__label">
					<?php echo esc_html__( 'Set Default', 'motta-addons' ); ?>
				</label>
			</div>
			<button id="motta-builder-template-modal__submit" class="elementor-button e-primary"><span><?php echo esc_html__( 'Create Template', 'motta-addons' ); ?></span></button>
			<p class="modal-content-form-message"></p>
		</form>
	</div>
</div>
