<?php
namespace Motta\Addons\Elementor\Builder\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Archive_Product_Categories extends Widget_Base {
	public function get_name() {
		return 'motta-archive-product-categories';
	}

	public function get_title() {
		return esc_html__( '[Motta] Archive Product Categories', 'motta-addons' );
	}

	public function get_icon() {
		return 'eicon-product-categories';
	}

	public function get_categories() {
		return ['motta-wc-addons'];
	}

	public function get_keywords() {
		return [ 'woocommerce', 'product', 'archive', 'categories' ];
	}

	public function get_style_depends() {
		return [ 'motta-product-archive' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
            'categories_content',
            [
                'label' => __( 'Categories', 'motta-addons' ),
            ]
        );

		$this->add_control(
			'layout',
			[
				'label' => __( 'Layout', 'motta-addons' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'v1',
				'options' => array(
					'v1' => __( 'Thumbnail & Name', 'motta-addons' ),
					'v2' => __( 'Only Name', 'motta-addons' ),
				),
			]
		);

		$this->add_control(
			'show_new_arrivals',
			[
				'label' => esc_html__( 'Show New Arrivals', 'motta-addons' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'motta-addons' ),
				'label_off' => esc_html__( 'Hide', 'motta-addons' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_sale',
			[
				'label' => esc_html__( 'Show Sale', 'motta-addons' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'motta-addons' ),
				'label_off' => esc_html__( 'Hide', 'motta-addons' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'limit',
			[
				'label' => esc_html__( 'Limit', 'motta-addons' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => 7,
			]
		);

		$this->add_control(
			'order_by',
			[
				'label' => esc_html__( 'Order By', 'motta-addons' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'order',
				'options' => [
					'order' => esc_html__( 'Category Order', 'motta-addons' ),
					'name' => esc_html__( 'Category Name', 'motta-addons' ),
					'id'  => esc_html__( 'Category ID', 'motta-addons' ),
					'counts' => esc_html__( 'Product Counts', 'motta-addons' ),
				],
			]
		);

		$this->add_responsive_control(
			'slides_to_show',
			[
				'label'   => esc_html__( 'Slides to show', 'motta-addons' ),
				'type'    => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 20,
				'step' => 1,
				'default' => 9,
				'selectors' => [
					'{{WRAPPER}} .catalog-top-categories__item' => '--motta-catalog-top-categories-item-width: calc(100% / {{VALUE}});min-width: calc(100% / {{VALUE}});',
				],
				'condition'   => [
					'layout' => 'v1',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
            'category_item_style',
            [
                'label' => __( 'Category Item', 'motta-addons' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition'   => [
					'layout' => 'v1',
				],
            ]
        );
		$this->add_responsive_control(
			'category_item_spacing',
			[
				'label'     => esc_html__( 'Spacing', 'motta-addons' ),
				'type'      => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 600,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .catalog-top-categories__item' => 'padding-right: {{SIZE}}{{UNIT}};',
				],
				'condition'   => [
					'layout' => 'v1',
				],
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
            'categories_thumbnail_style',
            [
                'label' => __( 'Thumbnail', 'motta-addons' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition'   => [
					'layout' => 'v1',
				]
            ]
        );

		$this->add_control(
			'thumbnail_heading',
			[
				'label' => esc_html__( 'Category Thumbnail', 'motta-addons' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition'   => [
					'layout' => 'v1',
				],
			]
		);

		$this->add_responsive_control(
			'thumbnail_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'motta-addons' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .catalog-top-categories__image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'   => [
					'layout' => 'v1',
				],
			]
		);

		$this->add_responsive_control(
			'thumbnail_width',
			[
				'label'     => esc_html__( 'Width', 'motta-addons' ),
				'type'      => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 600,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .catalog-top-categories__image' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .catalog-top-categories__image.text' => 'height: {{SIZE}}{{UNIT}};',
				],
				'condition'   => [
					'layout' => 'v1',
				],
			]
		);

		$this->add_responsive_control(
			'thumbnail_spacing',
			[
				'label'     => esc_html__( 'Spacing', 'motta-addons' ),
				'type'      => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 600,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .catalog-top-categories__image' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition'   => [
					'layout' => 'v1',
				],
			]
		);

		$this->add_control(
			'thumbnail_shop_heading',
			[
				'label' => esc_html__( 'Thumbnail Shop All', 'motta-addons' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition'   => [
					'layout' => 'v1',
				],
			]
		);

		$this->add_control(
			'thumbnail_shop_bg_color',
			[
				'label' => esc_html__( 'Background Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .catalog-top-categories__image.all' => 'background-color: {{VALUE}}',
				],
				'condition'   => [
					'layout' => 'v1',
				],
			]
		);

		$this->add_control(
			'thumbnail_shop_color',
			[
				'label' => esc_html__( 'Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .catalog-top-categories__image.all' => 'color: {{VALUE}}',
				],
				'condition'   => [
					'layout' => 'v1',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'thumbnail_shop_typography',
				'selector' => '{{WRAPPER}} .catalog-top-categories__image.all',
				'condition'   => [
					'layout' => 'v1',
				],
			]
		);

		$this->add_control(
			'thumbnail_new_heading',
			[
				'label' => esc_html__( 'Thumbnail New', 'motta-addons' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition'   => [
					'layout' => 'v1',
				],
			]
		);

		$this->add_control(
			'thumbnail_new_bg_color',
			[
				'label' => esc_html__( 'Background Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .catalog-top-categories__image.new' => 'background-color: {{VALUE}}',
				],
				'condition'   => [
					'layout' => 'v1',
				],
			]
		);

		$this->add_control(
			'thumbnail_new_color',
			[
				'label' => esc_html__( 'Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .catalog-top-categories__image.new' => 'color: {{VALUE}}',
				],
				'condition'   => [
					'layout' => 'v1',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'thumbnail_new_typography',
				'selector' => '{{WRAPPER}} .catalog-top-categories__image.new',
				'condition'   => [
					'layout' => 'v1',
				],
			]
		);


		$this->add_control(
			'thumbnail_sale_heading',
			[
				'label' => esc_html__( 'Thumbnail Sale', 'motta-addons' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition'   => [
					'layout' => 'v1',
				],
			]
		);

		$this->add_control(
			'thumbnail_sale_bg_color',
			[
				'label' => esc_html__( 'Background Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .catalog-top-categories__image.sale' => 'background-color: {{VALUE}}',
				],
				'condition'   => [
					'layout' => 'v1',
				],
			]
		);

		$this->add_control(
			'thumbnail_sale_color',
			[
				'label' => esc_html__( 'Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .catalog-top-categories__image.sale' => 'color: {{VALUE}}',
				],
				'condition'   => [
					'layout' => 'v1',
				],
			]
		);


		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'thumbnail_sale_typography',
				'selector' => '{{WRAPPER}} .catalog-top-categories__image.sale',
				'condition'   => [
					'layout' => 'v1',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
            'categories_name_style',
            [
                'label' => __( 'Category Name', 'motta-addons' ),
				'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_responsive_control(
			'category_item_padding',
			[
				'label' => esc_html__( 'Padding', 'motta-addons' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .catalog-top-categories__item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'   => [
					'layout' => 'v2',
				],
			]
		);

		$this->add_responsive_control(
			'category_item_margin',
			[
				'label' => esc_html__( 'Margin', 'motta-addons' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .catalog-top-categories__item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'   => [
					'layout' => 'v2',
				],
			]
		);

		$this->add_control(
			'name_bg_color',
			[
				'label' => esc_html__( 'Background Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .catalog-top-categories__item' => 'background-color: {{VALUE}}',
				],
				'condition'   => [
					'layout' => 'v2',
				],
			]
		);

		$this->add_control(
			'name_color',
			[
				'label' => esc_html__( 'Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .catalog-top-categories__text' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'name_bg_color_hover',
			[
				'label' => esc_html__( 'Background Color Hover', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .catalog-top-categories__item:hover' => 'background-color: {{VALUE}}',
				],
				'condition'   => [
					'layout' => 'v2',
				],
			]
		);

		$this->add_control(
			'name_color_hover',
			[
				'label' => esc_html__( 'Color Hover', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .catalog-top-categories__item:hover .catalog-top-categories__text' => 'color: {{VALUE}}',
				],
				'condition'   => [
					'layout' => 'v2',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'name_typography',
				'selector' => '{{WRAPPER}} .catalog-top-categories__text',
			]
		);

        $this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$this->top_categories($settings);
	}

	public function render_plain_content() {}

	public function get_group_name() {
		return 'woocommerce';
	}

	/**
	 * Show top categories
	 *
	 * @return void
	 */
	public function top_categories($settings) {
		$base_url       = wc_get_page_permalink( 'shop' );
		$orderby 		= $settings['order_by'];
		$limit			= $settings['limit'];
		$ouput          = [];
		$shop_class = '';
		$shop_link = '';
		if( function_exists('is_product_category') && is_product_category() ) {
			$queried        = get_queried_object();
			$current_term   = ! empty ( $queried->term_id ) ? $queried->term_id : '';
			$termchildren  = get_term_children( $queried->term_id, $queried->taxonomy );
			$base_url       =  get_term_link( $current_term );
			$args = array(
				'taxonomy' => $queried->taxonomy,
			);
			if( ! empty( $termchildren ) ) {
				$args['parent'] = $queried->term_id;

				if( count( $termchildren ) == 1 ) {
					$term = get_term_by( 'id', $termchildren[0], $queried->taxonomy );

					if( $term->count == 0 ) {
						$args['parent'] = $queried->parent;
					}
				}
				$shop_class = 'active';
				$shop_link = get_term_link( $queried->term_id );

			} else {
				$args['parent'] = $queried->parent;
				$term = get_term_by( 'term_id', $queried->parent, 'product_cat' );
				if( !is_wp_error( $term ) && $term ) {
					$shop_link = get_term_link( $term->term_id );
				}

			}

		} else {
			$args = array(
				'taxonomy' => 'product_cat',
				'parent'   => 0,
			);
			$shop_class = 'active';
			$shop_link = wc_get_page_permalink( 'shop' );
		}

		$cat_image = $settings['layout'] == 'v1' ? sprintf('<span class="catalog-top-categories__image all text">%s</span>', esc_html__( 'All', 'motta' )) : '';
		$ouput[] = sprintf(
			'<a class="catalog-top-categories__item %s" href="%s">
				%s
				<span class="catalog-top-categories__text">%s</span>
			</a>',
			$shop_class,
			esc_url( $shop_link ),
			$cat_image,
			esc_html__( 'Shop All', 'motta' )
		);

		if ( ! empty( $orderby ) ) {
			$args['orderby'] = $orderby;

			if ( $orderby == 'order' ) {
				$args['menu_order'] = 'asc';
			} else {
				if ( $orderby == 'count' ) {
					$args['order'] = 'desc';
				}
			}
		}

		if( ! empty ( $limit ) && $limit !== '0' ) {
			$args['number'] =  $limit;
		}

		$terms = get_terms( $args );

		if ( is_wp_error( $terms ) || ! $terms ) {
			return;
		}

		$cat_image = $settings['layout'] == 'v1' ? sprintf('<span class="catalog-top-categories__image new text">%s</span>', esc_html__( 'New', 'motta' )) : '';
		if( $settings['show_new_arrivals'] == 'yes') {
			$ouput[] = sprintf(
					'<a class="catalog-top-categories__item %s" href="%s">
						%s
						<span class="catalog-top-categories__text">%s</span>
					</a>',
					! empty( $_GET['orderby'] ) ? 'active' : '',
					esc_url( $base_url ) . '?orderby=date',
					$cat_image,
					esc_html__( 'New Arrivals', 'motta' )
				);
		}

		$cat_image = $settings['layout'] == 'v1' ? sprintf('<span class="catalog-top-categories__image sale text">%s</span>', esc_html__( 'Sale', 'motta' )) : '';
		if( $settings['show_sale'] == 'yes') {
			$ouput[] = sprintf(
					'<a class="catalog-top-categories__item %s" href="%s">
						%s
						<span class="catalog-top-categories__text">%s</span>
					</a>',
					! empty( $_GET['on_sale'] ) ? 'active' : '',
					esc_url( $base_url ) . '?on_sale=1',
					$cat_image,
					esc_html__( 'Sale', 'motta' )
				);
		}

		$thumbnail_size = apply_filters( 'motta_top_categories_thumbnail_size', 'thumbnail' );

		foreach( $terms as $term ) {
			if( $settings['layout'] == 'v1' ) {
				$thumb_id = get_term_meta( $term->term_id, 'thumbnail_id', true );
				$images = ! empty( wp_get_attachment_image_src( $thumb_id, $thumbnail_size ) ) ? wp_get_attachment_image_src( $thumb_id, $thumbnail_size )[0] : wc_placeholder_img_src( $thumbnail_size );

				$thumb_url = !empty( $thumb_id ) ? $images : wc_placeholder_img_src( $thumbnail_size );
				$term_img = !empty( $thumb_url ) ? '<img class="catalog-top-categories__image" src="' . esc_url( $thumb_url ) . '" alt="' . esc_attr( $term->name ) . '" />' : '<span class="catalog-top-categories__image">' . esc_attr( $term->name ) . '</span>';
			} else {
				$term_img = '';
			}

			$ouput[] = sprintf(
				'<a class="catalog-top-categories__item %s" href="%s">
					%s
					<span class="catalog-top-categories__text">%s</span>
				</a>',
				(!empty( $current_term ) && $current_term == $term->term_id ) ? 'active' : '',
				esc_url( get_term_link( $term->term_id ) ),
				$term_img,
				esc_html( $term->name )
			);
		}

		echo sprintf(
				'<div class="catalog-top-categories catalog-top-categories__layout-%s">
					<div class="catalog-top-categories__wrapper">%s</div>
				</div>',
				esc_attr( $settings['layout'] ),
				implode( '', $ouput )
			);
	}
}
