<?php
namespace Motta\Addons\Elementor\Builder\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Archive_Product_Ordering extends Widget_Base {
	public function get_name() {
		return 'motta-archive-product-ordering';
	}

	public function get_title() {
		return esc_html__( '[Motta] Archive Product Ordering', 'motta-addons' );
	}

	public function get_icon() {
		return 'eicon-sort-amount-desc';
	}

	public function get_categories() {
		return ['motta-wc-addons'];
	}

	public function get_keywords() {
		return [ 'woocommerce', 'product', 'archive', 'ordering' ];
	}

	public function get_style_depends() {
		return [ 'motta-product-archive' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
            'ordering_content',
            [
                'label' => __( 'Ordering', 'motta-addons' ),
            ]
        );

		$this->add_control(
			'type',
			[
				'label' => __( 'Type', 'motta-addons' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'select',
				'options' => array(
					'select' => __( 'Select', 'motta-addons' ),
					'modal' => __( 'Modal', 'motta-addons' ),
					'dropdown' => __( 'Dropdown', 'motta-addons' ),
				),
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
            'ordering_style',
            [
                'label' => __( 'Ordering', 'motta-addons' ),
				'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control(
			'label_heading',
			[
				'label' => esc_html__( 'Label', 'motta-addons' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition'   => [
					'type' => 'select',
				],
			]
		);

		$this->add_control(
			'label_color',
			[
				'label' => esc_html__( 'Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce-ordering__label' => 'color: {{VALUE}}',
				],
				'condition'   => [
					'type' => 'select',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'label_typography',
				'selector' => '{{WRAPPER}} .woocommerce-ordering__label',
				'condition'   => [
					'type' => 'select',
				],
			]
		);

		$this->add_control(
			'select_heading',
			[
				'label' => esc_html__( 'Select', 'motta-addons' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
				'condition'   => [
					'type' => 'select',
				],
			]
		);

		$this->add_control(
			'select_color',
			[
				'label' => esc_html__( 'Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce-ordering select' => 'color: {{VALUE}}',
				],
				'condition'   => [
					'type' => 'select',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'select_typography',
				'selector' => '{{WRAPPER}} .woocommerce-ordering select',
				'condition'   => [
					'type' => 'select',
				],
			]
		);

		$this->add_responsive_control(
			'sort_by_button_width',
			[
				'label'     => esc_html__( 'Button Width', 'motta-addons' ),
				'type'      => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 600,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .motta-product-ordering__button' => 'width: {{SIZE}}{{UNIT}};',
				],
				'condition'   => [
					'type' => ['dropdown', 'modal']
				],
			]
		);

		$this->add_responsive_control(
			'sort_by_button_height',
			[
				'label'     => esc_html__( 'Button Height', 'motta-addons' ),
				'type'      => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 600,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .motta-product-ordering__button' => 'line-height: {{SIZE}}{{UNIT}};',
				],
				'condition'   => [
					'type' => ['dropdown', 'modal']
				],
			]
		);

		$this->add_responsive_control(
			'sort_by_button_padding',
			[
				'label' => esc_html__( 'Padding', 'motta-addons' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .motta-product-ordering__button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'   => [
					'type' => ['dropdown', 'modal']
				],
			]
		);

		$this->add_control(
			'sort_by_button_color',
			[
				'label' => esc_html__( 'Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .motta-product-ordering__button, {{WRAPPER}} .motta-product-ordering__button .name' => 'color: {{VALUE}};',
				],
				'condition'   => [
					'type' => ['dropdown', 'modal']
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'sort_by_button_typography',
				'selector' => '{{WRAPPER}} .motta-product-ordering__button',
				'condition'   => [
					'type' => ['dropdown', 'modal']
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'sort_by_button_border',
				'selector' => '{{WRAPPER}} .motta-product-ordering__button',
				'condition'   => [
					'type' => ['dropdown', 'modal']
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'sort_by_button_box_shadow',
				'label' => __( 'Box Shadow', 'motta-addons' ),
				'selector' => '{{WRAPPER}} .motta-product-ordering__button',
				'condition'   => [
					'type' => ['dropdown', 'modal']
				],
			]
		);


        $this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		add_filter( 'woocommerce_catalog_orderby', array( $this, 'order_by_options' ) );
		if( $settings['type'] == 'select' ) {
			echo '<div class="catalog-toolbar__toolbar">';
			echo sprintf('<span class="woocommerce-ordering__label">%s</span>', esc_html__('Sort by:', 'motta'));
			if (  \Motta\Addons\Elementor\Builder\Helper::is_elementor_editor_mode() ) {
				$this->ordering();
			} else {
				woocommerce_catalog_ordering();
			}
			echo '</div>';

		} elseif( $settings['type'] == 'modal' )  {
			echo '<div class="motta-product-ordering__modal">';
			$modal_id = 'mobile-orderby-modal-' . rand(1, 1000);
			$orderby = $this->catalog_orderby_options();
			echo '<button class="motta-product-ordering__button motta-button--color-black motta-button--ghost" data-toggle="modal" data-target="' . $modal_id . '">'. esc_html__( 'Sort by:', 'motta' ) . '<span class="name">'. $orderby['orderby'] .'</span></button>';
			$this->order_by_modal( $orderby['catalog_orderby_options'], $modal_id );
			echo '<div class="woocommerce-ordering__form hidden">';
			woocommerce_catalog_ordering();
			echo '</div>';
			echo '</div>';
		} else {
			echo '<div class="motta-product-ordering__modal motta-product-ordering__dropdown">';
			$modal_id = 'mobile-orderby-modal-' . rand(1, 1000);
			$orderby = $this->catalog_orderby_options();
			$arrow_icon = '<span class="motta-svg-icon motta-svg-icon--select-arrow"><svg width="24" height="24" aria-hidden="true" role="img" focusable="false" viewBox="0 0 32 32"><path d="M16 30.112l-15.072-15.040 4.544-4.544 10.528 10.56 10.528-10.56 4.544 4.544z"></path></svg></span>';
			echo '<button class="motta-product-ordering__button motta-product-ordering__button-dropdown motta-button--bg-color-white motta-button--raised hidden-sm hidden-md hidden-xs">'. esc_html__( 'Sort by:', 'motta' ) . '<span class="name">'. $orderby['orderby'] .'</span>' . $arrow_icon . '</button>';
			echo '<button class="motta-product-ordering__button motta-product-ordering__button-modal motta-button--bg-color-white motta-button--raised  hidden-lg" data-toggle="modal" data-target="' . $modal_id . '">'. esc_html__( 'Sort by:', 'motta' ) . '<span class="name">'. $orderby['orderby'] .'</span>' . $arrow_icon . '</button>';
			$this->order_by_dropdown( $orderby['catalog_orderby_options'] );
			$this->order_by_modal( $orderby['catalog_orderby_options'], $modal_id );
			echo '<div class="woocommerce-ordering__form hidden">';
			woocommerce_catalog_ordering();
			echo '</div>';
			echo '</div>';
		}
		remove_filter( 'woocommerce_catalog_orderby', array( $this, 'order_by_options' ) );

	}

	public function render_plain_content() {}

	public function get_group_name() {
		return 'woocommerce';
	}

	public function ordering() {
	?>
	<form class="woocommerce-ordering" method="get">
		<select name="orderby" class="orderby">
			<?php
				$catalog_orderby = $this->catalog_orderby_options();
				$catalog_orderby = $catalog_orderby ? $catalog_orderby['catalog_orderby_options'] : array();
				foreach ( $catalog_orderby as $id => $name ) {
					echo '<option value="' . esc_attr( $id ) . '" ' . selected( 'menu_order', $id, false ) . '>' . esc_attr( $name ) . '</option>';
				}
			?>
		</select>
	</form>
	<?php
	}

	public function catalog_orderby_options(){
		$catalog_orderby_options = $this->order_by_options();
		$show_default_orderby    = 'menu_order' === apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby', 'menu_order' ) );

		$default_orderby = wc_get_loop_prop( 'is_search' ) ? 'relevance' : apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby', '' ) );
		// phpcs:disable WordPress.Security.NonceVerification.Recommended
		$orderby = isset( $_GET['orderby'] ) ? wc_clean( wp_unslash( $_GET['orderby'] ) ) : $default_orderby;
		// phpcs:enable WordPress.Security.NonceVerification.Recommended

		if ( wc_get_loop_prop( 'is_search' ) ) {
			$catalog_orderby_options = array_merge( array( 'relevance' => __( 'Relevance', 'woocommerce' ) ), $catalog_orderby_options );

			unset( $catalog_orderby_options['menu_order'] );
		}

		if ( ! $show_default_orderby ) {
			unset( $catalog_orderby_options['menu_order'] );
		}

		if ( ! wc_review_ratings_enabled() ) {
			unset( $catalog_orderby_options['rating'] );
		}

		if ( array_key_exists( $orderby, $catalog_orderby_options ) ) {
			$orderby = $catalog_orderby_options[$orderby];
		}

		return array(
			'catalog_orderby_options' => $catalog_orderby_options,
			'orderby'                 => $orderby,
		);

	}

	public function order_by_modal($orderby, $modal_id) {
		?>
		<div data-id="<?php echo esc_attr($modal_id); ?>" class="modal mobile-orderby-modal">
			<div class="modal__backdrop"></div>
			<div class="modal__container">
				<?php echo \Motta\Icon::get_svg( 'close', 'ui', 'class=modal__button-close' ); ?>
				<div class="modal__header">
					<?php echo esc_html__( 'Sort by', 'motta' ); ?>
				</div>
				<div class="modal__content">
					<ul class="mobile-orderby-list">
						<?php foreach ( $orderby as $id => $name ) : ?>
							<li><a href="#" data-id="<?php echo esc_attr( $id ); ?>" data-title="<?php echo esc_attr( $name ); ?>"><?php echo esc_html( $name ); ?></a></li>
						<?php endforeach; ?>
					</ul>
				</div>
			</div>
		</div>
		<?php
	}

	public function order_by_dropdown($orderby) {
		?>
		<ul class="orderby-list">
			<?php foreach ( $orderby as $id => $name ) : ?>
				<li><a href="#" data-id="<?php echo esc_attr( $id ); ?>" data-title="<?php echo esc_attr( $name ); ?>"><?php echo esc_html( $name ); ?></a></li>
			<?php endforeach; ?>
		</ul>
		<?php
	}

	/**
	 * Update ordering options.
	 *
	 * @param array $options
	 *
	 * @return array
	 */
	public function order_by_options() {
		$options = array (
			'menu_order' => __( 'Default', 'motta' ),
			'popularity' => __( 'Popularity', 'motta' ),
			'rating'     => __( 'Average rating', 'motta' ),
			'date'       => __( 'Latest', 'motta' ),
			'price'      => __( 'Price: low to high', 'motta' ),
			'price-desc' => __( 'Price: high to low', 'motta' ),
		);
		return $options;
	}
}
