<?php
namespace Motta\Addons\Elementor\Builder\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Archive_Product_View extends Widget_Base {
	public function get_name() {
		return 'motta-archive-product-view';
	}

	public function get_title() {
		return esc_html__( '[Motta] Archive Product View', 'motta-addons' );
	}

	public function get_icon() {
		return 'eicon-preview-thin';
	}

	public function get_categories() {
		return ['motta-wc-addons'];
	}

	public function get_keywords() {
		return [ 'woocommerce', 'product', 'archive', 'view' ];
	}

	public function get_script_depends() {
		return [ 'motta-product-archive' ];
	}

	public function get_style_depends() {
		return [ 'motta-product-archive' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
            'view_content',
            [
                'label' => __( 'View', 'motta-addons' ),
            ]
        );

		$this->add_control(
			'list',
			[
				'label' => esc_html__( 'Show Views', 'motta-addons' ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => [
					'grid_2' => esc_html__( 'Grid 2', 'motta-addons' ),
					'grid_3' => esc_html__( 'Grid 3', 'motta-addons' ),
					'grid_4' => esc_html__( 'Grid 4', 'motta-addons' ),
					'grid_5' => esc_html__( 'Grid 5', 'motta-addons' ),
					'list' => esc_html__( 'List', 'motta-addons' ),
				],
				'default' => [ 'grid_2', 'grid_3', 'grid_4', 'list' ],
			]
		);

		$this->add_control(
			'default_view',
			[
				'label' => esc_html__( 'Default View', 'motta-addons' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'label_block' => true,
				'options' => [
					'grid_2' => esc_html__( 'Grid 2', 'motta-addons' ),
					'grid_3' => esc_html__( 'Grid 3', 'motta-addons' ),
					'grid_4' => esc_html__( 'Grid 4', 'motta-addons' ),
					'grid_5' => esc_html__( 'Grid 5', 'motta-addons' ),
					'list' => esc_html__( 'List', 'motta-addons' ),
				],
				'default' =>'grid_4',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
            'view_style',
            [
                'label' => __( 'View', 'motta-addons' ),
				'tab' => Controls_Manager::TAB_STYLE,
            ]
        );


		$this->add_control(
			'color',
			[
				'label' => esc_html__( 'Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .motta-toolbar-view a' => 'color: {{VALUE}}',
				],
			]
		);


		$this->add_control(
			'active_color',
			[
				'label' => esc_html__( 'Active Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .motta-toolbar-view a.current, {{WRAPPER}} .motta-toolbar-view a:hover, {{WRAPPER}}  .motta-toolbar-view a.current::after' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'icon_size',
			[
				'label'     => esc_html__( 'Icon Size', 'motta-addons' ),
				'type'      => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .motta-toolbar-view a' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'spacing',
			[
				'label'     => esc_html__( 'Spacing', 'motta-addons' ),
				'type'      => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .motta-toolbar-view a' => 'margin-left: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();
	}

	protected function render() {
		$settings   = $this->get_settings_for_display();
		$views = array();
		$output_type = array();
		if ( ! $settings['list'] ) {
			return;
		}
		foreach ( $settings['list'] as $item ) {
			switch ( $item ) {
				case 'grid_2':
					$views['grid-2'] = 'view-large';
					break;
				case 'grid_3':
					$views['grid-3'] = 'view-medium';
					break;
				case 'grid_4':
					$views['default'] = 'view-small';
					break;
				case 'grid_5':
					$views['grid-5'] = 'view-small-extra';
					break;
				case 'list':
					$views['list'] = 'view-list';
					break;
			}
		}
		$catalog_view = isset( $_COOKIE['catalog_view'] ) ? $_COOKIE['catalog_view'] : $settings['default_view'];
		$catalog_view = apply_filters( 'motta_catalog_view', $catalog_view );
		$catalog_view = str_replace('_', '-', $catalog_view);
		foreach( $views as $key => $index ) {
			$key_current = $key;
			$key_current = $key_current == 'default' ? '4' : $key_current;
			$class = $catalog_view == $key_current ? 'current' : '';

			$output_type[] = sprintf(
				'<a href="#" class="%1$s %2$s" data-view="%1$s" data-type="%1$s">%3$s</a>',
				esc_attr( $key ),
				esc_attr( $class ),
				\Motta\Addons\Helper::get_svg( $index )
			);
		}

		echo sprintf(
			'<div class="motta-toolbar-view">%s</div>',
			implode( $output_type )
		);
	}

	public function render_plain_content() {}

	public function get_group_name() {
		return 'woocommerce';
	}

}
