<?php
namespace Motta\Addons\Elementor\Builder\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Archive_Result_Count extends Widget_Base {
	public function get_name() {
		return 'motta-archive-result-count';
	}

	public function get_title() {
		return esc_html__( '[Motta] Archive Result Count', 'motta-addons' );
	}

	public function get_icon() {
		return 'eicon-counter';
	}

	public function get_categories() {
		return ['motta-wc-addons'];
	}

	public function get_keywords() {
		return [ 'woocommerce', 'result', 'archive', 'count' ];
	}

	public function get_style_depends() {
		return [ 'motta-product-archive' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
            'result_count_content',
            [
                'label' => __( 'Result Count', 'motta-addons' ),
            ]
        );

		$this->add_control(
			'product_per_page',
			[
				'label' => __( 'Product Per Page', 'motta-addons' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 16,
				'separator' => 'after'
			]
		);

		$this->add_control(
			'color',
			[
				'label' => esc_html__( 'Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .motta-result-count' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'typography',
				'selector' => '{{WRAPPER}} .motta-result-count',
			]
		);

        $this->end_controls_section();
	}

	protected function render() {
		$settings   = $this->get_settings_for_display();
		if (  \Motta\Addons\Elementor\Builder\Helper::is_elementor_editor_mode() ) {
			echo '<div class="motta-result-count">';
			$args = array(
				'total'    => wp_count_posts( 'product' )->publish,
				'per_page' => $settings['product_per_page'],
				'current'  => 1,
			);
			wc_get_template( 'loop/result-count.php', $args );
			echo '</div>';
		} else {
			if ( ! wc_get_loop_prop( 'is_paginated' ) || ! woocommerce_products_will_display() ) {
				return;
			}

			$total    = wc_get_loop_prop( 'total' );
			$per_page = $settings['product_per_page'];
			$current  = wc_get_loop_prop( 'current_page' );

			echo '<div class="motta-result-count">';
			if ( 1 === intval( $total ) ) {
				_e( 'Single Result', 'motta' );
			} elseif ( $total <= $per_page || -1 === $per_page ) {
				printf( _n( '%d Result', '%d Results', $total, 'motta' ), $total );
			} else {
				$first = ( $per_page * $current ) - $per_page + 1;
				$last  = min( $total, $per_page * $current );
				printf( _nx( '%1$d&ndash;%2$d of %3$d Result', '%1$d&ndash;%2$d of %3$d Results', $total, 'with first and last result', 'motta' ), $first, $last, $total );
			}
			echo '</div>';
		}
	}

	public function render_plain_content() {}

	public function get_group_name() {
		return 'woocommerce';
	}
}
