<?php
namespace Motta\Addons\Elementor\Builder\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Product_Compare extends Widget_Base {

	use \Motta\Addons\Elementor\Builder\Traits\Product_Id_Trait;

	public function get_name() {
		return 'motta-wc-product-compare';
	}

	public function get_title() {
		return esc_html__( '[Motta] Product Compare', 'motta-addons' );
	}

	public function get_icon() {
		return 'eicon-exchange';
	}

	public function get_categories() {
		return ['motta-wc-addons'];
	}

	public function get_keywords() {
		return [ 'woocommerce', 'compare', 'store', 'heart', 'product' ];
	}

	public function get_style_depends() {
		return [ 'motta-elementor-single-product' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_product_rating_style',
			[
				'label' => esc_html__( 'Style', 'motta-addons' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label' => esc_html__( 'Alignment', 'motta-addons' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'motta-addons' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'motta-addons' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'motta-addons' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => '',
				'selectors' => [
					'.woocommerce {{WRAPPER}}' => 'text-align: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'compare_color',
			[
				'label' => esc_html__( 'Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .wcboost-products-compare-button' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'compare_color_hover',
			[
				'label' => esc_html__( 'Color Hover', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .wcboost-products-compare-button:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'selector' => '.woocommerce {{WRAPPER}} .wcboost-products-compare-button',
			]
		);

		$this->add_control(
			'icon_size',
			[
				'label' => esc_html__( 'Icon Size', 'motta-addons' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .wcboost-products-compare-button .wcboost-products-compare-button__icon' => 'font-size: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_control(
			'icon_spacing',
			[
				'label' => esc_html__( 'Icon Spacing', 'motta-addons' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => 'px',
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .wcboost-products-compare-button .wcboost-products-compare-button__icon + .wcboost-products-compare-button__text' => 'padding-left: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		global $product;
		$product = $this->get_product();

		if ( ! $product ) {
			return;
		}
		if( \Motta\Addons\Elementor\Builder\Helper::is_elementor_editor_mode()) {
			add_filter( 'wcboost_products_compare_single_add_to_compare_link', array( \Motta\WooCommerce\Compare::instance(), 'add_to_compare_link' ), 20, 2 );
		}
		if( class_exists('\WCBoost\ProductsCompare\Frontend') ) {
			\WCBoost\ProductsCompare\Frontend::instance()->single_add_to_compare_button();
		}

		if( \Motta\Addons\Elementor\Builder\Helper::is_elementor_editor_mode()) {
			remove_filter('wcboost_products_compare_single_add_to_compare_link', array( \Motta\WooCommerce\Compare::instance(), 'add_to_compare_link' ), 20, 2 );
		}

	}

	public function render_plain_content() {}

	public function get_group_name() {
		return 'woocommerce';
	}
}