<?php
namespace Motta\Addons\Elementor\Builder\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Product_Content extends Widget_Base {

	use \Motta\Addons\Elementor\Builder\Traits\Product_Id_Trait;

	public function get_name() {
		return 'motta-wc-product-content';
	}

	public function get_title() {
		return esc_html__( '[Motta] Product Content', 'motta-addons' );
	}

	public function get_icon() {
		return 'eicon-post-content';
	}

	public function get_keywords() {
		return [ 'woocommerce', 'shop', 'store', 'description', 'product', 'content' ];
	}

	public function get_categories() {
		return [ 'motta-wc-addons' ];
	}

	public function get_style_depends() {
		return [ 'motta-elementor-single-product' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_product_content',
			[
				'label' => esc_html__( 'Content', 'motta-addons' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'motta-addons' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Description', 'motta-addons' ),
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_product_content_style',
			[
				'label' => esc_html__( 'Content', 'motta-addons' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'heading_title',
			[
				'label' => __( 'Title', 'motta-addons' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'desc_title_color',
			[
				'label' => esc_html__( 'Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .motta-product-tab-content__title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'desc_title_typography',
				'selector' => '.woocommerce {{WRAPPER}} .motta-product-tab-content__title',
			]
		);

		$this->add_control(
			'desc_title_spacing',
			[
				'label' => __( 'Spacing', 'motta-addons' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
					]
				],
				'default' => [],
				'selectors' => [
					'.woocommerce {{WRAPPER}} .motta-product-tab-content__title' => 'margin-bottom: {{SIZE}}{{UNIT}}',
				],
			]
		);


		$this->end_controls_section();

	}

	protected function render() {
		global $product;

		$product = $this->get_product();

		if ( ! $product ) {
			return;
		}
		$settings = $this->get_settings_for_display();
		setup_postdata( $product->get_id() );
		$post = get_post( $product->get_id() );
		if (  \Motta\Addons\Elementor\Builder\Helper::is_elementor_editor_mode() ) {
			$original_post = $GLOBALS['post'];
			$GLOBALS['post'] = $post;
			setup_postdata( $GLOBALS['post'] );
		}
		if( !$post || empty($post->post_content) ) {
			return;
		}
		echo '<div id="tab-description" class="woocommerce-tabs woocommerce-tabs--description">';
		if( $settings['title'] ) {
			echo sprintf('<h2 class="motta-product-tab-content__title">%s</h2>', $settings['title'] );
		}
		the_content();
		if (  \Motta\Addons\Elementor\Builder\Helper::is_elementor_editor_mode() ) {
			$GLOBALS['post'] = $original_post;
		}
		echo '</div>';
	}

	public function render_plain_content() {}

	public function get_group_name() {
		return 'woocommerce';
	}

}
