<?php
namespace Motta\Addons\Elementor\Builder\Widgets;

use DgoraWcas\Integrations\Plugins\Elementor\Elementor;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Product_Data_Tabs extends Widget_Base {

	use \Motta\Addons\Elementor\Builder\Traits\Product_Id_Trait;

	public function get_name() {
		return 'motta-wc-product-data-tabs';
	}

	public function get_title() {
		return esc_html__( '[Motta] Product Data Tabs', 'motta-addons' );
	}

	public function get_icon() {
		return 'eicon-product-tabs';
	}

	public function get_keywords() {
		return [ 'woocommerce', 'shop', 'store', 'data', 'product', 'tabs' ];
	}

	public function get_categories() {
		return [ 'motta-wc-addons' ];
	}

	public function get_script_depends() {
		return [
			'motta-elementor-single-product'
		];
	}

	public function get_style_depends() {
		return [ 'motta-elementor-single-product' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_product_content',
			[
				'label' => esc_html__( 'Content', 'motta-addons' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout',
			[
				'label' => esc_html__( 'Layout', 'motta-addons' ),
				'type' => Controls_Manager::CHOOSE,
				'default' => 'tabs',
				'options' => [
					'tabs' => [
						'title' => esc_html__( 'Tabs', 'motta-addons' ),
						'icon' => 'eicon-tabs',
					],
					'toggle' => [
						'title' => esc_html__( 'Toggle', 'motta-addons' ),
						'icon' => 'eicon-toggle',
					],
				],
				'toggle' => false,
				'prefix_class' => 'motta-product-tabs-type--',
			]
		);


		$this->add_control(
			'product_first_tab',
			[
				'label' => esc_html__( 'Open First Tab', 'motta-addons' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'motta-addons' ),
				'label_off' => esc_html__( 'No', 'motta-addons' ),
				'return_value' => 'yes',
				'default' => '',
				'condition'   => [
					'layout' => 'toggle',
				],
				'prefix_class' => 'motta-product-first-tab--',
			]
		);

		$this->add_control(
			'product_first_tab_mobile',
			[
				'label' => esc_html__( 'Open First Tab On Mobile', 'motta-addons' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'motta-addons' ),
				'label_off' => esc_html__( 'No', 'motta-addons' ),
				'return_value' => 'yes',
				'default' => '',
				'condition'   => [
					'layout' => 'tabs',
				],
				'prefix_class' => 'motta-product-first-tab-mobile--',
			]
		);

		$this->add_control(
			'heading_product_description',
			[
				'label' => esc_html__( 'Description Tab', 'motta-addons' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'product_description',
			[
				'label' => esc_html__( 'Description', 'motta-addons' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'motta-addons' ),
				'label_off' => esc_html__( 'No', 'motta-addons' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'heading_product_reviews',
			[
				'label' => esc_html__( 'Reviews Tab', 'motta-addons' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'product_reviews',
			[
				'label' => esc_html__( 'Reviews', 'motta-addons' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'motta-addons' ),
				'label_off' => esc_html__( 'No', 'motta-addons' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'heading_tab_icon',
			[
				'label' => esc_html__( 'Tab Icon', 'motta-addons' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'tab_icon',
			[
				'label' => __( 'Icon', 'motta-addons' ),
				'type' => Controls_Manager::ICONS,
				'default' => [],
			]
		);

		$this->add_control(
			'tab_icon_active',
			[
				'label' => __( 'Icon Active', 'motta-addons' ),
				'type' => Controls_Manager::ICONS,
				'default' => [],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_product_content_style',
			[
				'label' => esc_html__( 'Content', 'motta-addons' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition'   => [
					'layout' => 'tabs',
				],
			]
		);

		$this->add_control(
			'content_padding',
			[
				'label' => esc_html__( 'Padding', 'motta-addons' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs' => '--motta-product-tabs-padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'   => [
					'layout' => 'tabs',
				],
			]
		);

		$this->add_control(
			'content_border_color',
			[
				'label' => esc_html__( 'Border Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs' => '--motta-product-tabs-border-color: {{VALUE}}',
				],
				'condition'   => [
					'layout' => 'tabs',
				],
			]
		);

		$this->add_control(
			'content_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'motta-addons' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs' => '--motta-product-tabs-border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
				'condition'   => [
					'layout' => 'tabs',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_product_tabs_style',
			[
				'label' => esc_html__( 'Tabs', 'motta-addons' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs( 'tabs_style' );

		$this->start_controls_tab( 'normal_tabs_style',
			[
				'label' => esc_html__( 'Normal', 'motta-addons' ),
			]
		);


		$this->add_control(
			'tab_text_color',
			[
				'label' => esc_html__( 'Text Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs' => '--motta-product-tabs-item-text-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'tab_bg_color',
			[
				'label' => esc_html__( 'Background Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'alpha' => false,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs' => '--motta-product-tabs-item-bg-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'tabs_border_color',
			[
				'label' => esc_html__( 'Border Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs' => '--motta-product-tabs-item-border-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab( 'active_tabs_style',
			[
				'label' => esc_html__( 'Active', 'motta-addons' ),
			]
		);

		$this->add_control(
			'active_tab_text_color',
			[
				'label' => esc_html__( 'Text Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs' => '--motta-product-tabs-item-active-text-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'active_tab_bg_color',
			[
				'label' => esc_html__( 'Background Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'alpha' => false,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs' => '--motta-product-tabs-item-active-bg-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'active_tabs_border_color',
			[
				'label' => esc_html__( 'Border Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs' => '--motta-product-tabs-item-active-border-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'separator_tabs_style',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);

		$this->add_responsive_control(
			'tab_padding',
			[
				'label' => esc_html__( 'Padding', 'motta-addons' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs' => '--motta-product-tabs-item-padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'tab_typography',
				'selector' => '.woocommerce {{WRAPPER}} .woocommerce-tabs ul.wc-tabs li a, .woocommerce {{WRAPPER}} .woocommerce-tabs .motta-dropdown__title',
			]
		);

		$this->add_control(
			'tab_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'motta-addons' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs' => '--motta-product-tabs-item-border-radius: {{SIZE}}{{UNIT}} {{SIZE}}{{UNIT}} {{SIZE}}{{UNIT}} {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_control(
			'heading_tab_icon_style',
			[
				'label' => esc_html__( 'Tab Icon', 'motta-addons' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'tab_icon_color',
			[
				'label' => esc_html__( 'Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs .motta-dropdown__title span.motta-svg-icon' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'tab_icon_bg_color',
			[
				'label' => esc_html__( 'Background Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs .motta-dropdown__title .motta-svg-icon' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'tab_icon_border_color',
			[
				'label' => esc_html__( 'Border Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs .motta-dropdown__title .motta-svg-icon' => 'border: 1px solid {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'tab_icon_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'motta-addons' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs .motta-dropdown__title .motta-svg-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'tab_icon_padding',
			[
				'label' => esc_html__( 'Padding', 'motta-addons' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs .motta-dropdown__title .motta-svg-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'tab_icon_size',
			[
				'label' => esc_html__( 'Size', 'motta-addons' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs .motta-dropdown__title span.motta-svg-icon' => 'font-size: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_product_panel_style',
			[
				'label' => esc_html__( 'Panel', 'motta-addons' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'panel_typography',
				'selector' => '.woocommerce {{WRAPPER}} .woocommerce-tabs .motta-dropdown__content',
			]
		);

		$this->add_control(
			'panel_padding',
			[
				'label' => esc_html__( 'Padding', 'motta-addons' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs .woocommerce-Tabs-panel .motta-dropdown__content' => '--motta-product-tabs-panel-padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


		$this->end_controls_section();
	}

	protected function render() {
		global $product;

		$product = $this->get_product();

		if ( ! $product ) {
			return;
		}
		$settings = $this->get_settings_for_display();
		setup_postdata( $product->get_id() );

		if (  \Motta\Addons\Elementor\Builder\Helper::is_elementor_editor_mode() ) {
			$original_post = $GLOBALS['post'];
			$GLOBALS['post'] = get_post( $product->get_id() );
			setup_postdata( $GLOBALS['post'] );
			add_filter( 'the_content', [ $this, 'product_content' ] );
		}

		if( $settings['product_description'] != 'yes' ) {
			add_filter( 'woocommerce_product_tabs', array( $this, 'unset_description_tab' ) );
		}

		if( $settings['product_reviews'] != 'yes' ) {
			add_filter( 'woocommerce_product_tabs', array( $this, 'unset_review_tab' ) );
		}
		add_filter( 'motta_product_tabs_icon', array( $this, 'product_tabs_icon' ) );
		add_filter( 'motta_product_tabs_heading_classes', array( $this, 'product_tabs_heading_classes' ) );
		add_filter('motta_product_tabs_dropdown', '__return_false');

		wc_get_template( 'single-product/tabs/tabs.php' );
		if( $settings['product_description'] != 'yes' ) {
			remove_filter( 'woocommerce_product_tabs', array( $this, 'unset_description_tab' ) );
		}
		if( $settings['product_reviews'] != 'yes' ) {
			remove_filter( 'woocommerce_product_tabs', array( $this, 'unset_review_tab' ) );
		}
		remove_filter( 'motta_product_tabs_icon', array( $this, 'product_tabs_icon' ) );
		if (  \Motta\Addons\Elementor\Builder\Helper::is_elementor_editor_mode() ) {
			$GLOBALS['post'] = $original_post;
			remove_filter( 'the_content', [ $this, 'product_content' ] );
		}

		remove_filter( 'motta_product_tabs_heading_classes', array( $this, 'product_tabs_heading_classes' ) );
		remove_filter('motta_product_tabs_dropdown', '__return_false');

		// On render widget from Editor - trigger the init manually.
		if (  \Motta\Addons\Elementor\Builder\Helper::is_elementor_editor_mode() ) {
			?>
			<script>
				jQuery( '.wc-tabs-wrapper, .woocommerce-tabs, #rating' ).trigger( 'init' );
			</script>
			<?php
		}
	}

	public function render_plain_content() {}

	public function get_group_name() {
		return 'woocommerce';
	}

    public function product_content( $content ){
		global $product;

		$product = $this->get_product();

		if ( ! $product ) {
			return;
		}
        $product_content = get_post( $product->get_id() );
        $content = $product_content->post_content;
        return $content;
    }

	public function unset_review_tab( $tabs ) {
		if( isset( $tabs[ 'reviews' ] ) ) {
			unset( $tabs[ 'reviews' ] );
		}

		return $tabs;
	}

	public function unset_description_tab( $tabs ) {
		if( isset( $tabs[ 'description' ] ) ) {
			unset( $tabs[ 'description' ] );
		}

		return $tabs;
	}

	public function product_tabs_icon($icon) {
		$settings = $this->get_settings_for_display();
		$tab_icon = '';
		if( $settings['tab_icon'] && $settings['tab_icon']['value'] ) {
			$tab_icon  .= '<span class="motta-svg-icon icon-noactive">';
			$tab_icon  .= \Elementor\Icons_Manager::try_get_icon_html( $settings['tab_icon'], [ 'aria-hidden' => 'true' ] );
			$tab_icon  .= '</span>';
		} else {
			$tab_icon .= \Motta\Addons\Helper::get_svg( 'plus', '', array( 'class' => 'icon-plus icon-noactive' ) );
		}

		if( $settings['tab_icon_active'] && $settings['tab_icon_active']['value'] ) {
			$tab_icon  .= '<span class="motta-svg-icon icon-active">';
			$tab_icon  .= \Elementor\Icons_Manager::try_get_icon_html( $settings['tab_icon_active'], [ 'aria-hidden' => 'true' ] );
			$tab_icon  .= '</span>';
		} else {
			$tab_icon .= \Motta\Addons\Helper::get_svg( 'minus', '', array( 'class' => 'icon-plus icon-active' ) );
		}

		return $tab_icon;

	}

	public function product_tabs_heading_classes($classes) {
		$settings = $this->get_settings_for_display();
		$classes = '';
		if( $settings['layout'] == 'tabs' ) {
			$classes = 'tabs wc-tabs';
		}

		return $classes;
	}
}
