<?php
namespace Motta\Addons\Elementor\Builder\Widgets;

use Automattic\Jetpack\Search\Helper;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Widget_Base;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Product_Images extends Widget_Base {

	use \Motta\Addons\Elementor\Builder\Traits\Product_Id_Trait;

	public function get_name() {
		return 'motta-wc-product-images';
	}

	public function get_title() {
		return esc_html__( '[Motta] Product Images', 'motta-addons' );
	}

	public function get_icon() {
		return 'eicon-product-images';
	}

	public function get_categories() {
		return [ 'motta-wc-addons' ];
	}

	public function get_keywords() {
		return [ 'woocommerce', 'shop', 'store', 'image', 'product', 'gallery', 'lightbox' ];
	}

	public function get_script_depends() {
		return [
			'imagesLoaded',
			'threesixty',
			'magnific',
			'motta-elementor-single-product'
		];
	}

	public function get_style_depends() {
		return [ 'magnific','motta-elementor-single-product' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_product_images',
			[ 'label' => __( 'Product Images', 'motta-addons' ) ]
		);

		$this->add_control(
			'image_zoom',
			[
				'label' => esc_html__( 'Image Zoom', 'motta-addons' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'motta-addons' ),
				'label_off' => esc_html__( 'Hide', 'motta-addons' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'image_lightbox',
			[
				'label' => esc_html__( 'Image Lightbox', 'motta-addons' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'motta-addons' ),
				'label_off' => esc_html__( 'Hide', 'motta-addons' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'product_video',
			[
				'label' => esc_html__( 'Video Featured', 'motta-addons' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'motta-addons' ),
				'label_off' => esc_html__( 'Hide', 'motta-addons' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'product_306_degree',
			[
				'label' => esc_html__( '360 Degree', 'motta-addons' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'motta-addons' ),
				'label_off' => esc_html__( 'Hide', 'motta-addons' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'heading_thumbnails',
			[
				'label' => esc_html__( 'Thumbnails', 'motta-addons' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'thumbnails_position',
			[
				'label'      => esc_html__( 'Position', 'motta-addons' ),
				'type'       => Controls_Manager::SELECT,
				'options'    => [
					''     => esc_html__( 'Bottom', 'motta-addons' ),
					'left'  => esc_html__( 'Left', 'motta-addons' ),
				],
				'default'    => '',
				'frontend_available' => true,

			]
		);

		$this->add_control(
			'thumbnails_per_view',
			[
				'label' => esc_html__( 'Items Per View', 'motta-addons' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 5,
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'heading_mobile',
			[
				'label' => esc_html__( 'Mobile', 'motta-addons' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'product_go_back',
			[
				'label' => esc_html__( 'Go Back', 'motta-addons' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'motta-addons' ),
				'label_off' => esc_html__( 'Hide', 'motta-addons' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'product_share',
			[
				'label' => esc_html__( 'Share', 'motta-addons' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'motta-addons' ),
				'label_off' => esc_html__( 'Hide', 'motta-addons' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'product_wishlist',
			[
				'label' => esc_html__( 'Wishlist', 'motta-addons' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'motta-addons' ),
				'label_off' => esc_html__( 'Hide', 'motta-addons' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'product_compare',
			[
				'label' => esc_html__( 'Compare', 'motta-addons' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'motta-addons' ),
				'label_off' => esc_html__( 'Hide', 'motta-addons' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_product_gallery_style',
			[
				'label' => esc_html__( 'Style', 'motta-addons' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'heading_image_style',
			[
				'label' => esc_html__( 'Image', 'motta-addons' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'image_border',
				'selector' => '{{WRAPPER}} .woocommerce-product-gallery__image > a',
			]
		);

		$this->add_control(
			'image_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'motta-addons' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .woocommerce-product-gallery__image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'heading_thumbnail_style',
			[
				'label' => esc_html__( 'Thumbnail Icon Button', 'motta-addons' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'thumbnail_icon_padding',
			[
				'label' => esc_html__( 'Padding', 'motta-addons' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .woocommerce-product-gallery__thumbs-carousel .motta-swiper-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'thumbnail_icon_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'motta-addons' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .woocommerce-product-gallery__thumbs-carousel .motta-swiper-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'thumbnail_icon_size',
			[
				'label' => esc_html__( 'Icon Size', 'motta-addons' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .woocommerce-product-gallery__thumbs-carousel .motta-swiper-button' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->start_controls_tabs( 'thumbs_button_style_tabs' );

		$this->start_controls_tab( 'thumbs_button_style_normal',
			[
				'label' => esc_html__( 'Normal', 'motta-addons' ),
			]
		);

		$this->add_control(
			'thumbs_button_text_color',
			[
				'label' => esc_html__( 'Text Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce-product-gallery__thumbs-carousel .motta-swiper-button' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'thumbs_button_bg_color',
			[
				'label' => esc_html__( 'Background Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce-product-gallery__thumbs-carousel .motta-swiper-button' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab( 'thumbs_button_style_hover',
			[
				'label' => esc_html__( 'Hover', 'motta-addons' ),
			]
		);

		$this->add_control(
			'thumbs_button_text_color_hover',
			[
				'label' => esc_html__( 'Text Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce-product-gallery__thumbs-carousel .motta-swiper-button:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'thumbs_button_bg_color_hover',
			[
				'label' => esc_html__( 'Background Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce-product-gallery__thumbs-carousel .motta-swiper-button:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'heading_featured_icons_style',
			[
				'label' => esc_html__( 'Featured Icons', 'motta-addons' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'featured_icons_direction',
			[
				'label'      => esc_html__( 'Direction', 'motta-addons' ),
				'type'       => Controls_Manager::SELECT,
				'options'    => [
					'horizontal'     => esc_html__( 'Horizontal', 'motta-addons' ),
					'vertical'  => esc_html__( 'Vertical', 'motta-addons' ),
				],
				'default'    => 'vertical',
			]
		);

		$this->add_control(
			'featured_icons_alignment',
			[
				'label'                => esc_html__( 'Alignment', 'motta-addons' ),
				'type'                 => Controls_Manager::CHOOSE,
				'options'              => [
					'left'   => [
						'title' => esc_html__( 'Left', 'motta-addons' ),
						'icon' 	=> 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'motta-addons' ),
						'icon' 	=> 'eicon-text-align-center',
					],
					'right'  => [
						'title' => esc_html__( 'Right', 'motta-addons' ),
						'icon' 	=> 'eicon-text-align-right',
					],
				],
				'default'              => 'left',
				'condition' => [
					'featured_icons_direction' => 'horizontal',
				],
			]
		);

		$this->add_control(
			'spacing_bottom_featured_icons',
			[
				'label' => esc_html__( 'Spacing Bottom', 'motta-addons' ),
				'type' => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .product-gallery-summary .motta-product-images-buttons' => 'bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'spacing_left_featured_icons',
			[
				'label' => esc_html__( 'Spacing Left', 'motta-addons' ),
				'type' => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .product-gallery-summary .motta-product-images-buttons' => 'left: {{SIZE}}{{UNIT}};',
				],
				'conditions' => [
					'relation' => 'or',
					'terms' => [
						[
							'terms' => [
								[
									'name' => 'featured_icons_direction',
									'value' => 'horizontal',
								],
								[
									'name' => 'featured_icons_alignment',
									'value' => 'left',
								],
							]

						],
						[
							'terms' => [
								[
									'name' => 'featured_icons_direction',
									'value' => 'vertical',
								],
							]

						],
					],
				],
			]
		);

		$this->add_control(
			'heading_mobile_style',
			[
				'label' => esc_html__( 'Mobile', 'motta-addons' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'thumbnails_mobile',
			[
				'label'      => esc_html__( 'Thumbnails', 'motta-addons' ),
				'type'       => Controls_Manager::SELECT,
				'options'    => [
					'dots'     => esc_html__( 'Dots', 'motta-addons' ),
					'label'  => esc_html__( 'Label', 'motta-addons' ),
				],
				'default'    => 'dots',
			]
		);

		$this->end_controls_section();
	}

	public function render() {
		global $product;

		$product = $this->get_product();

		if ( ! $product ) {
			return;
		}
		$settings = $this->get_settings_for_display();

		if( $settings['product_video'] == 'yes' ) {
			wp_enqueue_style('magnific');
			wp_enqueue_script('magnific');
		}

		$gallery_class = $settings['image_zoom'] == 'yes' ? '' : 'product-image-zoom--disable';
		$gallery_class .= $settings['thumbnails_position'] == 'left' ? ' product-thumbnails-vertical' : '';
		$gallery_class .= ' product-featured-icons--' . $settings['featured_icons_direction'];
		$gallery_class .= ' product-featured-icons--'. $settings['featured_icons_alignment'];
		$gallery_class .= ' product-thumbnails-mobile--' . $settings['thumbnails_mobile'];
		$degree_options = array();
		$degree_options['images'] = $this->get_360_images( $product );
		$degree_options['total_frames'] = count($this->get_360_images( $product ));

		$this->add_render_attribute(
			'degree', 'data-options', [
				wp_json_encode($degree_options)
			]
		);
		?>

		<div class="product-gallery-summary motta-product-gallery <?php echo esc_attr($gallery_class); ?>">
			<div class="motta-product-images-buttons">
				<?php if( $this->has_360_images($settings, $product) ) { ?>
					<a href="#" <?php $this->print_render_attribute_string( 'degree' ); ?> class="motta-button motta-button--icon motta-button--raised motta-shape--circle  motta-button--product-degree" data-toggle="modal" data-target="product-degree-pswp">
						<span class="motta-svg-icon motta-svg-icon--360">
							<svg width="24" height="24" aria-hidden="true" role="img" focusable="false" viewBox="0 0 32 32"><path d="M7.733 15.773c0.6 0.187 1.080 0.507 1.44 0.96s0.547 1 0.547 1.64c0 1-0.333 1.773-0.987 2.32s-1.467 0.813-2.44 0.813c-0.773 0-1.453-0.173-2.067-0.533-0.6-0.36-1.027-0.88-1.307-1.573l2.080-1.187c0.2 0.653 0.627 0.973 1.28 0.973 0.333 0 0.6-0.080 0.773-0.24 0.187-0.16 0.28-0.373 0.28-0.64s-0.093-0.48-0.28-0.64c-0.187-0.16-0.44-0.227-0.773-0.227h-0.493l-0.92-1.36 1.493-1.827h-3.133v-2.28h6.067v1.88l-1.56 1.92z"></path><path d="M14.347 14.947c0.907 0.12 1.627 0.467 2.173 1.053s0.813 1.333 0.813 2.213c0 0.973-0.32 1.76-0.973 2.373s-1.507 0.92-2.56 0.92c-1.053 0-1.907-0.307-2.56-0.92s-0.973-1.413-0.973-2.373c0-0.733 0.2-1.373 0.587-1.933l2.76-4.307h2.707l-1.973 2.973zM13.8 19.32c0.333 0 0.6-0.093 0.827-0.293s0.333-0.467 0.333-0.813c0-0.36-0.107-0.627-0.32-0.827s-0.493-0.293-0.827-0.293c-0.333 0-0.613 0.093-0.827 0.293s-0.32 0.467-0.32 0.827 0.107 0.627 0.32 0.827 0.48 0.28 0.813 0.28z"></path><path d="M24.587 20.173c-0.68 0.88-1.627 1.333-2.84 1.333s-2.16-0.44-2.853-1.333c-0.68-0.88-1.027-2.067-1.027-3.533 0-1.48 0.333-2.653 1.027-3.547 0.68-0.88 1.627-1.333 2.853-1.333 1.213 0 2.16 0.44 2.84 1.333 0.68 0.88 1.013 2.067 1.013 3.547 0 1.467-0.333 2.653-1.013 3.533zM20.253 16.64c0 1.693 0.493 2.547 1.48 2.547s1.48-0.853 1.48-2.547c0-1.693-0.493-2.547-1.48-2.547-0.987-0.013-1.48 0.84-1.48 2.547z"></path><path d="M28.040 15.16c-0.68 0-1.24-0.227-1.693-0.68s-0.68-1-0.68-1.64c0-0.653 0.227-1.2 0.68-1.653s1.013-0.68 1.693-0.68 1.24 0.227 1.68 0.68c0.453 0.453 0.667 1 0.667 1.653s-0.227 1.2-0.667 1.64c-0.427 0.453-1 0.68-1.68 0.68zM27.6 13.267c0.107 0.107 0.253 0.16 0.44 0.16 0.173 0 0.32-0.053 0.427-0.16s0.16-0.253 0.16-0.44-0.053-0.32-0.16-0.44c-0.107-0.12-0.253-0.173-0.413-0.173-0.173 0-0.32 0.053-0.44 0.173-0.107 0.12-0.16 0.267-0.16 0.44s0.040 0.333 0.147 0.44z"></path></svg>
						</span>
					</a>
				<?php } ?>
				<?php if( $this->has_video($settings, $product) ) { ?>
					<a href="<?php echo esc_url( $this->get_video_url( $product ) ); ?>" class="motta-button motta-button--icon motta-button--raised motta-shape--circle motta-button--video">
						<span class="motta-svg-icon motta-svg-icon--video">
							<svg width="24" height="24" aria-hidden="true" role="img" focusable="false" viewBox="0 0 32 32"><path d="M13.067 12.24l6.267 3.76-6.267 3.76v-7.52zM10.667 8v16l13.333-8-13.333-8z"></path></svg>
						</span>
					</a>
				<?php } ?>
				<?php if( $settings['image_lightbox'] == 'yes' ) { ?>
					<a href="#" class="motta-button motta-button--icon motta-button--raised motta-shape--circle motta-button--product-lightbox">
						<span class="motta-svg-icon motta-svg-icon--full-screen">
							<svg width="24" height="24" aria-hidden="true" role="img" focusable="false" viewBox="0 0 32 32"><path d="M14.667 24h-6.667v-6.667h2.667v4h4z"></path><path d="M10.667 14.667h-2.667v-6.667h6.667v2.667h-4z"></path><path d="M24 14.667h-2.667v-4h-4v-2.667h6.667z"></path><path d="M24 24h-6.667v-2.667h4v-4h2.667z"></path></svg>
						</span>
					</a>
				<?php } ?>
			</div>
			<?php if( $settings['product_go_back'] == 'yes' && $settings['product_share'] == 'yes' ) { ?>
				<div class="product-header-compact">
					<div class="product-header-main">
						<?php if( $settings['product_go_back'] == 'yes') { ?>
							<a href="<?php echo esc_url( get_home_url() ); ?>" class="motta-button  motta-button--text motta-button--history">
								<span class="motta-button__icon"><?php echo \Motta\Addons\Helper::get_svg( 'left' ); ?></span>
							</a>
						<?php } ?>
						<?php if( $settings['product_share'] == 'yes' && class_exists('\Motta\WooCommerce\Single_Product')) { ?>
							<?php \Motta\WooCommerce\Single_Product::share_button('share'); ?>
							<?php \Motta\Theme::set_prop( 'modals-addons', 'product-share' );?>
						<?php } ?>
					</div>
				</div>
			<?php } ?>
			<?php if( $settings['product_wishlist'] == 'yes' && $settings['product_compare'] == 'yes' ) { ?>
				<div class="product-featured-icons">
					<?php
					if( $settings['product_wishlist'] == 'yes' && class_exists('\WCBoost\Wishlist\Frontend')) {
						\WCBoost\Wishlist\Frontend::instance()->single_add_to_wishlist_button();
					}
					if( $settings['product_compare'] == 'yes' && class_exists('\WCBoost\ProductsCompare\Frontend')) {
						\WCBoost\ProductsCompare\Frontend::instance()->single_add_to_compare_button();
					} ?>
				</div>
			<?php } ?>

			<?php do_action('motta_before_single_product_image'); ?>

			<?php

			wc_get_template( 'single-product/product-image.php' );


			if (  \Motta\Addons\Elementor\Builder\Helper::is_elementor_editor_mode() ) {

				?>
				<script>
					jQuery( '.woocommerce-product-gallery' ).each( function() {
						jQuery( this ).wc_product_gallery();
					} );
				</script>
				<?php
			}
			if( $this->has_360_images($settings, $product) ) {
				get_template_part( 'template-parts/modals/360', '', array('elementor') );
			}
			?>
		</div>
		<?php
	}


	public function enqueue_script() {
		if ( \Motta\Addons\Elementor\Builder\Helper::is_preview_mode() ) {
			if ( current_theme_supports( 'wc-product-gallery-zoom' ) ) {
				wp_enqueue_script( 'zoom' );
			}
			if ( current_theme_supports( 'wc-product-gallery-slider' ) ) {
				wp_enqueue_script( 'flexslider' );
			}
			if ( current_theme_supports( 'wc-product-gallery-lightbox' ) ) {
				wp_enqueue_script( 'photoswipe-ui-default' );
				wp_enqueue_style( 'photoswipe-default-skin' );
				add_action( 'wp_footer', 'woocommerce_photoswipe' );
			}
			wp_enqueue_script( 'wc-single-product' );

			wp_enqueue_style( 'photoswipe' );
			wp_enqueue_style( 'photoswipe-default-skin' );
			wp_enqueue_style( 'photoswipe-default-skin' );
			wp_enqueue_style( 'woocommerce_prettyPhoto_css' );
		}
	}

	public function __construct( array $data = [], $args = null ) {
		parent::__construct( $data, $args );

		add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_script' ], 11 );

	}

	private $is_product_video = null;
	private $is_product_360 = null;

	public function get_video_url($product) {
		if( isset( $this->is_product_video ) ) {
			return $this->is_product_video;
		}
		$video_url = get_post_meta( $product->get_id(), 'video_url', true );
		$this->is_product_video = ! empty( $video_url ) ? esc_url( $video_url ) : false;

		return $this->is_product_video;
	}

	public function has_video($settings, $product) {
		if( $settings['product_video'] != 'yes') {
			return false;
		}
		if( \Motta\Addons\Elementor\Builder\Helper::is_elementor_editor_mode()) {
			return true;
		} else {
			if( ! empty( $this->get_video_url($product) ) ) {
				return true;
			}
		}

		return false;
	}


	public function get_360_images($product) {
		if( isset( $this->is_product_360 ) ) {
			return $this->is_product_360;
		}
		$product_images_dg = array();
		$images_dg         = get_post_meta( $product->get_id(), 'product_360_view', false );

		if ( $images_dg ) {
			foreach ( $images_dg as $image ) {
				$image_dg          = wp_get_attachment_image_src( $image, 'full' );
				if( $image_dg ) {
					$product_images_dg[] = $image_dg[0];
				}
			}

		}
		$this->is_product_360 = $product_images_dg;
		return $this->is_product_360;
	}

	public function has_360_images($settings, $product) {
		if( $settings['product_306_degree'] != 'yes') {
			return false;
		}
		if( \Motta\Addons\Elementor\Builder\Helper::is_elementor_editor_mode()) {
			return true;
		} else {
			if( ! empty( $this->get_360_images($product) ) ) {
				return true;
			}
		}

		return false;
	}
}
