<?php
namespace Motta\Addons\Elementor\Builder\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Product_Rating extends Widget_Base {

	use \Motta\Addons\Elementor\Builder\Traits\Product_Id_Trait;

	public function get_name() {
		return 'motta-wc-product-rating';
	}

	public function get_title() {
		return esc_html__( '[Motta] Product Rating', 'motta-addons' );
	}

	public function get_icon() {
		return 'eicon-product-rating';
	}

	public function get_categories() {
		return ['motta-wc-addons'];
	}

	public function get_keywords() {
		return [ 'woocommerce', 'shop', 'store', 'rating', 'review', 'comments', 'stars', 'product' ];
	}

	public function get_style_depends() {
		return [ 'motta-elementor-single-product' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_product_rating_style',
			[
				'label' => esc_html__( 'Style', 'motta-addons' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'star_color',
			[
				'label' => esc_html__( 'Star Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce-product-rating .star-rating .user-rating' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'empty_star_color',
			[
				'label' => esc_html__( 'Empty Star Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce-product-rating .star-rating .max-rating' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'link_color',
			[
				'label' => esc_html__( 'Link Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .woocommerce-product-rating .woocommerce-review-link' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'text_typography',
				'selector' => '{{WRAPPER}} .woocommerce-product-rating .woocommerce-review-link',
			]
		);

		$this->add_control(
			'star_size',
			[
				'label' => esc_html__( 'Star Size', 'motta-addons' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => 'em',
				],
				'range' => [
					'em' => [
						'min' => 0,
						'max' => 4,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .woocommerce-product-rating .star-rating' => 'font-size: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_control(
			'star_width',
			[
				'label' => esc_html__( 'Star Width', 'motta-addons' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => 'px',
				],
				'range' => [
					'em' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .woocommerce-product-rating .star-rating' => 'width: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_control(
			'star_height',
			[
				'label' => esc_html__( 'Star Height', 'motta-addons' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .woocommerce-product-rating .star-rating' => 'height: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_control(
			'heading_review_style',
			[
				'label' => esc_html__( 'Write a Review', 'motta-addons' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'write_a_review',
			[
				'label' => esc_html__( 'Enable', 'motta-addons' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Yes', 'motta-addons' ),
				'label_off' => esc_html__( 'No', 'motta-addons' ),
				'return_value' => 'yes',
				'default' => '',
			]
		);

		$this->add_control(
			'write_a_review_text',
			[
				'label' => __( 'Title', 'motta-addons' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'Write a Review', 'motta' ),
			]
		);

		$this->add_control(
			'write_a_review_spacing',
			[
				'label' => esc_html__( 'Spacing', 'motta-addons' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => 'px',
				],
				'range' => [
					'em' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .motta-products-rating--has-write .woocommerce-product-rating' => 'margin-right: {{SIZE}}{{UNIT}};padding-right: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'write_a_review_typography',
				'selector' => '{{WRAPPER}} .motta-button.motta-products-rating--has-write .woocommerce-review-link',
			]
		);

		$this->add_control(
			'write_a_review_color',
			[
				'label' => esc_html__( 'Border Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .motta-products-rating--has-write .woocommerce-product-rating' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		global $product;
		$product = $this->get_product();

		if ( ! $product ) {
			return;
		}
		if ( function_exists('wc_review_ratings_enabled') && ! wc_review_ratings_enabled() ) {
			return;
		}

		$settings = $this->get_settings_for_display();

		$this->add_render_attribute( 'wrapper', 'class', [
			'motta-products-rating',
			$settings['write_a_review'] == 'yes' ? 'motta-products-rating--has-write' : ''
		] );
		?>
		<div <?php echo $this->get_render_attribute_string( 'wrapper' ); ?>>
			<?php
			if (  \Motta\Addons\Elementor\Builder\Helper::is_elementor_editor_mode() ) {
				$original_post = $GLOBALS['post'];
				$GLOBALS['post'] = get_post( $product->get_id() );
				setup_postdata( $GLOBALS['post'] );
			}

			if( function_exists('woocommerce_template_single_rating') ) {
				woocommerce_template_single_rating();
			}

			if (  \Motta\Addons\Elementor\Builder\Helper::is_elementor_editor_mode() ) {
				$GLOBALS['post'] = $original_post;
			}
			if( $settings['write_a_review'] == 'yes' ) {
				$text = $settings['write_a_review_text'];
				$text = empty( $text ) ? esc_html__('Write a Review', 'motta') : $text;
			?>
			<a href="#reviews" class="motta-button motta-button--subtle  motta-button--color-black woocommerce-review-link">
				<span class="motta-button__text"><?php echo $text ?></span>
			</a>
			<?php
			}
			?>
		</div>
		<?php
	}

	public function render_plain_content() {}

	public function get_group_name() {
		return 'woocommerce';
	}
}
