<?php
namespace Motta\Addons\Elementor\Builder\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Product_Reviews extends Widget_Base {

	use \Motta\Addons\Elementor\Builder\Traits\Product_Id_Trait;

	public function get_name() {
		return 'motta-wc-product-reviews';
	}

	public function get_title() {
		return esc_html__( '[Motta] Product Reviews', 'motta-addons' );
	}

	public function get_icon() {
		return 'eicon-product-rating';
	}

	public function get_keywords() {
		return [ 'woocommerce', 'shop', 'store', 'rating', 'product', 'reviews' ];
	}

	public function get_categories() {
		return [ 'motta-wc-addons' ];
	}

	public function get_style_depends() {
		return [ 'motta-elementor-single-product' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_product_content',
			[
				'label' => esc_html__( 'Content', 'motta-addons' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'layout',
			[
				'label' => esc_html__( 'Layout', 'motta-addons' ),
				'type' => Controls_Manager::CHOOSE,
				'default' => 'horizontal',
				'options' => [
					'horizontal' => [
						'title' => esc_html__( 'Horizontal', 'motta-addons' ),
						'icon' => 'eicon-ellipsis-h',
					],
					'vertical' => [
						'title' => esc_html__( 'Vertical', 'motta-addons' ),
						'icon' => 'eicon-ellipsis-v',
					],
				],
				'toggle' => false,
				'prefix_class' => 'motta-product-reviews-type--',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'section_product_content_style',
			[
				'label' => esc_html__( 'Content', 'motta-addons' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'reviews_spacing',
			[
				'label' => esc_html__( 'Spacing', 'motta-addons' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs--reviews' => 'margin-top: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->add_responsive_control(
			'content_padding',
			[
				'label' => esc_html__( 'Padding', 'motta-addons' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs--reviews' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'content_border',
				'selector' => '.woocommerce {{WRAPPER}} .woocommerce-tabs--reviews',
			]
		);

		$this->add_control(
			'content_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'motta-addons' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs--reviews' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);

		$this->add_control(
			'heading_title',
			[
				'label' => __( 'Title', 'motta-addons' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_control(
			'reviews_title_color',
			[
				'label' => esc_html__( 'Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .woocommerce-tabs--reviews .woocommerce-tabs--reviews-title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'reviews_title_typography',
				'selector' => '.woocommerce {{WRAPPER}} .woocommerce-tabs--reviews .woocommerce-tabs--reviews-title',
			]
		);

		$this->end_controls_section();

	}

	protected function render() {
		global $product;

		$product = $this->get_product();

		if ( ! $product ) {
			return;
		}
		setup_postdata( $product->get_id() );

		if (  \Motta\Addons\Elementor\Builder\Helper::is_elementor_editor_mode() ) {
			$original_post = $GLOBALS['post'];
			$GLOBALS['post'] = get_post( $product->get_id() );
			setup_postdata( $GLOBALS['post'] );
		}

		$product_tabs = apply_filters( 'woocommerce_product_tabs', array() );
		if( empty( $product_tabs ) || ! isset( $product_tabs['reviews'] ) || empty( $product_tabs['reviews'] ) ) {
			return;
		}
		echo '<div id="tab-reviews" class="woocommerce-tabs woocommerce-tabs--reviews">';
			echo sprintf( '<h4 class="woocommerce-tabs--reviews-title">%s</h4>', $product_tabs['reviews']['title'] );
			call_user_func( $product_tabs['reviews']['callback'], 'reviews', $product_tabs['reviews'] );
		echo '</div>';

		if (  \Motta\Addons\Elementor\Builder\Helper::is_elementor_editor_mode() ) {
			$GLOBALS['post'] = $original_post;
		}
	}

	public function render_plain_content() {}

	public function get_group_name() {
		return 'woocommerce';
	}

}
