<?php
namespace Motta\Addons\Elementor\Builder\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Product_Short_Description extends Widget_Base {

	use \Motta\Addons\Elementor\Builder\Traits\Product_Id_Trait;

	public function get_name() {
		return 'motta-wc-product-short-description';
	}

	public function get_title() {
		return esc_html__( '[Motta] Product Short Description', 'motta-addons' );
	}

	public function get_icon() {
		return 'eicon-product-description';
	}

	public function get_categories() {
		return ['motta-wc-addons'];
	}

	public function get_keywords() {
		return [ 'woocommerce', 'shop', 'store', 'short description', 'description', 'product' ];
	}

	public function get_script_depends() {
		return [
			'motta-elementor-single-product'
		];
	}

	public function get_style_depends() {
		return [ 'motta-elementor-single-product' ];
	}

	/**
	 * Register heading widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 3.1.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'section_desc',
			[
				'label' => esc_html__( 'Product Description', 'motta-addons' ),
			]
		);


		$this->add_control(
			'title',
			[
				'label' => __( 'Title', 'motta-addons' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'Features', 'motta' ),
				'default' => __( 'Features', 'motta' ),
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label' => esc_html__( 'Alignment', 'motta-addons' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'motta-addons' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'motta-addons' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'motta-addons' ),
						'icon' => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__( 'Justified', 'motta-addons' ),
						'icon' => 'eicon-text-align-justify',
					],
				],
				'default' => '',
				'selectors' => [
					'{{WRAPPER}}' => 'text-align: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'description_lines',
			[
				'label'              => esc_html__( 'Product Description Lines', 'motta-addons' ),
				'description' => esc_html__('This option does not work with the motta_more shortcode', 'motta-addons'),
				'type'               => Controls_Manager::NUMBER,
				'min'                => 1,
				'max'                => 50,
				'default'            => 6,
				'selectors' => [
					'.woocommerce {{WRAPPER}} .short-description' => '--mt-product-description-lines: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_description_style',
			[
				'label' => esc_html__( 'Product Description', 'motta-addons' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'description_color',
			[
				'label' => esc_html__( 'Text Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .product_title' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'typography',
				'selector' => '{{WRAPPER}} .product_title',
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render heading widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		global $product;

		$product = $this->get_product();

		if ( ! $product ) {
			return;
		}

		$content = $product->get_short_description();
		if( empty( $content ) ) {
			return;
		}
		$title = $settings['title'];
		$title = $title ? sprintf('<label class="short-description__label">%s</label>', $title ) : '';
		echo '<div class="short-description">';
		echo $title;
		if( has_shortcode( $content, 'motta_more' ) ) {
				echo wp_kses_post( do_shortcode( $content ) );
		} else {
			$option = array(
				'more'   => esc_html__( 'Show More', 'motta' ),
				'less'   => esc_html__( 'Show Less', 'motta' )
			);

			echo sprintf('<div class="short-description__content">%s</div>',  wp_kses_post( $content ));
			echo sprintf('
				<button class="short-description__more motta-button--subtle motta-button--color-black" data-settings="%s">%s</button>',
				htmlspecialchars(json_encode( $option )),
				esc_html__('Show More', 'motta')
			);
		}
		echo '</div>';
	}
}
