<?php
namespace Motta\Addons\Elementor\Builder\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Product_Vendor_Info extends Widget_Base {

	use \Motta\Addons\Elementor\Builder\Traits\Product_Id_Trait;

	public function get_name() {
		return 'motta-wc-product-vendor-info';
	}

	public function get_title() {
		return esc_html__( '[Motta] Product Vendor Info', 'motta-addons' );
	}

	public function get_icon() {
		return 'eicon-info';
	}

	public function get_categories() {
		return ['motta-wc-addons'];
	}

	public function get_keywords() {
		return [ 'woocommerce', 'shop', 'store', 'vendor', 'info', 'product' ];
	}

	public function get_style_depends() {
		return [ 'motta-elementor-single-product' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_vendor_info_style',
			[
				'label' => esc_html__( 'Style', 'motta-addons' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'vendor_info_padding',
			[
				'label' => esc_html__( 'Padding', 'motta-addons' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .dokan-vendor-info-wrap, {{WRAPPER}} .motta-sold-by-template, {{WRAPPER}} .motta-vendor-info' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'vendor_info_spacing',
			[
				'label' => esc_html__( 'Spacing', 'motta-addons' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => 'px',
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .motta-sold-by-template, {{WRAPPER}} .dokan-vendor-info-wrap, {{WRAPPER}} .motta-vendor-info' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'vendor_info_box_shadow',
				'label' => __( 'Box Shadow', 'motta-addons' ),
				'selector' => '{{WRAPPER}} .dokan-vendor-info-wrap, {{WRAPPER}} .motta-sold-by-template, {{WRAPPER}} .motta-vendor-info',
			]
		);

		$this->add_control(
			'vendor_image_style',
			[
				'label' => esc_html__( 'Vendor Image', 'motta-addons' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'vendor_image_width',
			[
				'label' => esc_html__( 'Width', 'motta-addons' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => 'px',
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .dokan-vendor-info-wrap .dokan-vendor-image, {{WRAPPER}} .wcfmmp_sold_by_container_left img, {{WRAPPER}} .motta-vendor-info .motta-vendor-info__image' => 'width: {{SIZE}}{{UNIT}}; height: auto',
				],
			]
		);

		$this->add_control(
			'vendor_image_spacing',
			[
				'label' => esc_html__( 'Spacing', 'motta-addons' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => 'px',
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .dokan-vendor-info-wrap .dokan-vendor-image, {{WRAPPER}} .wcfmmp_sold_by_container_left, {{WRAPPER}} .motta-vendor-info .motta-vendor-info__image' => 'margin-right: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'vendor_image_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'motta-addons' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .dokan-vendor-info-wrap .dokan-vendor-image img, {{WRAPPER}} .wcfmmp_sold_by_container_left img, {{WRAPPER}} .motta-vendor-info .motta-vendor-info__image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'vendor_label_style',
			[
				'label' => esc_html__( 'Vendor Label', 'motta-addons' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'vendor_label_color',
			[
				'label' => esc_html__( 'Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .dokan-vendor-info-wrap .dokan-vendor-name .vendor-text, {{WRAPPER}} .wcfmmp_sold_by_container_advanced .wcfmmp_sold_by_label, {{WRAPPER}} .motta-vendor-info .motta-vendor-info__content .vendor-text' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'vendor_label_typography',
				'selector' => '{{WRAPPER}} .dokan-vendor-info-wrap .dokan-vendor-name .vendor-text, {{WRAPPER}} .wcfmmp_sold_by_container_advanced .wcfmmp_sold_by_label, {{WRAPPER}} .motta-vendor-info .motta-vendor-info__content .vendor-text',
			]
		);

		$this->add_control(
			'vendor_label_spacing',
			[
				'label' => esc_html__( 'Spacing', 'motta-addons' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => 'px',
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .dokan-vendor-info-wrap .dokan-vendor-name .vendor-text, {{WRAPPER}} .wcfmmp_sold_by_container_advanced .wcfmmp_sold_by_label, {{WRAPPER}} .motta-vendor-info .motta-vendor-info__content .vendor-text' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'vendor_name_style',
			[
				'label' => esc_html__( 'Vendor Name', 'motta-addons' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);


		$this->add_control(
			'vendor_name_color',
			[
				'label' => esc_html__( 'Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .dokan-vendor-info-wrap .dokan-vendor-name h5, {{WRAPPER}} .wcfmmp_sold_by_container_advanced .wcfmmp_sold_by_store, {{WRAPPER}} .motta-vendor-info .motta-vendor-info__content .vendor-name' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'vendor_name_typography',
				'selector' => '{{WRAPPER}} .dokan-vendor-info-wrap .dokan-vendor-name h5, {{WRAPPER}} .wcfmmp_sold_by_container_advanced .wcfmmp_sold_by_store, {{WRAPPER}} .motta-vendor-info .motta-vendor-info__content .vendor-name',
			]
		);

		if( class_exists( 'WeDevs_Dokan' ) || class_exists( 'Marketkingcore' ) ) {
			$this->add_control(
				'vendor_star_style',
				[
					'label' => esc_html__( 'Vendor Star', 'motta-addons' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
				]
			);
			$this->add_control(
				'star_color',
				[
					'label' => esc_html__( 'Star Color', 'motta-addons' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .dokan-vendor-info-wrap .dokan-vendor-rating .star-rating .user-rating, {{WRAPPER}} .motta-vendor-info .star-rating .user-rating' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'empty_star_color',
				[
					'label' => esc_html__( 'Empty Star Color', 'motta-addons' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .dokan-vendor-info-wrap .dokan-vendor-rating .star-rating .max-rating, {{WRAPPER}} .motta-vendor-info .star-rating .max-rating' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'vendor_count_color',
				[
					'label' => esc_html__( 'Count Color', 'motta-addons' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .dokan-vendor-info-wrap .dokan-vendor-rating .dokan-ratings-count, {{WRAPPER}} .motta-vendor-info .ratings-count' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'vendor_count_typography',
					'selector' => '{{WRAPPER}} .dokan-vendor-info-wrap .dokan-vendor-rating .dokan-ratings-count, {{WRAPPER}} .motta-vendor-info .ratings-count',
				]
			);

			$this->add_control(
				'star_size',
				[
					'label' => esc_html__( 'Star Size', 'motta-addons' ),
					'type' => Controls_Manager::SLIDER,
					'default' => [
						'unit' => 'em',
					],
					'range' => [
						'em' => [
							'min' => 0,
							'max' => 4,
							'step' => 0.1,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .dokan-vendor-info-wrap .dokan-vendor-rating .star-rating, {{WRAPPER}} .motta-vendor-info .star-rating' => 'font-size: {{SIZE}}{{UNIT}}',
					],
				]
			);

			$this->add_control(
				'star_width',
				[
					'label' => esc_html__( 'Star Width', 'motta-addons' ),
					'type' => Controls_Manager::SLIDER,
					'default' => [
						'unit' => 'px',
					],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 500,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .dokan-vendor-info-wrap .dokan-vendor-rating .star-rating, {{WRAPPER}} .motta-vendor-info .star-rating' => 'width: {{SIZE}}{{UNIT}}',
					],
				]
			);

			$this->add_control(
				'star_height',
				[
					'label' => esc_html__( 'Star Height', 'motta-addons' ),
					'type' => Controls_Manager::SLIDER,
					'default' => [
						'unit' => 'px',
					],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 500,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .dokan-vendor-info-wrap .dokan-vendor-rating .star-rating, {{WRAPPER}} .motta-vendor-info .star-rating' => 'height: {{SIZE}}{{UNIT}}',
					],
				]
			);
		}

		$this->end_controls_section();
	}

	protected function render() {
		global $product;
		$product = $this->get_product();

		if ( ! $product ) {
			return;
		}

		if( class_exists( 'WeDevs_Dokan' ) ) {
			$this->dokan_vendor_info($product);
		}

		if( class_exists( 'WCFMmp' ) ) {
			$this->wcfm_vendor_info($product);
		}

		if( class_exists( 'Marketkingcore' ) ) {
			$this->marketking_vendor_info($product);
		}
	}

	public function dokan_vendor_info($product) {
		$vendor       = dokan_get_vendor_by_product( $product );
        $store_info   = $vendor->get_shop_info();
        $store_rating = $vendor->get_rating();
		?>
		<div class="dokan-vendor-info-wrap">
			<div class="dokan-vendor-image">
				<img src="<?php echo esc_url( $vendor->get_avatar() ); ?>" alt="<?php echo esc_attr( $store_info['store_name'] ); ?>">
			</div>
			<div class="dokan-vendor-info">
				<div class="dokan-vendor-name">
					<span class="vendor-text"><?php esc_html_e('Store', 'motta'); ?></span>
					<a href="<?php echo esc_attr( $vendor->get_shop_url() ); ?>"><h5><?php echo esc_html( $store_info['store_name'] ); ?></h5></a>
				</div>
				<div class="dokan-vendor-rating">
					<?php $this->generate_ratings_vendor( $store_rating ); ?>
				</div>
			</div>
		</div>
		<?php
	}

	public function wcfm_vendor_info($product) {
		global $WCFM, $WCFMmp;

		$product_id = $product->get_id();

		$vendor_id = wcfm_get_vendor_id_by_post( $product_id );

		if( ! $vendor_id ) {
			return;
		}

		echo '<div class="motta-sold-by-template">';

		$WCFMmp->template->get_template( 'sold-by/wcfmmp-view-sold-by-advanced.php', array( 'product_id' => $product_id, 'vendor_id' => $vendor_id ) );

		if( $WCFM->wcfm_enquiry ) {
			$WCFM->wcfm_enquiry->wcfm_enquiry_button();
		}

		echo '</div>';
	}

	public function marketking_vendor_info($product) {
		global $post;
		$vendor_id = marketking()->get_product_vendor($post->ID);
		if ( empty( $vendor_id ) ) {
			return;
		}
		$store_name = marketking()->get_store_name_display($vendor_id);
		$store_img = marketking()->get_display_icon_image($vendor_id );
		?>
		<div class="motta-vendor-info">
			<a href="<?php echo esc_url( marketking()->get_store_link($vendor_id) ); ?>" class="motta-vendor-info__link">
				<?php if( $store_img ){ ?>
					<div class="motta-vendor-info__image">
						<img src="<?php echo esc_url($store_img)?>" alt="<?php echo esc_attr($store_name)?>" width="150" height="150">
					</div>
				<?php } ?>

				<div class="motta-vendor-info__content">
					<span class="vendor-text"><?php esc_html_e('Store', 'motta'); ?></span>
					<h5 class="vendor-name"><?php echo esc_html( $store_name ); ?></h5>
				</div>
			</a>
			<div class="motta-vendor-info__rating">
				<?php
					$rating = marketking()->get_vendor_rating($vendor_id);
					self::generate_ratings_vendor($rating);
				?>
			</div>
		</div>

		<?php
	}

	public function render_plain_content() {}

	public function get_group_name() {
		return 'woocommerce';
	}

	public function generate_ratings_vendor( $store_rating ) {
		$store_rating['rating'] = $store_rating['count'] == 0 ? 0 : $store_rating['rating'];
		$html = '<span class="max-rating rating-stars">'
		        . \Motta\Icon::get_svg( 'star' )
		        . \Motta\Icon::get_svg( 'star' )
		        . \Motta\Icon::get_svg( 'star' )
		        . \Motta\Icon::get_svg( 'star' )
		        . \Motta\Icon::get_svg( 'star' )
		        . '</span>';
		$html .= '<span class="user-rating rating-stars" style="width:' . ( ( $store_rating['rating'] / 5 ) * 100 ) . '%">'
				. \Motta\Icon::get_svg( 'star' )
				. \Motta\Icon::get_svg( 'star' )
				. \Motta\Icon::get_svg( 'star' )
				. \Motta\Icon::get_svg( 'star' )
				. \Motta\Icon::get_svg( 'star' )
		         . '</span>';

		$count 	= $store_rating['count'];
		$rating = $store_rating['rating'];
		$review_html = sprintf(_n('%1$s (%2$s Review)', '%1$s (%2$s Reviews)', $count, 'motta'), $rating, $count);
		echo '<div class="star-rating">' . $html . '</div>';
		echo '<p class="ratings-count dokan-ratings-count">' . $review_html  . '</p>';
	}
}
