<?php
namespace Motta\Addons\Elementor\Builder\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Products_Filter_Actived extends Widget_Base {
	public function get_name() {
		return 'motta-products-filter-actived';
	}

	public function get_title() {
		return esc_html__( '[Motta] Products Filter Actived', 'motta-addons' );
	}

	public function get_icon() {
		return 'eicon-form-vertical';
	}

	public function get_categories() {
		return ['motta-wc-addons'];
	}

	public function get_keywords() {
		return [ 'woocommerce', 'product', 'archive', 'filter', 'actived' ];
	}

	public function get_script_depends() {
		return [ 'motta-product-archive' ];
	}


	protected function register_controls() {
		$this->start_controls_section(
            'filter_actived_content',
            [
                'label' => __( 'Product Filter Actived', 'motta-addons' ),
				'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control(
			'color',
			[
				'label' => esc_html__( 'Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .motta-toolbar-view a' => 'color: {{VALUE}}',
				],
			]
		);


		$this->add_control(
			'active_color',
			[
				'label' => esc_html__( 'Active Color', 'motta-addons' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .motta-toolbar-view a.current, {{WRAPPER}} .motta-toolbar-view a:hover, {{WRAPPER}}  .motta-toolbar-view a.current::after' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'icon_size',
			[
				'label'     => esc_html__( 'Icon Size', 'motta-addons' ),
				'type'      => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .motta-toolbar-view a' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'spacing',
			[
				'label'     => esc_html__( 'Spacing', 'motta-addons' ),
				'type'      => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em' ],
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .motta-toolbar-view a' => 'margin-left: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();
	}

	protected function render() {
		echo '<div class="motta-products-filter-actived catalog-toolbar__filters-actived">';
		if( \Motta\Addons\Elementor\Builder\Helper::is_elementor_editor_mode()) {
			echo '<a href="#" class="remove-filtered" data-name="product_cat" data-value="homegarden" rel="nofollow" aria-label="Remove filter">' . esc_html__('Current Filter', 'motta-addons') . '<span class="motta-svg-icon motta-svg-icon--close"><svg width="24" height="24" aria-hidden="true" role="img" focusable="false" viewBox="0 0 32 32"><path d="M28.336 5.936l-2.272-2.272-10.064 10.080-10.064-10.080-2.272 2.272 10.080 10.064-10.080 10.064 2.272 2.272 10.064-10.080 10.064 10.080 2.272-2.272-10.080-10.064z"></path></svg></span></a>';
			echo '<a href="#" class="remove-filtered-all motta-button motta-button--subtle">' . esc_html__('Clear All', 'motta-addons') . '</a>';
		}
		echo '</div>';
	}

	public function render_plain_content() {}

	public function get_group_name() {
		return 'woocommerce';
	}

}
