<?php
/**
 * Custom icons for this theme.
 *
 * @package WordPress
 * @subpackage Twenty_Twenty
 * @since Twenty Twenty 1.0
 */

namespace Motta;

/**
 * SVG ICONS CLASS
 * Retrieve the SVG code for the specified icon. Based on a solution in Twenty Nineteen.
 */
class Icon {

	/**
	 * Store the code for all SVGs in an array.
	 *
	 * @since 1.0.0
	 *
	 * @return string
	 */
	public static $ui_icons = array(
		'arrow-left-long'  => '<svg viewBox="0 0 19 32"><path d="M13.552 0.72l2.656 1.76-9.008 13.52 9.008 13.52-2.656 1.76-10.192-15.28z"></path></svg>',
		'arrow-right-long' => '<svg viewBox="0 0 19 32"><path d="M5.648 31.28l-2.656-1.76 9.008-13.52-9.008-13.52 2.656-1.76 10.192 15.28z"></path></svg>',
		'left'             => '<svg viewBox="0 0 32 32"><path d="M20.58 2.58l2.84 2.84-10.6 10.58 10.6 10.58-2.84 2.84-13.4-13.42z"></path></svg>',
		'right'            => '<svg viewBox="0 0 32 32"><path d="M11.42 29.42l-2.84-2.84 10.6-10.58-10.6-10.58 2.84-2.84 13.4 13.42z"></path></svg>',
		'left-mini'        => '<svg width="10" height="10" viewBox="0 0 10 10" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M0.590027 4.99999L5.29003 0.289993L6.71003 1.70999L3.41003 4.99999L6.71003 8.28999L5.29003 9.70999L0.590027 4.99999Z" fill="currentColor"/></svg>',
		'right-mini'       => '<svg width="10" height="10" viewBox="0 0 10 10" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M9.40998 5.00001L4.70998 9.71001L3.28998 8.29001L6.58998 5.00001L3.28998 1.71001L4.70998 0.290009L9.40998 5.00001Z" fill="currentColor"/></svg>',
		'comment-mini'     => '<svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M11.8 3.2V9.8H4H3.64L3.33 10L2.2 10.76V10.63V3.2H11.8ZM13 2H1V10.62V13L4 11H13V2Z" fill="currentColor"/></svg>',
		'share-mini'       => '<svg width="11" height="15" viewBox="0 0 11 15" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M7.50002 5.89999V7.09999H8.90002V12.9H2.10002V7.09999H3.50002V5.89999H0.900024V14.1H10.1V5.89999H7.50002Z" fill="currentColor"/><path d="M4.90002 2.94999V9.99999H6.10002V2.94999L8.08002 4.91999L8.92002 4.07999L5.50002 0.649994L2.08002 4.07999L2.92002 4.91999L4.90002 2.94999Z" fill="currentColor"/></svg>',
		'share'       => '<svg viewBox="0 0 32 32"> <path d="M20.8 12.8v3.2h3.2v9.6h-16v-9.6h3.2v-3.2h-6.4v16h22.4v-16z"></path> <path d="M14.4 7.84v12.96h3.2v-12.96l3.68 3.68 2.24-2.24-7.52-7.52-7.52 7.52 2.24 2.24z"></path> </svg>',
		'video'            => '<svg viewBox="0 0 32 32"><path d="M13.067 12.24l6.267 3.76-6.267 3.76v-7.52zM10.667 8v16l13.333-8-13.333-8z"></path></svg>',
		'gallery'          => '<svg viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path d="M15 13H1V3h14v10zM3 11h10V5H3v6z"/><path d="M19 17H6v-2h11V8h2z"/><path fill="none" d="M0 0h20v20H0z"/></svg>',
		'search'           => '<svg viewBox="0 0 32 32"><path d="M28.8 26.544l-5.44-5.44c1.392-1.872 2.24-4.192 2.24-6.704 0-6.176-5.024-11.2-11.2-11.2s-11.2 5.024-11.2 11.2 5.024 11.2 11.2 11.2c2.512 0 4.832-0.848 6.688-2.24l5.44 5.44 2.272-2.256zM6.4 14.4c0-4.416 3.584-8 8-8s8 3.584 8 8-3.584 8-8 8-8-3.584-8-8z"></path></svg>',
		'categories'       => '<svg viewBox="0 0 32 32"><path d="M7.2 4.8c-1.328 0-2.4 1.072-2.4 2.4s1.072 2.4 2.4 2.4 2.4-1.072 2.4-2.4-1.072-2.4-2.4-2.4v0z"></path><path d="M26.4 4.8c-1.328 0-2.4 1.072-2.4 2.4s1.072 2.4 2.4 2.4 2.4-1.072 2.4-2.4-1.072-2.4-2.4-2.4v0z"></path><path d="M16.8 4.8c-1.328 0-2.4 1.072-2.4 2.4s1.072 2.4 2.4 2.4 2.4-1.072 2.4-2.4-1.072-2.4-2.4-2.4v0z"></path><path d="M7.2 24c-1.328 0-2.4 1.072-2.4 2.4s1.072 2.4 2.4 2.4 2.4-1.072 2.4-2.4-1.072-2.4-2.4-2.4v0z"></path><path d="M26.4 24c-1.328 0-2.4 1.072-2.4 2.4s1.072 2.4 2.4 2.4 2.4-1.072 2.4-2.4-1.072-2.4-2.4-2.4v0z"></path><path d="M16.8 24c-1.328 0-2.4 1.072-2.4 2.4s1.072 2.4 2.4 2.4 2.4-1.072 2.4-2.4-1.072-2.4-2.4-2.4v0z"></path><path d="M7.2 14.4c-1.328 0-2.4 1.072-2.4 2.4s1.072 2.4 2.4 2.4 2.4-1.072 2.4-2.4-1.072-2.4-2.4-2.4v0z"></path><path d="M26.4 14.4c-1.328 0-2.4 1.072-2.4 2.4s1.072 2.4 2.4 2.4 2.4-1.072 2.4-2.4-1.072-2.4-2.4-2.4v0z"></path><path d="M16.8 14.4c-1.328 0-2.4 1.072-2.4 2.4s1.072 2.4 2.4 2.4 2.4-1.072 2.4-2.4-1.072-2.4-2.4-2.4v0z"></path></svg>',
		'categories-v2'    => '<svg viewBox="0 0 32 32"><path d="M8.8 6.4c1.328 0 2.4 1.072 2.4 2.4s-1.072 2.4-2.4 2.4-2.4-1.072-2.4-2.4 1.072-2.4 2.4-2.4zM8.8 3.2c-3.088 0-5.6 2.512-5.6 5.6s2.512 5.6 5.6 5.6 5.6-2.512 5.6-5.6-2.512-5.6-5.6-5.6v0z"></path><path d="M23.2 6.4c1.328 0 2.4 1.072 2.4 2.4s-1.072 2.4-2.4 2.4-2.4-1.072-2.4-2.4 1.072-2.4 2.4-2.4zM23.2 3.2c-3.088 0-5.6 2.512-5.6 5.6s2.512 5.6 5.6 5.6 5.6-2.512 5.6-5.6-2.512-5.6-5.6-5.6v0z"></path><path d="M8.8 20.8c1.328 0 2.4 1.072 2.4 2.4s-1.072 2.4-2.4 2.4-2.4-1.072-2.4-2.4 1.072-2.4 2.4-2.4zM8.8 17.6c-3.088 0-5.6 2.512-5.6 5.6s2.512 5.6 5.6 5.6 5.6-2.512 5.6-5.6-2.512-5.6-5.6-5.6v0z"></path><path d="M23.2 20.8c1.328 0 2.4 1.072 2.4 2.4s-1.072 2.4-2.4 2.4-2.4-1.072-2.4-2.4 1.072-2.4 2.4-2.4zM23.2 17.6c-3.088 0-5.6 2.512-5.6 5.6s2.512 5.6 5.6 5.6 5.6-2.512 5.6-5.6-2.512-5.6-5.6-5.6v0z"></path></svg>',
		'select-arrow'     => '<svg viewBox="0 0 32 32"><path d="M16 30.112l-15.072-15.040 4.544-4.544 10.528 10.56 10.528-10.56 4.544 4.544z"></path></svg>',
		'close'            => '<svg viewBox="0 0 32 32"><path d="M28.336 5.936l-2.272-2.272-10.064 10.080-10.064-10.080-2.272 2.272 10.080 10.064-10.080 10.064 2.272 2.272 10.064-10.080 10.064 10.080 2.272-2.272-10.080-10.064z"></path></svg>',
		'account'          => '<svg viewBox="0 0 32 32"><path d="M16 16c-4.064 0-6.4-2.336-6.4-6.4 0-3.536 2.864-6.4 6.4-6.4s6.4 2.864 6.4 6.4c0 4-2.4 6.4-6.4 6.4zM16 6.4c-1.76 0-3.2 1.44-3.2 3.2 0 2.272 0.928 3.2 3.2 3.2 2.24 0 3.2-0.96 3.2-3.2 0-1.76-1.44-3.2-3.2-3.2z"></path><path d="M27.2 28.8h-22.4v-3.2c0-4.416 3.584-8 8-8h6.4c4.416 0 8 3.584 8 8v3.2zM8 25.6h16c0-2.64-2.16-4.8-4.8-4.8h-6.4c-2.64 0-4.8 2.16-4.8 4.8z"></path></svg>',
		'create-account'   => '<svg viewBox="0 0 32 32"><path d="M16 16c4 0 6.4-2.4 6.4-6.4 0-3.536-2.864-6.4-6.4-6.4s-6.4 2.864-6.4 6.4c0 4.064 2.336 6.4 6.4 6.4zM16 6.4c1.76 0 3.2 1.44 3.2 3.2 0 2.24-0.96 3.2-3.2 3.2-2.272 0-3.2-0.928-3.2-3.2 0-1.76 1.44-3.2 3.2-3.2z"></path><path d="M12.8 20.8h6.4v-3.2h-6.4c-4.416 0-8 3.584-8 8v3.2h11.2v-3.2h-8c0-2.64 2.16-4.8 4.8-4.8z"></path><path d="M28.8 22.4h-3.2v-3.2h-3.2v3.2h-3.2v3.2h3.2v3.2h3.2v-3.2h3.2z"></path></svg>',
		'sign-in'          => '<svg viewBox="0 0 32 32"><path d="M9.6 3.2v6.4h3.2v-3.2h12.8v19.2h-12.8v-3.2h-3.2v6.4h19.2v-25.6z"></path><path d="M16 21.6l6.4-5.6-6.4-5.6v4h-12.8v3.2h12.8z"></path></svg>',
		'sign-out'         => '<svg viewBox="0 0 32 32"><path d="M16 25.6h-9.6v-19.2h9.6v3.2h3.2v-6.4h-16v25.6h16v-6.4h-3.2z"></path><path d="M28.8 16l-6.4-5.6v4h-11.2v3.2h11.2v4z"></path></svg>',
		'wishlist'         => '<svg viewBox="0 0 32 32"><path d="M22.736 6.4v0c1.792 0 3.44 1.12 4.128 2.768 0.8 1.92 0.112 4.144-1.856 6.112l-9.024 8.992-9.024-8.976c-1.984-1.984-2.64-4.144-1.824-6.080 0.688-1.68 2.352-2.8 4.144-2.8 1.504 0 3.040 0.752 4.448 2.16l2.256 2.256 2.256-2.256c1.44-1.424 2.992-2.176 4.496-2.176zM22.736 3.2c-2.176 0-4.544 0.912-6.752 3.104-2.192-2.176-4.544-3.088-6.704-3.088-6.368 0-11.040 7.904-4.576 14.336l11.28 11.248 11.28-11.248c6.496-6.448 1.856-14.352-4.528-14.352v0z"></path></svg>',
		'wishlist-filled'  => '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32"><path d="M22.736 3.2c-2.176 0-4.544 0.912-6.752 3.104-2.192-2.176-4.544-3.088-6.704-3.088-6.368 0-11.040 7.904-4.576 14.336l11.28 11.248 11.28-11.248c6.496-6.448 1.856-14.352-4.528-14.352v0z"></path></svg>',
		'compare'          => '<svg viewBox="0 0 32 32"><path d="M13.136 14.864l-3.68-3.664h16.144v-3.2h-16.144l3.68-3.664-2.272-2.272-7.52 7.536 7.52 7.536z"></path><path d="M21.136 14.864l-2.272 2.272 3.68 3.664h-16.144v3.2h16.144l-3.68 3.664 2.272 2.272 7.52-7.536z"></path></svg>',
		'track-order'      => '<svg viewBox="0 0 32 32"><path d="M24.528 3.2h-17.056l-4.272 8.96v16.64h25.6v-16.64l-4.272-8.96zM24.8 11.2h-7.2v-4.8h4.912l2.288 4.8zM9.488 6.4h4.912v4.8h-7.2l2.288-4.8zM6.4 25.6v-11.2h8v3.2h3.2v-3.2h8v11.2h-19.2z"></path></svg>',
		'help-center'      => '<svg viewBox="0 0 32 32"><path d="M16 6.4c5.296 0 9.6 4.304 9.6 9.6s-4.304 9.6-9.6 9.6-9.6-4.304-9.6-9.6 4.304-9.6 9.6-9.6zM16 3.2c-7.072 0-12.8 5.728-12.8 12.8s5.728 12.8 12.8 12.8 12.8-5.728 12.8-12.8-5.728-12.8-12.8-12.8v0z"></path><path d="M14.8 18.16c-0.048-0.224-0.064-0.448-0.064-0.704 0-0.752 0.304-1.568 1.216-2.256l0.816-0.608c0.432-0.32 0.576-0.704 0.576-1.12 0-0.624-0.464-1.232-1.424-1.232-0.928 0-1.472 0.752-1.472 1.504 0 0.368 0.032 0.528 0.048 0.592l-2.24-0.080c-0.048-0.224-0.064-0.464-0.064-0.672 0-1.872 1.392-3.456 3.728-3.456 2.592 0 3.888 1.552 3.888 3.152 0 1.28-0.592 2.16-1.552 2.88l-0.608 0.448c-0.56 0.416-0.944 0.832-0.944 1.552h-1.904zM15.808 19.104c0.768 0 1.392 0.624 1.392 1.392 0 0.752-0.624 1.376-1.392 1.376s-1.376-0.624-1.376-1.376c0-0.768 0.608-1.392 1.376-1.392z"></path></svg>',
		'hamburger'        => '<svg viewBox="0 0 27 32"><path d="M0 6.667h26.667v2.667h-26.667v-2.667z"></path><path d="M0 14.667h26.667v2.667h-26.667v-2.667z"></path><path d="M0 22.667h26.667v2.667h-26.667v-2.667z"></path></svg>',
		'error'            => '<svg viewBox="0 0 32 32"><path d="M6.751 21.844c0.008-0.289 0.013-0.705 0.014-0.936 0.005-0.83 0.082-1.569-1.080-2.031-0.386-0.154-0.785-0.381-0.968-0.755-0.183-0.372-0.043-0.819 0.135-1.194 0.334-0.707 0.789-1.352 1.111-2.064 0.322-0.713 0.861-1.284 0.616-2.026-0.452-1.37-2.699-2.45-3.184-3.809-0.107-0.3-0.169-0.367 0.013-0.63 0.106-0.152 0.478-0.341 0.638-0.436 2.311-1.383 4.622-2.764 6.934-4.146 0.236-0.141 0.756-0.415 1.030-0.454 0.665-0.094 0.957 0.575 1.41 1.071 0.675 0.739 1.35 1.479 2.025 2.217 0.199 0.218 0.425 0.664 0.715 0.612 0.189-0.032 0.359-0.391 0.488-0.532 0.863-0.939 1.725-1.877 2.587-2.815 0.215-0.235 0.469-0.486 0.788-0.493 0.226-0.004 0.433 0.12 0.625 0.24 2.616 1.63 5.234 3.26 7.85 4.89 0.096 0.060 0.2 0.129 0.236 0.238 0.043 0.127-0.024 0.264-0.094 0.379-0.88 1.445-2.979 2.291-3.108 3.977 0.247 1.424 1.346 2.723 1.89 4.043 0.126 0.306 0.218 0.663 0.073 0.961-0.165 0.34-0.567 0.475-0.896 0.66-0.777 0.438-1.21 0.756-1.169 2.223 0.023 0.788 0.124 1.692 0.078 2.328-0.036 0.5-0.675 0.727-1.111 0.973-2.32 1.304-4.641 2.606-6.961 3.91-0.43 0.241-0.889 0.49-1.381 0.466-0.41-0.020-0.784-0.226-1.141-0.427-1.389-0.782-2.777-1.565-4.166-2.348-0.694-0.391-1.389-0.782-2.082-1.174-0.516-0.291-1.389-0.595-1.755-1.081-0.195-0.26-0.219-0.514-0.223-0.836-0.006-0.372 0.056-0.63 0.065-1zM24.716 13.014c-0.038-0.1-0.124-0.12-0.191-0.161-2.754-1.625-5.51-3.246-8.26-4.878-0.163-0.096-0.266-0.074-0.414 0.010-2.784 1.593-5.571 3.18-8.356 4.77-0.056 0.033-0.144 0.044-0.149 0.14 0.025 0.016 0.051 0.034 0.079 0.049 2.789 1.563 5.577 3.124 8.363 4.691 0.152 0.086 0.258 0.058 0.394-0.015 1.878-1.006 3.759-2.006 5.637-3.011 0.97-0.52 1.955-1.019 2.898-1.595zM15.744 19.212c-0.001-0.073-0.095-0.098-0.135-0.038-0.054 0.082-0.099 0.176-0.114 0.205-0.643 1.215-1.17 2.241-1.825 3.45-0.1 0.184-0.092 0.45-0.322 0.543-0.276 0.111-0.394-0.179-0.578-0.284-1.239-0.709-2.465-1.441-3.695-2.165-0.629-0.37-1.259-0.739-1.936-1.135 0 0.156 0.001 0.256 0 0.356-0.013 0.986-0.014 1.973-0.046 2.957-0.008 0.21 0.043 0.311 0.22 0.409 2.386 1.326 4.769 2.66 7.152 3.991 0.492 0.275 0.988 0.546 1.502 0.832-0.075-3.063-0.149-6.082-0.224-9.123zM16.331 19.224c-0.079 0.021-0.15-0.041-0.148 0.041 0.090 2.125 0.146 5.984 0.22 9.005 0.098-0.047 0.161-0.075 0.223-0.11 1.551-0.87 3.101-1.744 4.654-2.611 1.219-0.68 2.394-1.44 3.68-1.994 0.163-0.070 0.139-0.176 0.137-0.295-0.006-1.059-0.024-2.117-0.016-3.176 0.003-0.302-0.075-0.269-0.281-0.144-1.416 0.858-2.839 1.705-4.259 2.555-0.524 0.314-1.045 0.631-1.571 0.941-0.281 0.165-0.31-0.058-0.413-0.242-0.055-0.1-0.328-0.594-0.376-0.681-0.343-0.614-0.431-0.79-0.777-1.402-0.356-0.629-0.715-1.258-1.073-1.886z"/><path d="M27.023 23.058c0.020 0.391 0.034 0.784-0.049 1.174-0.144 0.677-0.519 1.157-1.137 1.456-0.345 0.168-0.716 0.262-1.081 0.371-0.136 0.041-0.285 0.031-0.33-0.137-0.044-0.164 0.064-0.242 0.209-0.288 0.246-0.076 0.49-0.16 0.736-0.239 0.758-0.241 1.131-0.776 1.224-1.55 0.069-0.57 0.030-1.136-0.009-1.704-0.003-0.031-0.010-0.061-0.010-0.093 0.001-0.155-0.025-0.341 0.201-0.348 0.215-0.006 0.235 0.18 0.24 0.332 0.014 0.341 0.006 0.683 0.006 1.024z"/><path d="M6.463 24.129c0.001 0.105-0.061 0.172-0.14 0.227-0.535 0.371-1.069 0.744-1.607 1.109-0.124 0.084-0.287 0.2-0.409 0.023-0.116-0.17 0.031-0.291 0.159-0.381 0.532-0.375 1.066-0.749 1.606-1.111 0.199-0.133 0.391-0.056 0.391 0.134z"/><path d="M4.7 23.599c-0.173-0.006-0.28-0.016-0.306-0.148-0.022-0.115 0.019-0.211 0.136-0.244 0.525-0.149 1.051-0.294 1.579-0.433 0.11-0.029 0.206 0.017 0.244 0.137 0.040 0.129-0.008 0.241-0.13 0.276-0.526 0.149-1.055 0.285-1.522 0.41z"/><path d="M6.555 26.101c0.115-0.419 0.231-0.858 0.359-1.293 0.032-0.11 0.134-0.161 0.249-0.137 0.133 0.027 0.199 0.129 0.165 0.255-0.117 0.449-0.242 0.896-0.376 1.34-0.032 0.11-0.119 0.212-0.256 0.174-0.165-0.045-0.109-0.2-0.14-0.339z"/><path d="M16.191 13.367c1.078 0.015 1.637 0.659 1.977 1.479 0.050 0.123 0.060 0.28-0.113 0.34-0.17 0.060-0.253-0.063-0.305-0.191-0.633-1.54-1.887-1.364-2.883-0.668-0.221 0.155-0.419 0.338-0.571 0.566-0.086 0.13-0.209 0.236-0.36 0.124-0.146-0.109-0.095-0.26 0-0.385 0.586-0.768 1.36-1.193 2.254-1.265z"/><path d="M14.811 12.136c-0.012 0.351-0.289 0.64-0.604 0.609-0.331-0.033-0.438-0.266-0.449-0.793-0.006-0.275 0.203-0.424 0.535-0.418 0.314 0.004 0.529 0.255 0.518 0.601z"/><path d="M17.969 12.627c-0.29-0.004-0.461-0.181-0.453-0.469 0.010-0.33 0.236-0.603 0.503-0.604 0.245-0.001 0.531 0.325 0.523 0.598-0.009 0.287-0.242 0.48-0.573 0.475z"/></svg>',
		'check'            => '<svg viewBox="0 0 32 32"><path d="M13.82 23.22l-6.88-6.88 2.12-2.12 4.76 4.76 9.12-9.14 2.12 2.12z"></path></svg>',
		'cart-trolley'     => '<svg viewBox="0 0 32 32"><path d="M25.248 22.4l3.552-14.4h-18.528l-0.96-4.8h-6.112v3.2h3.488l3.2 16h15.36zM24.704 11.2l-1.968 8h-10.24l-1.6-8h13.808z"></path><path d="M25.6 26.4c0 1.325-1.075 2.4-2.4 2.4s-2.4-1.075-2.4-2.4c0-1.325 1.075-2.4 2.4-2.4s2.4 1.075 2.4 2.4z"></path><path d="M14.4 26.4c0 1.325-1.075 2.4-2.4 2.4s-2.4-1.075-2.4-2.4c0-1.325 1.075-2.4 2.4-2.4s2.4 1.075 2.4 2.4z"></path></svg>',
		'cart-bag'         => '<svg viewBox="0 0 32 32"><path d = "M24 6.4h-1.616c-0.048-1.744-0.8-3.408-2.096-4.592-1.344-1.216-3.136-1.792-4.944-1.616-3.088 0.304-5.504 2.992-5.712 6.208h-1.632c-2.64 0-4.8 2.16-4.8 4.8v11.2c0 4.416 3.584 8 8 8h9.6c4.416 0 8-3.584 8-8v-11.2c0-2.64-2.16-4.8-4.8-4.8zM15.664 3.376c0.928-0.096 1.808 0.192 2.48 0.816 0.624 0.576 0.992 1.376 1.040 2.208h-6.352c0.192-1.584 1.36-2.88 2.832-3.024zM25.6 22.4c0 2.64-2.16 4.8-4.8 4.8h-9.6c-2.64 0-4.8-2.16-4.8-4.8v-11.2c0-0.88 0.72-1.6 1.6-1.6h16c0.88 0 1.6 0.72 1.6 1.6v11.2z"></path><path d = "M16 15.2c-1.76 0-3.2-1.44-3.2-3.2h-3.2c0 3.536 2.864 6.4 6.4 6.4s6.4-2.864 6.4-6.4h-3.2c0 1.76-1.44 3.2-3.2 3.2z"></path></svg>',
		'trash'            => '<svg viewBox="0 0 32 32"><path d="M23.84 9.6h-15.68c-0.96 0-1.6 0.8-1.6 1.76l1.28 14.56c0.16 1.6 1.6 2.88 3.2 2.88h10.080c1.6 0 3.040-1.28 3.2-2.88l1.28-14.56c0-0.96-0.8-1.76-1.76-1.76zM21.12 25.6h-10.24l-0.96-12.8h12.32l-1.12 12.8z"></path><path d="M24 4.8h-4.8c0-0.96-0.64-1.6-1.6-1.6h-3.2c-0.96 0-1.6 0.64-1.6 1.6h-4.8c-1.76 0-3.2 1.44-3.2 3.2h22.4c0-1.76-1.44-3.2-3.2-3.2z"></path><path d="M14.4 16h3.2v6.4h-3.2v-6.4z"></path></svg>',
		'minus'            => '<svg viewBox="0 0 32 32"><path d="M26.667 13.333v5.333h-21.333v-5.333h21.333z"></path></svg>',
		'plus'             => '<svg viewBox="0 0 32 32"><path d="M26.667 13.333h-8v-8h-5.333v8h-8v5.333h8v8h5.333v-8h8z"></path></svg>',
		'star'             => '<svg viewBox="0 0 32 32"><path d="M16 1.333l3.467 11.2h11.2l-9.067 6.933 3.467 11.2-9.067-6.933-9.067 6.933 3.467-11.2-9.067-6.933h11.2z"></path></svg>',
		'print'            => '<svg viewBox="0 0 32 32"><path d="M22.857 11.429v-9.143h-13.714v9.143h-6.857v13.714h6.857v4.571h13.714v-4.571h6.857v-13.714h-6.857zM11.886 5.029h8.229v6.4h-8.229v-6.4zM20.114 22.4v4.571h-8.229v-5.943h8.229v1.371zM26.971 22.4h-4.114v-4.114h-13.714v4.114h-4.114v-8.229h21.943v8.229z"></path></svg>',
		'360'              => '<svg viewBox="0 0 32 32"><path d="M7.733 15.773c0.6 0.187 1.080 0.507 1.44 0.96s0.547 1 0.547 1.64c0 1-0.333 1.773-0.987 2.32s-1.467 0.813-2.44 0.813c-0.773 0-1.453-0.173-2.067-0.533-0.6-0.36-1.027-0.88-1.307-1.573l2.080-1.187c0.2 0.653 0.627 0.973 1.28 0.973 0.333 0 0.6-0.080 0.773-0.24 0.187-0.16 0.28-0.373 0.28-0.64s-0.093-0.48-0.28-0.64c-0.187-0.16-0.44-0.227-0.773-0.227h-0.493l-0.92-1.36 1.493-1.827h-3.133v-2.28h6.067v1.88l-1.56 1.92z"></path><path d="M14.347 14.947c0.907 0.12 1.627 0.467 2.173 1.053s0.813 1.333 0.813 2.213c0 0.973-0.32 1.76-0.973 2.373s-1.507 0.92-2.56 0.92c-1.053 0-1.907-0.307-2.56-0.92s-0.973-1.413-0.973-2.373c0-0.733 0.2-1.373 0.587-1.933l2.76-4.307h2.707l-1.973 2.973zM13.8 19.32c0.333 0 0.6-0.093 0.827-0.293s0.333-0.467 0.333-0.813c0-0.36-0.107-0.627-0.32-0.827s-0.493-0.293-0.827-0.293c-0.333 0-0.613 0.093-0.827 0.293s-0.32 0.467-0.32 0.827 0.107 0.627 0.32 0.827 0.48 0.28 0.813 0.28z"></path><path d="M24.587 20.173c-0.68 0.88-1.627 1.333-2.84 1.333s-2.16-0.44-2.853-1.333c-0.68-0.88-1.027-2.067-1.027-3.533 0-1.48 0.333-2.653 1.027-3.547 0.68-0.88 1.627-1.333 2.853-1.333 1.213 0 2.16 0.44 2.84 1.333 0.68 0.88 1.013 2.067 1.013 3.547 0 1.467-0.333 2.653-1.013 3.533zM20.253 16.64c0 1.693 0.493 2.547 1.48 2.547s1.48-0.853 1.48-2.547c0-1.693-0.493-2.547-1.48-2.547-0.987-0.013-1.48 0.84-1.48 2.547z"></path><path d="M28.040 15.16c-0.68 0-1.24-0.227-1.693-0.68s-0.68-1-0.68-1.64c0-0.653 0.227-1.2 0.68-1.653s1.013-0.68 1.693-0.68 1.24 0.227 1.68 0.68c0.453 0.453 0.667 1 0.667 1.653s-0.227 1.2-0.667 1.64c-0.427 0.453-1 0.68-1.68 0.68zM27.6 13.267c0.107 0.107 0.253 0.16 0.44 0.16 0.173 0 0.32-0.053 0.427-0.16s0.16-0.253 0.16-0.44-0.053-0.32-0.16-0.44c-0.107-0.12-0.253-0.173-0.413-0.173-0.173 0-0.32 0.053-0.44 0.173-0.107 0.12-0.16 0.267-0.16 0.44s0.040 0.333 0.147 0.44z"></path></svg>',
		'pause'            => '<svg viewBox="0 0 32 32"><path d="M13.008 0h-7.006c-0.552 0-1 0.448-1 1v30c0 0.552 0.448 1 1 1h7.006c0.553 0 1-0.448 1-1v-30c0-0.552-0.447-1-1-1zM12.008 30h-5.006v-28h5.006v28zM25.998 0h-6.971c-0.552 0-1 0.448-1 1v30c0 0.552 0.448 1 1 1h6.971c0.552 0 1-0.448 1-1v-30c0-0.552-0.447-1-1-1zM24.998 30h-4.971v-28h4.971v28z"></path></svg>',
		'full-screen'      => '<svg viewBox="0 0 32 32"><path d="M14.667 24h-6.667v-6.667h2.667v4h4z"></path><path d="M10.667 14.667h-2.667v-6.667h6.667v2.667h-4z"></path><path d="M24 14.667h-2.667v-4h-4v-2.667h6.667z"></path><path d="M24 24h-6.667v-2.667h4v-4h2.667z"></path></svg>',
		'view-large'       => '<svg viewBox="0 0 43 32"><path d="M18.667 6.667v18.667h-12v-18.667h12zM20 5.333h-14.667v21.333h14.667v-21.333z"></path><path d="M36 6.667v18.667h-12v-18.667h12zM37.333 5.333h-14.667v21.333h14.667v-21.333z"></path></svg>',
		'view-medium'      => '<svg viewBox="0 0 43 32"><path d="M13.333 6.667v6.667h-6.667v-6.667h6.667zM14.667 5.333h-9.333v9.333h9.333v-9.333z"></path><path d="M25.333 6.667v6.667h-6.667v-6.667h6.667zM26.667 5.333h-9.333v9.333h9.333v-9.333z"></path><path d="M13.333 18.667v6.667h-6.667v-6.667h6.667zM14.667 17.333h-9.333v9.333h9.333v-9.333z"></path><path d="M25.333 18.667v6.667h-6.667v-6.667h6.667zM26.667 17.333h-9.333v9.333h9.333v-9.333z"></path><path d="M37.333 6.667v6.667h-6.667v-6.667h6.667zM38.667 5.333h-9.333v9.333h9.333v-9.333z"></path><path d="M37.333 18.667v6.667h-6.667v-6.667h6.667zM38.667 17.333h-9.333v9.333h9.333v-9.333z"></path></svg>',
		'view-small'       => '<svg viewBox="0 0 43 32"><path d="M10.667 6.667v2.667h-2.667v-2.667h2.667zM12 5.333h-5.333v5.333h5.333v-5.333z"></path><path d="M10.667 14.667v2.667h-2.667v-2.667h2.667zM12 13.333h-5.333v5.333h5.333v-5.333z"></path><path d="M10.667 22.667v2.667h-2.667v-2.667h2.667zM12 21.333h-5.333v5.333h5.333v-5.333z"></path><path d="M18.667 6.667v2.667h-2.667v-2.667h2.667zM20 5.333h-5.333v5.333h5.333v-5.333z"></path><path d="M18.667 14.667v2.667h-2.667v-2.667h2.667zM20 13.333h-5.333v5.333h5.333v-5.333z"></path><path d="M18.667 22.667v2.667h-2.667v-2.667h2.667zM20 21.333h-5.333v5.333h5.333v-5.333z"></path><path d="M26.667 6.667v2.667h-2.667v-2.667h2.667zM28 5.333h-5.333v5.333h5.333v-5.333z"></path><path d="M26.667 14.667v2.667h-2.667v-2.667h2.667zM28 13.333h-5.333v5.333h5.333v-5.333z"></path><path d="M26.667 22.667v2.667h-2.667v-2.667h2.667zM28 21.333h-5.333v5.333h5.333v-5.333z"></path><path d="M34.667 6.667v2.667h-2.667v-2.667h2.667zM36 5.333h-5.333v5.333h5.333v-5.333z"></path><path d="M34.667 14.667v2.667h-2.667v-2.667h2.667zM36 13.333h-5.333v5.333h5.333v-5.333z"></path><path d="M34.667 22.667v2.667h-2.667v-2.667h2.667zM36 21.333h-5.333v5.333h5.333v-5.333z"></path></svg>',
		'view-small-extra' => '<svg viewBox="0 0 43 32"><path d="M6.667 6.667v2.667h-2.667v-2.667h2.667zM8 5.333h-5.333v5.333h5.333v-5.333z"></path><path d="M6.667 14.667v2.667h-2.667v-2.667h2.667zM8 13.333h-5.333v5.333h5.333v-5.333z"></path><path d="M6.667 22.667v2.667h-2.667v-2.667h2.667zM8 21.333h-5.333v5.333h5.333v-5.333z"></path><path d="M14.667 6.667v2.667h-2.667v-2.667h2.667zM16 5.333h-5.333v5.333h5.333v-5.333z"></path><path d="M14.667 14.667v2.667h-2.667v-2.667h2.667zM16 13.333h-5.333v5.333h5.333v-5.333z"></path><path d="M14.667 22.667v2.667h-2.667v-2.667h2.667zM16 21.333h-5.333v5.333h5.333v-5.333z"></path><path d="M22.667 6.667v2.667h-2.667v-2.667h2.667zM24 5.333h-5.333v5.333h5.333v-5.333z"></path><path d="M22.667 14.667v2.667h-2.667v-2.667h2.667zM24 13.333h-5.333v5.333h5.333v-5.333z"></path><path d="M22.667 22.667v2.667h-2.667v-2.667h2.667zM24 21.333h-5.333v5.333h5.333v-5.333z"></path><path d="M30.667 6.667v2.667h-2.667v-2.667h2.667zM32 5.333h-5.333v5.333h5.333v-5.333z"></path><path d="M30.667 14.667v2.667h-2.667v-2.667h2.667zM32 13.333h-5.333v5.333h5.333v-5.333z"></path><path d="M30.667 22.667v2.667h-2.667v-2.667h2.667zM32 21.333h-5.333v5.333h5.333v-5.333z"></path><path d="M38.667 6.667v2.667h-2.667v-2.667h2.667zM40 5.333h-5.333v5.333h5.333v-5.333z"></path><path d="M38.667 14.667v2.667h-2.667v-2.667h2.667zM40 13.333h-5.333v5.333h5.333v-5.333z"></path><path d="M38.667 22.667v2.667h-2.667v-2.667h2.667zM40 21.333h-5.333v5.333h5.333v-5.333z"></path></svg>',
		'view-list'        => '<svg viewBox="0 0 43 32"><path d="M10.667 6.667v2.667h-2.667v-2.667h2.667zM12 5.333h-5.333v5.333h5.333v-5.333z"></path><path d="M10.667 14.667v2.667h-2.667v-2.667h2.667zM12 13.333h-5.333v5.333h5.333v-5.333z"></path><path d="M10.667 22.667v2.667h-2.667v-2.667h2.667zM12 21.333h-5.333v5.333h5.333v-5.333z"></path><path d="M34.667 6.667v2.667h-18.667v-2.667h18.667zM36 5.333h-21.333v5.333h21.333v-5.333z"></path><path d="M34.667 14.667v2.667h-18.667v-2.667h18.667zM36 13.333h-21.333v5.333h21.333v-5.333z"></path><path d="M34.667 22.667v2.667h-18.667v-2.667h18.667zM36 21.333h-21.333v5.333h21.333v-5.333z"></path></svg>',
		'filter'           => '<svg viewBox="0 0 32 32"><path d="M8 14.4h3.2v-9.6h-3.2v3.2h-4.8v3.2h4.8z"></path><path d="M24 17.6h-3.2v9.6h3.2v-3.2h4.8v-3.2h-4.8z"></path><path d="M14.4 8h14.4v3.2h-14.4v-3.2z"></path><path d="M3.2 20.8h14.4v3.2h-14.4v-3.2z"></path></svg>',
		'eye'              => '<svg viewBox="0 0 24 24"><path d="M0.106 11.553c-0.136 0.274-0.146 0.603 0 0.894 0 0 0.396 0.789 1.12 1.843 0.451 0.656 1.038 1.432 1.757 2.218 0.894 0.979 2.004 1.987 3.319 2.8 1.595 0.986 3.506 1.692 5.698 1.692s4.103-0.706 5.698-1.692c1.315-0.813 2.425-1.821 3.319-2.8 0.718-0.786 1.306-1.562 1.757-2.218 0.724-1.054 1.12-1.843 1.12-1.843 0.136-0.274 0.146-0.603 0-0.894 0 0-0.396-0.789-1.12-1.843-0.451-0.656-1.038-1.432-1.757-2.218-0.894-0.979-2.004-1.987-3.319-2.8-1.595-0.986-3.506-1.692-5.698-1.692s-4.103 0.706-5.698 1.692c-1.315 0.813-2.425 1.821-3.319 2.8-0.719 0.786-1.306 1.561-1.757 2.218-0.724 1.054-1.12 1.843-1.12 1.843zM2.14 12c0.163-0.281 0.407-0.681 0.734-1.158 0.41-0.596 0.94-1.296 1.585-2.001 0.805-0.881 1.775-1.756 2.894-2.448 1.35-0.834 2.901-1.393 4.647-1.393s3.297 0.559 4.646 1.393c1.119 0.692 2.089 1.567 2.894 2.448 0.644 0.705 1.175 1.405 1.585 2.001 0.328 0.477 0.572 0.876 0.734 1.158-0.163 0.281-0.407 0.681-0.734 1.158-0.41 0.596-0.94 1.296-1.585 2.001-0.805 0.881-1.775 1.756-2.894 2.448-1.349 0.834-2.9 1.393-4.646 1.393s-3.297-0.559-4.646-1.393c-1.119-0.692-2.089-1.567-2.894-2.448-0.644-0.705-1.175-1.405-1.585-2.001-0.328-0.477-0.572-0.877-0.735-1.158zM16 12c0-1.104-0.449-2.106-1.172-2.828s-1.724-1.172-2.828-1.172-2.106 0.449-2.828 1.172-1.172 1.724-1.172 2.828 0.449 2.106 1.172 2.828 1.724 1.172 2.828 1.172 2.106-0.449 2.828-1.172 1.172-1.724 1.172-2.828zM14 12c0 0.553-0.223 1.051-0.586 1.414s-0.861 0.586-1.414 0.586-1.051-0.223-1.414-0.586-0.586-0.861-0.586-1.414 0.223-1.051 0.586-1.414 0.861-0.586 1.414-0.586 1.051 0.223 1.414 0.586 0.586 0.861 0.586 1.414z"></path></svg>',
		'pr-arrow'         => '<svg viewBox="0 0 32 32"><path d="M20.112 5.488l-1.824 1.824 7.424 7.408h-22.512v2.56h22.512l-7.424 7.408 1.824 1.824 10.496-10.512z"></path></svg>',
		'location'         => '<svg viewBox="0 0 32 32"><path d="M16 3.886c2.583 0 5.006 1.006 6.811 2.811s2.811 4.206 2.811 6.766-1.006 4.96-2.811 6.766l-6.811 6.766-6.811-6.789c-1.829-1.806-2.834-4.206-2.834-6.766s1.006-4.96 2.811-6.766c1.829-1.783 4.251-2.789 6.834-2.789zM16 1.143c-3.177 0-6.331 1.211-8.754 3.611-4.846 4.8-4.846 12.594 0 17.417l8.754 8.686 8.754-8.709c4.846-4.8 4.846-12.594 0-17.417-2.423-2.377-5.577-3.589-8.754-3.589v0z"></path><path d="M16 11.154c0.64 0 1.234 0.251 1.691 0.709 0.937 0.937 0.937 2.469 0 3.383-0.457 0.457-1.051 0.709-1.691 0.709s-1.234-0.251-1.691-0.709c-0.937-0.937-0.937-2.469 0-3.383 0.457-0.457 1.051-0.709 1.691-0.709zM16 8.411c-1.326 0-2.629 0.503-3.634 1.509-2.011 2.011-2.011 5.257 0 7.269 1.006 1.006 2.309 1.509 3.634 1.509s2.629-0.503 3.634-1.509c2.011-2.011 2.011-5.257 0-7.269-1.006-1.006-2.309-1.509-3.634-1.509v0z"></path></svg>',
		'language'         => '<svg viewBox="0 0 32 32"><path d="M29.509 13.714c-0.137-0.777-0.32-1.554-0.594-2.286-1.737-4.891-6.149-8.503-11.474-9.074 0 0 0-0.023-0.023-0.023 0 0 0 0 0 0.023-0.457-0.046-0.937-0.069-1.417-0.069s-0.96 0.023-1.417 0.069c0 0 0 0 0-0.023 0 0 0 0.023-0.023 0.023-5.326 0.571-9.737 4.183-11.474 9.074-0.251 0.731-0.457 1.509-0.594 2.286-0.114 0.754-0.206 1.509-0.206 2.286s0.091 1.531 0.206 2.286c0.137 0.777 0.32 1.554 0.594 2.286 1.737 4.891 6.149 8.503 11.474 9.074 0 0 0 0.023 0.023 0.023 0 0 0 0 0-0.023 0.457 0.046 0.937 0.069 1.417 0.069s0.96-0.023 1.417-0.069c0 0 0 0 0 0.023 0 0 0-0.023 0.023-0.023 5.326-0.549 9.737-4.183 11.474-9.074 0.251-0.731 0.457-1.509 0.594-2.286 0.114-0.754 0.206-1.509 0.206-2.286s-0.091-1.531-0.206-2.286zM26.469 11.429h-5.211c-0.434-2.263-1.189-4.411-2.217-6.4 3.314 0.937 6.057 3.291 7.429 6.4zM19.429 16c0 0.777-0.046 1.531-0.114 2.286h-6.629c-0.069-0.754-0.114-1.509-0.114-2.286s0.046-1.531 0.114-2.286h6.606c0.091 0.754 0.137 1.509 0.137 2.286zM16.16 27.406c-0.069 0-0.114 0.023-0.16 0.023s-0.091-0.023-0.16-0.023c-1.28-2.080-2.24-4.366-2.766-6.834h5.874c-0.549 2.469-1.509 4.754-2.789 6.834zM15.84 4.594c0.069 0 0.114-0.023 0.16-0.023s0.091 0.023 0.16 0.023c1.28 2.080 2.24 4.366 2.766 6.834h-5.851c0.526-2.469 1.486-4.754 2.766-6.834zM12.96 5.029c-1.029 1.989-1.783 4.137-2.217 6.4h-5.211c1.371-3.109 4.114-5.463 7.429-6.4zM4.571 16c0-0.777 0.091-1.554 0.229-2.286h5.6c-0.069 0.754-0.114 1.509-0.114 2.286s0.046 1.531 0.114 2.286h-5.6c-0.137-0.731-0.229-1.509-0.229-2.286zM5.531 20.571h5.211c0.434 2.263 1.211 4.411 2.217 6.4-3.314-0.937-6.057-3.291-7.429-6.4zM19.040 26.971c1.029-1.989 1.783-4.137 2.217-6.4h5.189c-1.349 3.109-4.091 5.463-7.406 6.4zM21.6 18.286c0.069-0.754 0.114-1.509 0.114-2.286s-0.046-1.531-0.114-2.286h5.6c0.137 0.731 0.229 1.509 0.229 2.286s-0.091 1.554-0.229 2.286h-5.6z"></path></svg>',
		'currency'         => '<svg viewBox="0 0 32 32"><path d="M27.429 6.857h-22.857c-1.257 0-2.286 1.029-2.286 2.286v13.714c0 1.257 1.029 2.286 2.286 2.286h22.857c1.257 0 2.286-1.029 2.286-2.286v-13.714c0-1.257-1.029-2.286-2.286-2.286zM4.571 9.143h3.429c0 1.897-1.531 3.429-3.429 3.429v-3.429zM4.571 22.857v-3.429c1.897 0 3.429 1.531 3.429 3.429h-3.429zM27.429 22.857h-3.429c0-1.897 1.531-3.429 3.429-3.429v3.429zM27.429 17.143c-3.154 0-5.714 2.56-5.714 5.714h-11.429c0-3.154-2.56-5.714-5.714-5.714v-2.286c3.154 0 5.714-2.56 5.714-5.714h11.429c0 3.154 2.56 5.714 5.714 5.714v2.286zM27.429 12.571c-1.897 0-3.429-1.531-3.429-3.429h3.429v3.429z"></path><path d="M16 11.429c-2.514 0-4.571 2.057-4.571 4.571s2.057 4.571 4.571 4.571 4.571-2.057 4.571-4.571c0-2.514-2.057-4.571-4.571-4.571zM16 18.286c-1.257 0-2.286-1.029-2.286-2.286s1.029-2.286 2.286-2.286 2.286 1.029 2.286 2.286-1.029 2.286-2.286 2.286z"></path></svg>',
		'home'        	   => '<svg viewBox="0 0 32 32"><path d="M27.52 11.84l-9.6-7.2c-0.64-0.48-1.28-0.64-1.92-0.64s-1.28 0.16-1.92 0.64l-9.6 7.2c-0.8 0.64-1.28 1.6-1.28 2.56v11.2c0 1.76 1.44 3.2 3.2 3.2h19.2c1.76 0 3.2-1.44 3.2-3.2v-11.2c0-0.96-0.48-1.92-1.28-2.56zM25.6 25.6h-7.2v-4c0-1.28-1.12-2.4-2.4-2.4s-2.4 1.12-2.4 2.4v4h-7.2v-11.2l9.6-7.2 9.6 7.2v11.2z"></path></svg>',
		'more'        	   => '<svg viewBox="0 0 32 32"> <path d="M8 16c0 1.767-1.433 3.2-3.2 3.2s-3.2-1.433-3.2-3.2c0-1.767 1.433-3.2 3.2-3.2s3.2 1.433 3.2 3.2z"></path> <path d="M19.2 16c0 1.767-1.433 3.2-3.2 3.2s-3.2-1.433-3.2-3.2c0-1.767 1.433-3.2 3.2-3.2s3.2 1.433 3.2 3.2z"></path> <path d="M30.4 16c0 1.767-1.433 3.2-3.2 3.2s-3.2-1.433-3.2-3.2c0-1.767 1.433-3.2 3.2-3.2s3.2 1.433 3.2 3.2z"></path> </svg>',
		'move-left-right'  => '<svg viewBox="0 0 32 32"><path d="M12.14 13.527c-0.26-0.26-0.68-0.26-0.94 0l-1.527 1.527c-0.52 0.52-0.52 1.367 0 1.887l1.527 1.527c0.133 0.133 0.3 0.193 0.473 0.193s0.34-0.067 0.473-0.193c0.26-0.26 0.26-0.68 0-0.94l-1.54-1.527 1.527-1.527c0.267-0.26 0.267-0.687 0.007-0.947z"></path><path d="M19.86 18.473c0.133 0.133 0.3 0.193 0.473 0.193s0.34-0.067 0.473-0.193l1.527-1.527c0.52-0.52 0.52-1.367 0-1.887l-1.527-1.527c-0.26-0.26-0.68-0.26-0.94 0s-0.26 0.68 0 0.94l1.527 1.527-1.527 1.527c-0.267 0.26-0.267 0.687-0.007 0.947z"></path></svg>',
	);

	/**
	 * Social Icons – svg sources.
	 *
	 * @since 1.0.0
	 *
	 * @return string
	 */
	public static $social_icons = array(
		'500px'           => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M6.94026,15.1412c.00437.01213.108.29862.168.44064a6.55008,6.55008,0,1,0,6.03191-9.09557,6.68654,6.68654,0,0,0-2.58357.51467A8.53914,8.53914,0,0,0,8.21268,8.61344L8.209,8.61725V3.22948l9.0504-.00008c.32934-.0036.32934-.46353.32934-.61466s0-.61091-.33035-.61467L7.47248,2a.43.43,0,0,0-.43131.42692v7.58355c0,.24466.30476.42131.58793.4819.553.11812.68074-.05864.81617-.2457l.018-.02481A10.52673,10.52673,0,0,1,9.32258,9.258a5.35268,5.35268,0,1,1,7.58985,7.54976,5.417,5.417,0,0,1-3.80867,1.56365,5.17483,5.17483,0,0,1-2.69822-.74478l.00342-4.61111a2.79372,2.79372,0,0,1,.71372-1.78792,2.61611,2.61611,0,0,1,1.98282-.89477,2.75683,2.75683,0,0,1,1.95525.79477,2.66867,2.66867,0,0,1,.79656,1.909,2.724,2.724,0,0,1-2.75849,2.748,4.94651,4.94651,0,0,1-.86254-.13719c-.31234-.093-.44519.34058-.48892.48349-.16811.54966.08453.65862.13687.67489a3.75751,3.75751,0,0,0,1.25234.18375,3.94634,3.94634,0,1,0-2.82444-6.742,3.67478,3.67478,0,0,0-1.13028,2.584l-.00041.02323c-.0035.11667-.00579,2.881-.00644,3.78811l-.00407-.00451a6.18521,6.18521,0,0,1-1.0851-1.86092c-.10544-.27856-.34358-.22925-.66857-.12917-.14192.04372-.57386.17677-.47833.489Zm4.65165-1.08338a.51346.51346,0,0,0,.19513.31818l.02276.022a.52945.52945,0,0,0,.3517.18416.24242.24242,0,0,0,.16577-.0611c.05473-.05082.67382-.67812.73287-.738l.69041.68819a.28978.28978,0,0,0,.21437.11032.53239.53239,0,0,0,.35708-.19486c.29792-.30419.14885-.46821.07676-.54751l-.69954-.69975.72952-.73469c.16-.17311.01874-.35708-.12218-.498-.20461-.20461-.402-.25742-.52855-.14083l-.7254.72665-.73354-.73375a.20128.20128,0,0,0-.14179-.05695.54135.54135,0,0,0-.34379.19648c-.22561.22555-.274.38149-.15656.5059l.73374.7315-.72942.73072A.26589.26589,0,0,0,11.59191,14.05782Zm1.59866-9.915A8.86081,8.86081,0,0,0,9.854,4.776a.26169.26169,0,0,0-.16938.22759.92978.92978,0,0,0,.08619.42094c.05682.14524.20779.531.50006.41955a8.40969,8.40969,0,0,1,2.91968-.55484,7.87875,7.87875,0,0,1,3.086.62286,8.61817,8.61817,0,0,1,2.30562,1.49315.2781.2781,0,0,0,.18318.07586c.15529,0,.30425-.15253.43167-.29551.21268-.23861.35873-.4369.1492-.63538a8.50425,8.50425,0,0,0-2.62312-1.694A9.0177,9.0177,0,0,0,13.19058,4.14283ZM19.50945,18.6236h0a.93171.93171,0,0,0-.36642-.25406.26589.26589,0,0,0-.27613.06613l-.06943.06929A7.90606,7.90606,0,0,1,7.60639,18.505a7.57284,7.57284,0,0,1-1.696-2.51537,8.58715,8.58715,0,0,1-.5147-1.77754l-.00871-.04864c-.04939-.25873-.28755-.27684-.62981-.22448-.14234.02178-.5755.088-.53426.39969l.001.00712a9.08807,9.08807,0,0,0,15.406,4.99094c.00193-.00192.04753-.04718.0725-.07436C19.79425,19.16234,19.87422,18.98728,19.50945,18.6236Z"></path></svg>',
		'amazon'          => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M13.582,8.182C11.934,8.367,9.78,8.49,8.238,9.166c-1.781,0.769-3.03,2.337-3.03,4.644 c0,2.953,1.86,4.429,4.253,4.429c2.02,0,3.125-0.477,4.685-2.065c0.516,0.747,0.685,1.109,1.629,1.894 c0.212,0.114,0.483,0.103,0.672-0.066l0.006,0.006c0.567-0.505,1.599-1.401,2.18-1.888c0.231-0.188,0.19-0.496,0.009-0.754 c-0.52-0.718-1.072-1.303-1.072-2.634V8.305c0-1.876,0.133-3.599-1.249-4.891C15.23,2.369,13.422,2,12.04,2 C9.336,2,6.318,3.01,5.686,6.351C5.618,6.706,5.877,6.893,6.109,6.945l2.754,0.298C9.121,7.23,9.308,6.977,9.357,6.72 c0.236-1.151,1.2-1.706,2.284-1.706c0.584,0,1.249,0.215,1.595,0.738c0.398,0.584,0.346,1.384,0.346,2.061V8.182z M13.049,14.088 c-0.451,0.8-1.169,1.291-1.967,1.291c-1.09,0-1.728-0.83-1.728-2.061c0-2.42,2.171-2.86,4.227-2.86v0.615 C13.582,12.181,13.608,13.104,13.049,14.088z M20.683,19.339C18.329,21.076,14.917,22,11.979,22c-4.118,0-7.826-1.522-10.632-4.057 c-0.22-0.199-0.024-0.471,0.241-0.317c3.027,1.762,6.771,2.823,10.639,2.823c2.608,0,5.476-0.541,8.115-1.66 C20.739,18.62,21.072,19.051,20.683,19.339z M21.336,21.043c-0.194,0.163-0.379,0.076-0.293-0.139 c0.284-0.71,0.92-2.298,0.619-2.684c-0.301-0.386-1.99-0.183-2.749-0.092c-0.23,0.027-0.266-0.173-0.059-0.319 c1.348-0.946,3.555-0.673,3.811-0.356C22.925,17.773,22.599,19.986,21.336,21.043z"></path></svg>',
		'bandcamp'        => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M15.27 17.289 3 17.289 8.73 6.711 21 6.711 15.27 17.289"></path></svg>',
		'behance'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M232 237.2c31.8-15.2 48.4-38.2 48.4-74 0-70.6-52.6-87.8-113.3-87.8H0v354.4h171.8c64.4 0 124.9-30.9 124.9-102.9 0-44.5-21.1-77.4-64.7-89.7zM77.9 135.9H151c28.1 0 53.4 7.9 53.4 40.5 0 30.1-19.7 42.2-47.5 42.2h-79v-82.7zm83.3 233.7H77.9V272h84.9c34.3 0 56 14.3 56 50.6 0 35.8-25.9 47-57.6 47zm358.5-240.7H376V94h143.7v34.9zM576 305.2c0-75.9-44.4-139.2-124.9-139.2-78.2 0-131.3 58.8-131.3 135.8 0 79.9 50.3 134.7 131.3 134.7 61.3 0 101-27.6 120.1-86.3H509c-6.7 21.9-34.3 33.5-55.7 33.5-41.3 0-63-24.2-63-65.3h185.1c.3-4.2.6-8.7.6-13.2zM390.4 274c2.3-33.7 24.7-54.8 58.5-54.8 35.4 0 53.2 20.8 56.2 54.8H390.4z"/></svg>',
		'blogger' 		  => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M446.6 222.7c-1.8-8-6.8-15.4-12.5-18.5-1.8-1-13-2.2-25-2.7-20.1-.9-22.3-1.3-28.7-5-10.1-5.9-12.8-12.3-12.9-29.5-.1-33-13.8-63.7-40.9-91.3-19.3-19.7-40.9-33-65.5-40.5-5.9-1.8-19.1-2.4-63.3-2.9-69.4-.8-84.8.6-108.4 10C45.9 59.5 14.7 96.1 3.3 142.9 1.2 151.7.7 165.8.2 246.8c-.6 101.5.1 116.4 6.4 136.5 15.6 49.6 59.9 86.3 104.4 94.3 14.8 2.7 197.3 3.3 216 .8 32.5-4.4 58-17.5 81.9-41.9 17.3-17.7 28.1-36.8 35.2-62.1 4.9-17.6 4.5-142.8 2.5-151.7zm-322.1-63.6c7.8-7.9 10-8.2 58.8-8.2 43.9 0 45.4.1 51.8 3.4 9.3 4.7 13.4 11.3 13.4 21.9 0 9.5-3.8 16.2-12.3 21.6-4.6 2.9-7.3 3.1-50.3 3.3-26.5.2-47.7-.4-50.8-1.2-16.6-4.7-22.8-28.5-10.6-40.8zm191.8 199.8l-14.9 2.4-77.5.9c-68.1.8-87.3-.4-90.9-2-7.1-3.1-13.8-11.7-14.9-19.4-1.1-7.3 2.6-17.3 8.2-22.4 7.1-6.4 10.2-6.6 97.3-6.7 89.6-.1 89.1-.1 97.6 7.8 12.1 11.3 9.5 31.2-4.9 39.4z"/></svg>',
		'codepen'         => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M22.016,8.84c-0.002-0.013-0.005-0.025-0.007-0.037c-0.005-0.025-0.008-0.048-0.015-0.072 c-0.003-0.015-0.01-0.028-0.013-0.042c-0.008-0.02-0.015-0.04-0.023-0.062c-0.007-0.015-0.013-0.028-0.02-0.042 c-0.008-0.02-0.018-0.037-0.03-0.057c-0.007-0.013-0.017-0.027-0.025-0.038c-0.012-0.018-0.023-0.035-0.035-0.052 c-0.01-0.013-0.02-0.025-0.03-0.037c-0.015-0.017-0.028-0.032-0.043-0.045c-0.01-0.012-0.022-0.023-0.035-0.035 c-0.015-0.015-0.032-0.028-0.048-0.04c-0.012-0.01-0.025-0.02-0.037-0.03c-0.005-0.003-0.01-0.008-0.015-0.012l-9.161-6.096 c-0.289-0.192-0.666-0.192-0.955,0L2.359,8.237C2.354,8.24,2.349,8.245,2.344,8.249L2.306,8.277 c-0.017,0.013-0.033,0.027-0.048,0.04C2.246,8.331,2.234,8.342,2.222,8.352c-0.015,0.015-0.028,0.03-0.042,0.047 c-0.012,0.013-0.022,0.023-0.03,0.037C2.139,8.453,2.125,8.471,2.115,8.488C2.107,8.501,2.099,8.514,2.09,8.526 C2.079,8.548,2.069,8.565,2.06,8.585C2.054,8.6,2.047,8.613,2.04,8.626C2.032,8.648,2.025,8.67,2.019,8.69 c-0.005,0.013-0.01,0.027-0.013,0.042C1.999,8.755,1.995,8.778,1.99,8.803C1.989,8.817,1.985,8.828,1.984,8.84 C1.978,8.879,1.975,8.915,1.975,8.954v6.093c0,0.037,0.003,0.075,0.008,0.112c0.002,0.012,0.005,0.025,0.007,0.038 c0.005,0.023,0.008,0.047,0.015,0.072c0.003,0.015,0.008,0.028,0.013,0.04c0.007,0.022,0.013,0.042,0.022,0.063 c0.007,0.015,0.013,0.028,0.02,0.04c0.008,0.02,0.018,0.038,0.03,0.058c0.007,0.013,0.015,0.027,0.025,0.038 c0.012,0.018,0.023,0.035,0.035,0.052c0.01,0.013,0.02,0.025,0.03,0.037c0.013,0.015,0.028,0.032,0.042,0.045 c0.012,0.012,0.023,0.023,0.035,0.035c0.015,0.013,0.032,0.028,0.048,0.04l0.038,0.03c0.005,0.003,0.01,0.007,0.013,0.01 l9.163,6.095C11.668,21.953,11.833,22,12,22c0.167,0,0.332-0.047,0.478-0.144l9.163-6.095l0.015-0.01 c0.013-0.01,0.027-0.02,0.037-0.03c0.018-0.013,0.035-0.028,0.048-0.04c0.013-0.012,0.025-0.023,0.035-0.035 c0.017-0.015,0.03-0.032,0.043-0.045c0.01-0.013,0.02-0.025,0.03-0.037c0.013-0.018,0.025-0.035,0.035-0.052 c0.008-0.013,0.018-0.027,0.025-0.038c0.012-0.02,0.022-0.038,0.03-0.058c0.007-0.013,0.013-0.027,0.02-0.04 c0.008-0.022,0.015-0.042,0.023-0.063c0.003-0.013,0.01-0.027,0.013-0.04c0.007-0.025,0.01-0.048,0.015-0.072 c0.002-0.013,0.005-0.027,0.007-0.037c0.003-0.042,0.007-0.079,0.007-0.117V8.954C22.025,8.915,22.022,8.879,22.016,8.84z M12.862,4.464l6.751,4.49l-3.016,2.013l-3.735-2.492V4.464z M11.138,4.464v4.009l-3.735,2.494L4.389,8.954L11.138,4.464z M3.699,10.562L5.853,12l-2.155,1.438V10.562z M11.138,19.536l-6.749-4.491l3.015-2.011l3.735,2.492V19.536z M12,14.035L8.953,12 L12,9.966L15.047,12L12,14.035z M12.862,19.536v-4.009l3.735-2.492l3.016,2.011L12.862,19.536z M20.303,13.438L18.147,12 l2.156-1.438L20.303,13.438z"></path></svg>',
		'deviantart'      => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M 18.19 5.636 18.19 2 18.188 2 14.553 2 14.19 2.366 12.474 5.636 11.935 6 5.81 6 5.81 10.994 9.177 10.994 9.477 11.357 5.81 18.363 5.81 22 5.811 22 9.447 22 9.81 21.634 11.526 18.364 12.065 18 18.19 18 18.19 13.006 14.823 13.006 14.523 12.641 18.19 5.636z"></path></svg>',
		'dribbble'        => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 8C119.252 8 8 119.252 8 256s111.252 248 248 248 248-111.252 248-248S392.748 8 256 8zm163.97 114.366c29.503 36.046 47.369 81.957 47.835 131.955-6.984-1.477-77.018-15.682-147.502-6.818-5.752-14.041-11.181-26.393-18.617-41.614 78.321-31.977 113.818-77.482 118.284-83.523zM396.421 97.87c-3.81 5.427-35.697 48.286-111.021 76.519-34.712-63.776-73.185-116.168-79.04-124.008 67.176-16.193 137.966 1.27 190.061 47.489zm-230.48-33.25c5.585 7.659 43.438 60.116 78.537 122.509-99.087 26.313-186.36 25.934-195.834 25.809C62.38 147.205 106.678 92.573 165.941 64.62zM44.17 256.323c0-2.166.043-4.322.108-6.473 9.268.19 111.92 1.513 217.706-30.146 6.064 11.868 11.857 23.915 17.174 35.949-76.599 21.575-146.194 83.527-180.531 142.306C64.794 360.405 44.17 310.73 44.17 256.323zm81.807 167.113c22.127-45.233 82.178-103.622 167.579-132.756 29.74 77.283 42.039 142.053 45.189 160.638-68.112 29.013-150.015 21.053-212.768-27.882zm248.38 8.489c-2.171-12.886-13.446-74.897-41.152-151.033 66.38-10.626 124.7 6.768 131.947 9.055-9.442 58.941-43.273 109.844-90.795 141.978z"/></svg>',
		'dropbox'         => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M12,6.134L6.069,9.797L2,6.54l5.883-3.843L12,6.134z M2,13.054l5.883,3.843L12,13.459L6.069,9.797L2,13.054z M12,13.459 l4.116,3.439L22,13.054l-4.069-3.257L12,13.459z M22,6.54l-5.884-3.843L12,6.134l5.931,3.663L22,6.54z M12.011,14.2l-4.129,3.426 l-1.767-1.153v1.291l5.896,3.539l5.897-3.539v-1.291l-1.769,1.153L12.011,14.2z"></path></svg>',
		'digg'         	  => '<svg viewBox="0 0 32 32"><path d="M5.125 10.75h-5.125v10.938h8.313v-15.688h-3.188v4.75zM5.125 19.125h-1.938v-5.813h1.938v5.813zM23.688 10.75v10.938h5.125v1.75h-5.125v2.563h8.313v-15.25h-8.313zM28.813 19.125h-1.938v-5.813h1.938v5.813zM14.063 21.688h5.125v1.75h-5.125v2.563h8.313v-15.25h-8.313v10.938zM17.25 13.313h1.938v5.813h-1.938v-5.813zM9.563 6h3.25v3.188h-3.25v-3.188zM9.563 10.75h3.25v10.938h-3.25v-10.938z"></path></svg>',
		'etsy'            => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M9.16033,4.038c0-.27174.02717-.43478.48913-.43478h6.22283c1.087,0,1.68478.92391,2.11957,2.663l.35326,1.38587h1.05978C19.59511,3.712,19.75815,2,19.75815,2s-2.663.29891-4.23913.29891h-7.962L3.29076,2.163v1.1413L4.731,3.57609c1.00543.19022,1.25.40761,1.33152,1.33152,0,0,.08152,2.71739.08152,7.20109s-.08152,7.17391-.08152,7.17391c0,.81522-.32609,1.11413-1.33152,1.30435l-1.44022.27174V22l4.2663-.13587h7.11957c1.60326,0,5.32609.13587,5.32609.13587.08152-.97826.625-5.40761.70652-5.89674H19.7038L18.644,18.52174c-.84239,1.90217-2.06522,2.038-3.42391,2.038H11.1712c-1.3587,0-2.01087-.54348-2.01087-1.712V12.65217s3.0163,0,3.99457.08152c.76087.05435,1.22283.27174,1.46739,1.33152l.32609,1.413h1.16848l-.08152-3.55978.163-3.587H15.02989l-.38043,1.57609c-.24457,1.03261-.40761,1.22283-1.46739,1.33152-1.38587.13587-4.02174.1087-4.02174.1087Z"></path></svg>',
		'facebook-f'      => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M504 256C504 119 393 8 256 8S8 119 8 256c0 123.78 90.69 226.38 209.25 245V327.69h-63V256h63v-54.64c0-62.15 37-96.48 93.67-96.48 27.14 0 55.52 4.84 55.52 4.84v61h-31.28c-30.8 0-40.41 19.12-40.41 38.73V256h68.78l-11 71.69h-57.78V501C413.31 482.38 504 379.78 504 256z"/></svg>',
		'facebook'        => '<svg viewBox="0 0 17 32"><path d="M4.813 32v-14.313h-4.813v-5.688h4.813v-4.5q0-3.563 2-5.531t5.313-1.969q2.688 0 4.375 0.25v5.063h-3q-1.688 0-2.313 0.75-0.5 0.625-0.5 2v3.938h5.313l-0.75 5.688h-4.563v14.313h-5.875z"></path></svg>',
		'facebook-square' => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M21 2.672v18.656q0 0.469 -0.329 0.821t-0.844 0.352h-5.344v-8.156h2.719l0.422 -3.141h-3.141v-2.016q0 -0.797 0.281 -1.125 0.375 -0.422 1.266 -0.422h1.688v-2.86q-0.985 -0.094 -2.438 -0.094 -1.829 0 -2.954 1.079t-1.125 3.094v2.344h-2.719v3.141h2.719v8.156h-10.031q-0.516 0 -0.844 -0.352t-0.329 -0.821v-18.656q0 -0.516 0.329 -0.844t0.844 -0.329h18.656q0.469 0 0.821 0.329t0.352 0.844z"/></svg>',
		'feed'            => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M2,8.667V12c5.515,0,10,4.485,10,10h3.333C15.333,14.637,9.363,8.667,2,8.667z M2,2v3.333 c9.19,0,16.667,7.477,16.667,16.667H22C22,10.955,13.045,2,2,2z M4.5,17C3.118,17,2,18.12,2,19.5S3.118,22,4.5,22S7,20.88,7,19.5 S5.882,17,4.5,17z"></path></svg>',
		'flickr'          => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M6.5,7c-2.75,0-5,2.25-5,5s2.25,5,5,5s5-2.25,5-5S9.25,7,6.5,7z M17.5,7c-2.75,0-5,2.25-5,5s2.25,5,5,5s5-2.25,5-5 S20.25,7,17.5,7z"></path></svg>',
		'foursquare'      => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M17.573,2c0,0-9.197,0-10.668,0S5,3.107,5,3.805s0,16.948,0,16.948c0,0.785,0.422,1.077,0.66,1.172 c0.238,0.097,0.892,0.177,1.285-0.275c0,0,5.035-5.843,5.122-5.93c0.132-0.132,0.132-0.132,0.262-0.132h3.26 c1.368,0,1.588-0.977,1.732-1.552c0.078-0.318,0.692-3.428,1.225-6.122l0.675-3.368C19.56,2.893,19.14,2,17.573,2z M16.495,7.22 c-0.053,0.252-0.372,0.518-0.665,0.518c-0.293,0-4.157,0-4.157,0c-0.467,0-0.802,0.318-0.802,0.787v0.508 c0,0.467,0.337,0.798,0.805,0.798c0,0,3.197,0,3.528,0s0.655,0.362,0.583,0.715c-0.072,0.353-0.407,2.102-0.448,2.295 c-0.04,0.193-0.262,0.523-0.655,0.523c-0.33,0-2.88,0-2.88,0c-0.523,0-0.683,0.068-1.033,0.503 c-0.35,0.437-3.505,4.223-3.505,4.223c-0.032,0.035-0.063,0.027-0.063-0.015V4.852c0-0.298,0.26-0.648,0.648-0.648 c0,0,8.228,0,8.562,0c0.315,0,0.61,0.297,0.528,0.683L16.495,7.22z"></path></svg>',
		'goodreads'       => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M17.3,17.5c-0.2,0.8-0.5,1.4-1,1.9c-0.4,0.5-1,0.9-1.7,1.2C13.9,20.9,13.1,21,12,21c-0.6,0-1.3-0.1-1.9-0.2 c-0.6-0.1-1.1-0.4-1.6-0.7c-0.5-0.3-0.9-0.7-1.2-1.2c-0.3-0.5-0.5-1.1-0.5-1.7h1.5c0.1,0.5,0.2,0.9,0.5,1.2 c0.2,0.3,0.5,0.6,0.9,0.8c0.3,0.2,0.7,0.3,1.1,0.4c0.4,0.1,0.8,0.1,1.2,0.1c1.4,0,2.5-0.4,3.1-1.2c0.6-0.8,1-2,1-3.5v-1.7h0 c-0.4,0.8-0.9,1.4-1.6,1.9c-0.7,0.5-1.5,0.7-2.4,0.7c-1,0-1.9-0.2-2.6-0.5C8.7,15,8.1,14.5,7.7,14c-0.5-0.6-0.8-1.3-1-2.1 c-0.2-0.8-0.3-1.6-0.3-2.5c0-0.9,0.1-1.7,0.4-2.5c0.3-0.8,0.6-1.5,1.1-2c0.5-0.6,1.1-1,1.8-1.4C10.3,3.2,11.1,3,12,3 c0.5,0,0.9,0.1,1.3,0.2c0.4,0.1,0.8,0.3,1.1,0.5c0.3,0.2,0.6,0.5,0.9,0.8c0.3,0.3,0.5,0.6,0.6,1h0V3.4h1.5V15 C17.6,15.9,17.5,16.7,17.3,17.5z M13.8,14.1c0.5-0.3,0.9-0.7,1.3-1.1c0.3-0.5,0.6-1,0.8-1.6c0.2-0.6,0.3-1.2,0.3-1.9 c0-0.6-0.1-1.2-0.2-1.9c-0.1-0.6-0.4-1.2-0.7-1.7c-0.3-0.5-0.7-0.9-1.3-1.2c-0.5-0.3-1.1-0.5-1.9-0.5s-1.4,0.2-1.9,0.5 c-0.5,0.3-1,0.7-1.3,1.2C8.5,6.4,8.3,7,8.1,7.6C8,8.2,7.9,8.9,7.9,9.5c0,0.6,0.1,1.3,0.2,1.9C8.3,12,8.6,12.5,8.9,13 c0.3,0.5,0.8,0.8,1.3,1.1c0.5,0.3,1.1,0.4,1.9,0.4C12.7,14.5,13.3,14.4,13.8,14.1z"></path></svg>',
		'google'          => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M12.02,10.18v3.72v0.01h5.51c-0.26,1.57-1.67,4.22-5.5,4.22c-3.31,0-6.01-2.75-6.01-6.12s2.7-6.12,6.01-6.12 c1.87,0,3.13,0.8,3.85,1.48l2.84-2.76C16.99,2.99,14.73,2,12.03,2c-5.52,0-10,4.48-10,10s4.48,10,10,10c5.77,0,9.6-4.06,9.6-9.77 c0-0.83-0.11-1.42-0.25-2.05H12.02z"></path></svg>',
		'google-plus' 	  => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path d="M386.061 228.496c1.834 9.692 3.143 19.384 3.143 31.956C389.204 370.205 315.599 448 204.8 448c-106.084 0-192-85.915-192-192s85.916-192 192-192c51.864 0 95.083 18.859 128.611 50.292l-52.126 50.03c-14.145-13.621-39.028-29.599-76.485-29.599-65.484 0-118.92 54.221-118.92 121.277 0 67.056 53.436 121.277 118.92 121.277 75.961 0 104.513-54.745 108.965-82.773H204.8v-66.009h181.261zm185.406 6.437V179.2h-56.001v55.733h-55.733v56.001h55.733v55.733h56.001v-55.733H627.2v-56.001h-55.733z"/></svg>',
		'github'          => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512"><path d="M165.9 397.4c0 2-2.3 3.6-5.2 3.6-3.3.3-5.6-1.3-5.6-3.6 0-2 2.3-3.6 5.2-3.6 3-.3 5.6 1.3 5.6 3.6zm-31.1-4.5c-.7 2 1.3 4.3 4.3 4.9 2.6 1 5.6 0 6.2-2s-1.3-4.3-4.3-5.2c-2.6-.7-5.5.3-6.2 2.3zm44.2-1.7c-2.9.7-4.9 2.6-4.6 4.9.3 2 2.9 3.3 5.9 2.6 2.9-.7 4.9-2.6 4.6-4.6-.3-1.9-3-3.2-5.9-2.9zM244.8 8C106.1 8 0 113.3 0 252c0 110.9 69.8 205.8 169.5 239.2 12.8 2.3 17.3-5.6 17.3-12.1 0-6.2-.3-40.4-.3-61.4 0 0-70 15-84.7-29.8 0 0-11.4-29.1-27.8-36.6 0 0-22.9-15.7 1.6-15.4 0 0 24.9 2 38.6 25.8 21.9 38.6 58.6 27.5 72.9 20.9 2.3-16 8.8-27.1 16-33.7-55.9-6.2-112.3-14.3-112.3-110.5 0-27.5 7.6-41.3 23.6-58.9-2.6-6.5-11.1-33.3 2.6-67.9 20.9-6.5 69 27 69 27 20-5.6 41.5-8.5 62.8-8.5s42.8 2.9 62.8 8.5c0 0 48.1-33.6 69-27 13.7 34.7 5.2 61.4 2.6 67.9 16 17.7 25.8 31.5 25.8 58.9 0 96.5-58.9 104.2-114.8 110.5 9.2 7.9 17 22.9 17 46.4 0 33.7-.3 75.4-.3 83.6 0 6.5 4.6 14.4 17.3 12.1C428.2 457.8 496 362.9 496 252 496 113.3 383.5 8 244.8 8zM97.2 352.9c-1.3 1-1 3.3.7 5.2 1.6 1.6 3.9 2.3 5.2 1 1.3-1 1-3.3-.7-5.2-1.6-1.6-3.9-2.3-5.2-1zm-10.8-8.1c-.7 1.3.3 2.9 2.3 3.9 1.6 1 3.6.7 4.3-.7.7-1.3-.3-2.9-2.3-3.9-2-.6-3.6-.3-4.3.7zm32.4 35.6c-1.6 1.3-1 4.3 1.3 6.2 2.3 2.3 5.2 2.6 6.5 1 1.3-1.3.7-4.3-1.3-6.2-2.2-2.3-5.2-2.6-6.5-1zm-11.4-14.7c-1.6 1-1.6 3.6 0 5.9 1.6 2.3 4.3 3.3 5.6 2.3 1.6-1.3 1.6-3.9 0-6.2-1.4-2.3-4-3.3-5.6-2z"/></svg>',
		'instagram'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z"/></svg>',
		'lastfm'          => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M10.5002,0 C4.7006,0 0,4.70109753 0,10.4998496 C0,16.2989526 4.7006,21 10.5002,21 C16.299,21 21,16.2989526 21,10.4998496 C21,4.70109753 16.299,0 10.5002,0 Z M14.69735,14.7204413 C13.3164,14.7151781 12.4346,14.0870017 11.83445,12.6859357 L11.6816001,12.3451305 L10.35405,9.31011397 C9.92709997,8.26875064 8.85260001,7.57120012 7.68010001,7.57120012 C6.06945001,7.57120012 4.75925001,8.88509738 4.75925001,10.5009524 C4.75925001,12.1164565 6.06945001,13.4303036 7.68010001,13.4303036 C8.77200001,13.4303036 9.76514999,12.827541 10.2719501,11.8567047 C10.2893,11.8235214 10.3239,11.8019673 10.36305,11.8038219 C10.4007,11.8053759 10.43535,11.8287847 10.4504,11.8631709 L10.98655,13.1045863 C11.0016,13.1389726 10.9956,13.17782 10.97225,13.2068931 C10.1605001,14.1995341 8.96020001,14.7683115 7.68010001,14.7683115 C5.33305,14.7683115 3.42340001,12.8535563 3.42340001,10.5009524 C3.42340001,8.14679459 5.33300001,6.23203946 7.68010001,6.23203946 C9.45720002,6.23203946 10.8909,7.19074535 11.6138,8.86359341 C11.6205501,8.88018505 12.3412,10.5707777 12.97445,12.0190621 C13.34865,12.8739575 13.64615,13.3959676 14.6288,13.4291508 C15.5663001,13.4612814 16.25375,12.9121534 16.25375,12.1484869 C16.25375,11.4691321 15.8320501,11.3003585 14.8803,10.98216 C13.2365,10.4397989 12.34495,9.88605929 12.34495,8.51817658 C12.34495,7.1809207 13.26665,6.31615054 14.692,6.31615054 C15.62875,6.31615054 16.3155,6.7286858 16.79215,7.5768142 C16.80495,7.60062396 16.8079001,7.62814302 16.8004001,7.65420843 C16.7929,7.68027384 16.7748,7.70212868 16.7507001,7.713808 L15.86145,8.16900031 C15.8178001,8.19200805 15.7643,8.17807308 15.73565,8.13847371 C15.43295,7.71345711 15.0956,7.52513451 14.6423,7.52513451 C14.05125,7.52513451 13.6220001,7.92899802 13.6220001,8.48649708 C13.6220001,9.17382194 14.1529001,9.34144259 15.0339,9.61923972 C15.14915,9.65578139 15.26955,9.69397731 15.39385,9.73432853 C16.7763,10.1865133 17.57675,10.7311301 17.57675,12.1836251 C17.57685,13.629654 16.3389,14.7204413 14.69735,14.7204413 Z"></path></svg>',
		'linkedin'        => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M100.28 448H7.4V148.9h92.88zM53.79 108.1C24.09 108.1 0 83.5 0 53.8a53.79 53.79 0 0 1 107.58 0c0 29.7-24.1 54.3-53.79 54.3zM447.9 448h-92.68V302.4c0-34.7-.7-79.2-48.29-79.2-48.29 0-55.69 37.7-55.69 76.7V448h-92.78V148.9h89.08v40.8h1.3c12.4-23.5 42.69-48.3 87.88-48.3 94 0 111.28 61.9 111.28 142.3V448z"/></svg>',
		'email'           => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M20,4H4C2.895,4,2,4.895,2,6v12c0,1.105,0.895,2,2,2h16c1.105,0,2-0.895,2-2V6C22,4.895,21.105,4,20,4z M20,8.236l-8,4.882 L4,8.236V6h16V8.236z"></path></svg>',
		'mastodon'        => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M23.193 7.879c0-5.206-3.411-6.732-3.411-6.732C18.062.357 15.108.025 12.041 0h-.076c-3.068.025-6.02.357-7.74 1.147 0 0-3.411 1.526-3.411 6.732 0 1.192-.023 2.618.015 4.129.124 5.092.934 10.109 5.641 11.355 2.17.574 4.034.695 5.535.612 2.722-.15 4.25-.972 4.25-.972l-.09-1.975s-1.945.613-4.129.539c-2.165-.074-4.449-.233-4.799-2.891a5.499 5.499 0 0 1-.048-.745s2.125.52 4.817.643c1.646.075 3.19-.097 4.758-.283 3.007-.359 5.625-2.212 5.954-3.905.517-2.665.475-6.507.475-6.507zm-4.024 6.709h-2.497V8.469c0-1.29-.543-1.944-1.628-1.944-1.2 0-1.802.776-1.802 2.312v3.349h-2.483v-3.35c0-1.536-.602-2.312-1.802-2.312-1.085 0-1.628.655-1.628 1.944v6.119H4.832V8.284c0-1.289.328-2.313.987-3.07.68-.758 1.569-1.146 2.674-1.146 1.278 0 2.246.491 2.886 1.474L12 6.585l.622-1.043c.64-.983 1.608-1.474 2.886-1.474 1.104 0 1.994.388 2.674 1.146.658.757.986 1.781.986 3.07v6.304z"/></svg>',
		'medium'          => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M20.962,7.257l-5.457,8.867l-3.923-6.375l3.126-5.08c0.112-0.182,0.319-0.286,0.527-0.286c0.05,0,0.1,0.008,0.149,0.02 c0.039,0.01,0.078,0.023,0.114,0.041l5.43,2.715l0.006,0.003c0.004,0.002,0.007,0.006,0.011,0.008 C20.971,7.191,20.98,7.227,20.962,7.257z M9.86,8.592v5.783l5.14,2.57L9.86,8.592z M15.772,17.331l4.231,2.115 C20.554,19.721,21,19.529,21,19.016V8.835L15.772,17.331z M8.968,7.178L3.665,4.527C3.569,4.479,3.478,4.456,3.395,4.456 C3.163,4.456,3,4.636,3,4.938v11.45c0,0.306,0.224,0.669,0.498,0.806l4.671,2.335c0.12,0.06,0.234,0.088,0.337,0.088 c0.29,0,0.494-0.225,0.494-0.602V7.231C9,7.208,8.988,7.188,8.968,7.178z"></path></svg>',
		'meetup'          => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M19.24775,14.722a3.57032,3.57032,0,0,1-2.94457,3.52073,3.61886,3.61886,0,0,1-.64652.05634c-.07314-.0008-.10187.02846-.12507.09547A2.38881,2.38881,0,0,1,13.49453,20.094a2.33092,2.33092,0,0,1-1.827-.50716.13635.13635,0,0,0-.19878-.00408,3.191,3.191,0,0,1-2.104.60248,3.26309,3.26309,0,0,1-3.00324-2.71993,2.19076,2.19076,0,0,1-.03512-.30865c-.00156-.08579-.03413-.1189-.11608-.13493a2.86421,2.86421,0,0,1-1.23189-.56111,2.945,2.945,0,0,1-1.166-2.05749,2.97484,2.97484,0,0,1,.87524-2.50774.112.112,0,0,0,.02091-.16107,2.7213,2.7213,0,0,1-.36648-1.48A2.81256,2.81256,0,0,1,6.57673,7.58838a.35764.35764,0,0,0,.28869-.22819,4.2208,4.2208,0,0,1,6.02892-1.90111.25161.25161,0,0,0,.22023.0243,3.65608,3.65608,0,0,1,3.76031.90678A3.57244,3.57244,0,0,1,17.95918,8.626a2.97339,2.97339,0,0,1,.01829.57356.10637.10637,0,0,0,.0853.12792,1.97669,1.97669,0,0,1,1.27939,1.33733,2.00266,2.00266,0,0,1-.57112,2.12652c-.05284.05166-.04168.08328-.01173.13489A3.51189,3.51189,0,0,1,19.24775,14.722Zm-6.35959-.27836a1.6984,1.6984,0,0,0,1.14556,1.61113,3.82039,3.82039,0,0,0,1.036.17935,1.46888,1.46888,0,0,0,.73509-.12255.44082.44082,0,0,0,.26057-.44274.45312.45312,0,0,0-.29211-.43375.97191.97191,0,0,0-.20678-.063c-.21326-.03806-.42754-.0701-.63973-.11215a.54787.54787,0,0,1-.50172-.60926,2.75864,2.75864,0,0,1,.1773-.901c.1763-.535.414-1.045.64183-1.55913A12.686,12.686,0,0,0,15.85,10.47863a1.58461,1.58461,0,0,0,.04861-.87208,1.04531,1.04531,0,0,0-.85432-.83981,1.60658,1.60658,0,0,0-1.23654.16594.27593.27593,0,0,1-.36286-.03413c-.085-.0747-.16594-.15379-.24918-.23055a.98682.98682,0,0,0-1.33577-.04933,6.1468,6.1468,0,0,1-.4989.41615.47762.47762,0,0,1-.51535.03566c-.17448-.09307-.35512-.175-.53531-.25665a1.74949,1.74949,0,0,0-.56476-.2016,1.69943,1.69943,0,0,0-1.61654.91787,8.05815,8.05815,0,0,0-.32952.80126c-.45471,1.2557-.82507,2.53825-1.20838,3.81639a1.24151,1.24151,0,0,0,.51532,1.44389,1.42659,1.42659,0,0,0,1.22008.17166,1.09728,1.09728,0,0,0,.66994-.69764c.44145-1.04111.839-2.09989,1.25981-3.14926.11581-.28876.22792-.57874.35078-.86438a.44548.44548,0,0,1,.69189-.19539.50521.50521,0,0,1,.15044.43836,1.75625,1.75625,0,0,1-.14731.50453c-.27379.69219-.55265,1.38236-.82766,2.074a2.0836,2.0836,0,0,0-.14038.42876.50719.50719,0,0,0,.27082.57722.87236.87236,0,0,0,.66145.02739.99137.99137,0,0,0,.53406-.532q.61571-1.20914,1.228-2.42031.28423-.55863.57585-1.1133a.87189.87189,0,0,1,.29055-.35253.34987.34987,0,0,1,.37634-.01265.30291.30291,0,0,1,.12434.31459.56716.56716,0,0,1-.04655.1915c-.05318.12739-.10286.25669-.16183.38156-.34118.71775-.68754,1.43273-1.02568,2.152A2.00213,2.00213,0,0,0,12.88816,14.44366Zm4.78568,5.28972a.88573.88573,0,0,0-1.77139.00465.8857.8857,0,0,0,1.77139-.00465Zm-14.83838-7.296a.84329.84329,0,1,0,.00827-1.68655.8433.8433,0,0,0-.00827,1.68655Zm10.366-9.43673a.83506.83506,0,1,0-.0091,1.67.83505.83505,0,0,0,.0091-1.67Zm6.85014,5.22a.71651.71651,0,0,0-1.433.0093.71656.71656,0,0,0,1.433-.0093ZM5.37528,6.17908A.63823.63823,0,1,0,6.015,5.54483.62292.62292,0,0,0,5.37528,6.17908Zm6.68214,14.80843a.54949.54949,0,1,0-.55052.541A.54556.54556,0,0,0,12.05742,20.98752Zm8.53235-8.49689a.54777.54777,0,0,0-.54027.54023.53327.53327,0,0,0,.532.52293.51548.51548,0,0,0,.53272-.5237A.53187.53187,0,0,0,20.58977,12.49063ZM7.82846,2.4715a.44927.44927,0,1,0,.44484.44766A.43821.43821,0,0,0,7.82846,2.4715Zm13.775,7.60492a.41186.41186,0,0,0-.40065.39623.40178.40178,0,0,0,.40168.40168A.38994.38994,0,0,0,22,10.48172.39946.39946,0,0,0,21.60349,10.07642ZM5.79193,17.96207a.40469.40469,0,0,0-.397-.39646.399.399,0,0,0-.396.405.39234.39234,0,0,0,.39939.389A.39857.39857,0,0,0,5.79193,17.96207Z"></path></svg>',
		'pinterest'       => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 384 512"><path d="M204 6.5C101.4 6.5 0 74.9 0 185.6 0 256 39.6 296 63.6 296c9.9 0 15.6-27.6 15.6-35.4 0-9.3-23.7-29.1-23.7-67.8 0-80.4 61.2-137.4 140.4-137.4 68.1 0 118.5 38.7 118.5 109.8 0 53.1-21.3 152.7-90.3 152.7-24.9 0-46.2-18-46.2-43.8 0-37.8 26.4-74.4 26.4-113.4 0-66.2-93.9-54.2-93.9 25.8 0 16.8 2.1 35.4 9.6 50.7-13.8 59.4-42 147.9-42 209.1 0 18.9 2.7 37.5 4.5 56.4 3.4 3.8 1.7 3.4 6.9 1.5 50.4-69 48.6-82.5 71.4-172.8 12.3 23.4 44.1 36 69.3 36 106.2 0 153.9-103.5 153.9-196.8C384 71.3 298.2 6.5 204 6.5z"/></svg>',
		'pocket'          => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M21.927,4.194C21.667,3.48,20.982,3,20.222,3h-0.01h-1.721H3.839C3.092,3,2.411,3.47,2.145,4.17 C2.066,4.378,2.026,4.594,2.026,4.814v6.035l0.069,1.2c0.29,2.73,1.707,5.115,3.899,6.778c0.039,0.03,0.079,0.059,0.119,0.089 l0.025,0.018c1.175,0.859,2.491,1.441,3.91,1.727c0.655,0.132,1.325,0.2,1.991,0.2c0.615,0,1.232-0.057,1.839-0.17 c0.073-0.014,0.145-0.028,0.219-0.044c0.02-0.004,0.042-0.012,0.064-0.023c1.359-0.297,2.621-0.864,3.753-1.691l0.025-0.018 c0.04-0.029,0.08-0.058,0.119-0.089c2.192-1.664,3.609-4.049,3.898-6.778l0.069-1.2V4.814C22.026,4.605,22,4.398,21.927,4.194z M17.692,10.481l-4.704,4.512c-0.266,0.254-0.608,0.382-0.949,0.382c-0.342,0-0.684-0.128-0.949-0.382l-4.705-4.512 C5.838,9.957,5.82,9.089,6.344,8.542c0.524-0.547,1.392-0.565,1.939-0.04l3.756,3.601l3.755-3.601 c0.547-0.524,1.415-0.506,1.939,0.04C18.256,9.089,18.238,9.956,17.692,10.481z"></path></svg>',
		'reddit'          => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M22,11.816c0-1.256-1.021-2.277-2.277-2.277c-0.593,0-1.122,0.24-1.526,0.614c-1.481-0.965-3.455-1.594-5.647-1.69 l1.171-3.702l3.18,0.748c0.008,1.028,0.846,1.862,1.876,1.862c1.035,0,1.877-0.842,1.877-1.878c0-1.035-0.842-1.877-1.877-1.877 c-0.769,0-1.431,0.466-1.72,1.13l-3.508-0.826c-0.203-0.047-0.399,0.067-0.46,0.261l-1.35,4.268 c-2.316,0.038-4.411,0.67-5.97,1.671C5.368,9.765,4.853,9.539,4.277,9.539C3.021,9.539,2,10.56,2,11.816 c0,0.814,0.433,1.523,1.078,1.925c-0.037,0.221-0.061,0.444-0.061,0.672c0,3.292,4.011,5.97,8.941,5.97s8.941-2.678,8.941-5.97 c0-0.214-0.02-0.424-0.053-0.632C21.533,13.39,22,12.661,22,11.816z M18.776,4.394c0.606,0,1.1,0.493,1.1,1.1s-0.493,1.1-1.1,1.1 s-1.1-0.494-1.1-1.1S18.169,4.394,18.776,4.394z M2.777,11.816c0-0.827,0.672-1.5,1.499-1.5c0.313,0,0.598,0.103,0.838,0.269 c-0.851,0.676-1.477,1.479-1.812,2.36C2.983,12.672,2.777,12.27,2.777,11.816z M11.959,19.606c-4.501,0-8.164-2.329-8.164-5.193 S7.457,9.22,11.959,9.22s8.164,2.329,8.164,5.193S16.46,19.606,11.959,19.606z M20.636,13.001c-0.326-0.89-0.948-1.701-1.797-2.384 c0.248-0.186,0.55-0.301,0.883-0.301c0.827,0,1.5,0.673,1.5,1.5C21.223,12.299,20.992,12.727,20.636,13.001z M8.996,14.704 c-0.76,0-1.397-0.616-1.397-1.376c0-0.76,0.637-1.397,1.397-1.397c0.76,0,1.376,0.637,1.376,1.397 C10.372,14.088,9.756,14.704,8.996,14.704z M16.401,13.328c0,0.76-0.616,1.376-1.376,1.376c-0.76,0-1.399-0.616-1.399-1.376 c0-0.76,0.639-1.397,1.399-1.397C15.785,11.931,16.401,12.568,16.401,13.328z M15.229,16.708c0.152,0.152,0.152,0.398,0,0.55 c-0.674,0.674-1.727,1.002-3.219,1.002c-0.004,0-0.007-0.002-0.011-0.002c-0.004,0-0.007,0.002-0.011,0.002 c-1.492,0-2.544-0.328-3.218-1.002c-0.152-0.152-0.152-0.398,0-0.55c0.152-0.152,0.399-0.151,0.55,0 c0.521,0.521,1.394,0.775,2.669,0.775c0.004,0,0.007,0.002,0.011,0.002c0.004,0,0.007-0.002,0.011-0.002 c1.275,0,2.148-0.253,2.669-0.775C14.831,16.556,15.078,16.556,15.229,16.708z"></path></svg>',
		'skype'           => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M10.113,2.699c0.033-0.006,0.067-0.013,0.1-0.02c0.033,0.017,0.066,0.033,0.098,0.051L10.113,2.699z M2.72,10.223 c-0.006,0.034-0.011,0.069-0.017,0.103c0.018,0.032,0.033,0.064,0.051,0.095L2.72,10.223z M21.275,13.771 c0.007-0.035,0.011-0.071,0.018-0.106c-0.018-0.031-0.033-0.064-0.052-0.095L21.275,13.771z M13.563,21.199 c0.032,0.019,0.065,0.035,0.096,0.053c0.036-0.006,0.071-0.011,0.105-0.017L13.563,21.199z M22,16.386 c0,1.494-0.581,2.898-1.637,3.953c-1.056,1.057-2.459,1.637-3.953,1.637c-0.967,0-1.914-0.251-2.75-0.725 c0.036-0.006,0.071-0.011,0.105-0.017l-0.202-0.035c0.032,0.019,0.065,0.035,0.096,0.053c-0.543,0.096-1.099,0.147-1.654,0.147 c-1.275,0-2.512-0.25-3.676-0.743c-1.125-0.474-2.135-1.156-3.002-2.023c-0.867-0.867-1.548-1.877-2.023-3.002 c-0.493-1.164-0.743-2.401-0.743-3.676c0-0.546,0.049-1.093,0.142-1.628c0.018,0.032,0.033,0.064,0.051,0.095L2.72,10.223 c-0.006,0.034-0.011,0.069-0.017,0.103C2.244,9.5,2,8.566,2,7.615c0-1.493,0.582-2.898,1.637-3.953 c1.056-1.056,2.46-1.638,3.953-1.638c0.915,0,1.818,0.228,2.622,0.655c-0.033,0.007-0.067,0.013-0.1,0.02l0.199,0.031 c-0.032-0.018-0.066-0.034-0.098-0.051c0.002,0,0.003-0.001,0.004-0.001c0.586-0.112,1.187-0.169,1.788-0.169 c1.275,0,2.512,0.249,3.676,0.742c1.124,0.476,2.135,1.156,3.002,2.024c0.868,0.867,1.548,1.877,2.024,3.002 c0.493,1.164,0.743,2.401,0.743,3.676c0,0.575-0.054,1.15-0.157,1.712c-0.018-0.031-0.033-0.064-0.052-0.095l0.034,0.201 c0.007-0.035,0.011-0.071,0.018-0.106C21.754,14.494,22,15.432,22,16.386z M16.817,14.138c0-1.331-0.613-2.743-3.033-3.282 l-2.209-0.49c-0.84-0.192-1.807-0.444-1.807-1.237c0-0.794,0.679-1.348,1.903-1.348c2.468,0,2.243,1.696,3.468,1.696 c0.645,0,1.209-0.379,1.209-1.031c0-1.521-2.435-2.663-4.5-2.663c-2.242,0-4.63,0.952-4.63,3.488c0,1.221,0.436,2.521,2.839,3.123 l2.984,0.745c0.903,0.223,1.129,0.731,1.129,1.189c0,0.762-0.758,1.507-2.129,1.507c-2.679,0-2.307-2.062-3.743-2.062 c-0.645,0-1.113,0.444-1.113,1.078c0,1.236,1.501,2.886,4.856,2.886C15.236,17.737,16.817,16.199,16.817,14.138z"></path></svg>',
		'snapchat'        => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M12.065,2a5.526,5.526,0,0,1,3.132.892A5.854,5.854,0,0,1,17.326,5.4a5.821,5.821,0,0,1,.351,2.33q0,.612-.117,2.487a.809.809,0,0,0,.365.091,1.93,1.93,0,0,0,.664-.176,1.93,1.93,0,0,1,.664-.176,1.3,1.3,0,0,1,.729.234.7.7,0,0,1,.351.6.839.839,0,0,1-.41.7,2.732,2.732,0,0,1-.9.41,3.192,3.192,0,0,0-.9.378.728.728,0,0,0-.41.618,1.575,1.575,0,0,0,.156.56,6.9,6.9,0,0,0,1.334,1.953,5.6,5.6,0,0,0,1.881,1.315,5.875,5.875,0,0,0,1.042.3.42.42,0,0,1,.365.456q0,.911-2.852,1.341a1.379,1.379,0,0,0-.143.507,1.8,1.8,0,0,1-.182.605.451.451,0,0,1-.429.241,5.878,5.878,0,0,1-.807-.085,5.917,5.917,0,0,0-.833-.085,4.217,4.217,0,0,0-.807.065,2.42,2.42,0,0,0-.82.293,6.682,6.682,0,0,0-.755.5q-.351.267-.755.527a3.886,3.886,0,0,1-.989.436A4.471,4.471,0,0,1,11.831,22a4.307,4.307,0,0,1-1.256-.176,3.784,3.784,0,0,1-.976-.436q-.4-.26-.749-.527a6.682,6.682,0,0,0-.755-.5,2.422,2.422,0,0,0-.807-.293,4.432,4.432,0,0,0-.82-.065,5.089,5.089,0,0,0-.853.1,5,5,0,0,1-.762.1.474.474,0,0,1-.456-.241,1.819,1.819,0,0,1-.182-.618,1.411,1.411,0,0,0-.143-.521q-2.852-.429-2.852-1.341a.42.42,0,0,1,.365-.456,5.793,5.793,0,0,0,1.042-.3,5.524,5.524,0,0,0,1.881-1.315,6.789,6.789,0,0,0,1.334-1.953A1.575,1.575,0,0,0,6,12.9a.728.728,0,0,0-.41-.618,3.323,3.323,0,0,0-.9-.384,2.912,2.912,0,0,1-.9-.41.814.814,0,0,1-.41-.684.71.71,0,0,1,.338-.593,1.208,1.208,0,0,1,.716-.241,1.976,1.976,0,0,1,.625.169,2.008,2.008,0,0,0,.69.169.919.919,0,0,0,.416-.091q-.117-1.849-.117-2.474A5.861,5.861,0,0,1,6.385,5.4,5.516,5.516,0,0,1,8.625,2.819,7.075,7.075,0,0,1,12.062,2Z"></path></svg>',
		'soundcloud'      => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M8.9,16.1L9,14L8.9,9.5c0-0.1,0-0.1-0.1-0.1c0,0-0.1-0.1-0.1-0.1c-0.1,0-0.1,0-0.1,0.1c0,0-0.1,0.1-0.1,0.1L8.3,14l0.1,2.1 c0,0.1,0,0.1,0.1,0.1c0,0,0.1,0.1,0.1,0.1C8.8,16.3,8.9,16.3,8.9,16.1z M11.4,15.9l0.1-1.8L11.4,9c0-0.1,0-0.2-0.1-0.2 c0,0-0.1,0-0.1,0s-0.1,0-0.1,0c-0.1,0-0.1,0.1-0.1,0.2l0,0.1l-0.1,5c0,0,0,0.7,0.1,2v0c0,0.1,0,0.1,0.1,0.1c0.1,0.1,0.1,0.1,0.2,0.1 c0.1,0,0.1,0,0.2-0.1c0.1,0,0.1-0.1,0.1-0.2L11.4,15.9z M2.4,12.9L2.5,14l-0.2,1.1c0,0.1,0,0.1-0.1,0.1c0,0-0.1,0-0.1-0.1L2.1,14 l0.1-1.1C2.2,12.9,2.3,12.9,2.4,12.9C2.3,12.9,2.4,12.9,2.4,12.9z M3.1,12.2L3.3,14l-0.2,1.8c0,0.1,0,0.1-0.1,0.1 c-0.1,0-0.1,0-0.1-0.1L2.8,14L3,12.2C3,12.2,3,12.2,3.1,12.2C3.1,12.2,3.1,12.2,3.1,12.2z M3.9,11.9L4.1,14l-0.2,2.1 c0,0.1,0,0.1-0.1,0.1c-0.1,0-0.1,0-0.1-0.1L3.5,14l0.2-2.1c0-0.1,0-0.1,0.1-0.1C3.9,11.8,3.9,11.8,3.9,11.9z M4.7,11.9L4.9,14 l-0.2,2.1c0,0.1-0.1,0.1-0.1,0.1c-0.1,0-0.1,0-0.1-0.1L4.3,14l0.2-2.2c0-0.1,0-0.1,0.1-0.1C4.7,11.7,4.7,11.8,4.7,11.9z M5.6,12 l0.2,2l-0.2,2.1c0,0.1-0.1,0.1-0.1,0.1c0,0-0.1,0-0.1,0c0,0,0-0.1,0-0.1L5.1,14l0.2-2c0,0,0-0.1,0-0.1s0.1,0,0.1,0 C5.5,11.9,5.5,11.9,5.6,12L5.6,12z M6.4,10.7L6.6,14l-0.2,2.1c0,0,0,0.1,0,0.1c0,0-0.1,0-0.1,0c-0.1,0-0.1-0.1-0.2-0.2L5.9,14 l0.2-3.3c0-0.1,0.1-0.2,0.2-0.2c0,0,0.1,0,0.1,0C6.4,10.7,6.4,10.7,6.4,10.7z M7.2,10l0.2,4.1l-0.2,2.1c0,0,0,0.1,0,0.1 c0,0-0.1,0-0.1,0c-0.1,0-0.2-0.1-0.2-0.2l-0.1-2.1L6.8,10c0-0.1,0.1-0.2,0.2-0.2c0,0,0.1,0,0.1,0S7.2,9.9,7.2,10z M8,9.6L8.2,14 L8,16.1c0,0.1-0.1,0.2-0.2,0.2c-0.1,0-0.2-0.1-0.2-0.2L7.5,14l0.1-4.4c0-0.1,0-0.1,0.1-0.1c0,0,0.1-0.1,0.1-0.1c0.1,0,0.1,0,0.1,0.1 C8,9.6,8,9.6,8,9.6z M11.4,16.1L11.4,16.1L11.4,16.1z M9.7,9.6L9.8,14l-0.1,2.1c0,0.1,0,0.1-0.1,0.2s-0.1,0.1-0.2,0.1 c-0.1,0-0.1,0-0.1-0.1s-0.1-0.1-0.1-0.2L9.2,14l0.1-4.4c0-0.1,0-0.1,0.1-0.2s0.1-0.1,0.2-0.1c0.1,0,0.1,0,0.2,0.1S9.7,9.5,9.7,9.6 L9.7,9.6z M10.6,9.8l0.1,4.3l-0.1,2c0,0.1,0,0.1-0.1,0.2c0,0-0.1,0.1-0.2,0.1c-0.1,0-0.1,0-0.2-0.1c0,0-0.1-0.1-0.1-0.2L10,14 l0.1-4.3c0-0.1,0-0.1,0.1-0.2c0,0,0.1-0.1,0.2-0.1c0.1,0,0.1,0,0.2,0.1S10.6,9.7,10.6,9.8z M12.4,14l-0.1,2c0,0.1,0,0.1-0.1,0.2 c-0.1,0.1-0.1,0.1-0.2,0.1c-0.1,0-0.1,0-0.2-0.1c-0.1-0.1-0.1-0.1-0.1-0.2l-0.1-1l-0.1-1l0.1-5.5v0c0-0.1,0-0.2,0.1-0.2 c0.1,0,0.1-0.1,0.2-0.1c0,0,0.1,0,0.1,0c0.1,0,0.1,0.1,0.1,0.2L12.4,14z M22.1,13.9c0,0.7-0.2,1.3-0.7,1.7c-0.5,0.5-1.1,0.7-1.7,0.7 h-6.8c-0.1,0-0.1,0-0.2-0.1c-0.1-0.1-0.1-0.1-0.1-0.2V8.2c0-0.1,0.1-0.2,0.2-0.3c0.5-0.2,1-0.3,1.6-0.3c1.1,0,2.1,0.4,2.9,1.1 c0.8,0.8,1.3,1.7,1.4,2.8c0.3-0.1,0.6-0.2,1-0.2c0.7,0,1.3,0.2,1.7,0.7C21.8,12.6,22.1,13.2,22.1,13.9L22.1,13.9z"></path></svg>',
		'spotify'         => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M12,2C6.477,2,2,6.477,2,12c0,5.523,4.477,10,10,10c5.523,0,10-4.477,10-10C22,6.477,17.523,2,12,2 M16.586,16.424 c-0.18,0.295-0.563,0.387-0.857,0.207c-2.348-1.435-5.304-1.76-8.785-0.964c-0.335,0.077-0.67-0.133-0.746-0.469 c-0.077-0.335,0.132-0.67,0.469-0.746c3.809-0.871,7.077-0.496,9.713,1.115C16.673,15.746,16.766,16.13,16.586,16.424 M17.81,13.7 c-0.226,0.367-0.706,0.482-1.072,0.257c-2.687-1.652-6.785-2.131-9.965-1.166C6.36,12.917,5.925,12.684,5.8,12.273 C5.675,11.86,5.908,11.425,6.32,11.3c3.632-1.102,8.147-0.568,11.234,1.328C17.92,12.854,18.035,13.335,17.81,13.7 M17.915,10.865 c-3.223-1.914-8.54-2.09-11.618-1.156C5.804,9.859,5.281,9.58,5.131,9.086C4.982,8.591,5.26,8.069,5.755,7.919 c3.532-1.072,9.404-0.865,13.115,1.338c0.445,0.264,0.59,0.838,0.327,1.282C18.933,10.983,18.359,11.129,17.915,10.865"></path></svg>',
		'tumblr'          => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512"><path d="M309.8 480.3c-13.6 14.5-50 31.7-97.4 31.7-120.8 0-147-88.8-147-140.6v-144H17.9c-5.5 0-10-4.5-10-10v-68c0-7.2 4.5-13.6 11.3-16 62-21.8 81.5-76 84.3-117.1.8-11 6.5-16.3 16.1-16.3h70.9c5.5 0 10 4.5 10 10v115.2h83c5.5 0 10 4.4 10 9.9v81.7c0 5.5-4.5 10-10 10h-83.4V360c0 34.2 23.7 53.6 68 35.8 4.8-1.9 9-3.2 12.7-2.2 3.5.9 5.8 3.4 7.4 7.9l22 64.3c1.8 5 3.3 10.6-.4 14.5z"/></svg>',
		'twitch'          => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M16.499,8.089h-1.636v4.91h1.636V8.089z M12,8.089h-1.637v4.91H12V8.089z M4.228,3.178L3,6.451v13.092h4.499V22h2.456 l2.454-2.456h3.681L21,14.636V3.178H4.228z M19.364,13.816l-2.864,2.865H12l-2.453,2.453V16.68H5.863V4.814h13.501V13.816z"></path></svg>',
		'twitter'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" fill="currentColor"><path d="M389.2 48h70.6L305.6 224.2 487 464H345L233.7 318.6 106.5 464H35.8L200.7 275.5 26.8 48H172.4L272.9 180.9 389.2 48zM364.4 421.8h39.1L151.1 88h-42L364.4 421.8z"></path></svg>',
		'vimeo'           => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M447.8 153.6c-2 43.6-32.4 103.3-91.4 179.1-60.9 79.2-112.4 118.8-154.6 118.8-26.1 0-48.2-24.1-66.3-72.3C100.3 250 85.3 174.3 56.2 174.3c-3.4 0-15.1 7.1-35.2 21.1L0 168.2c51.6-45.3 100.9-95.7 131.8-98.5 34.9-3.4 56.3 20.5 64.4 71.5 28.7 181.5 41.4 208.9 93.6 126.7 18.7-29.6 28.8-52.1 30.2-67.6 4.8-45.9-35.8-42.8-63.3-31 22-72.1 64.1-107.1 126.2-105.1 45.8 1.2 67.5 31.1 64.9 89.4z"/></svg>',
		'vk'              => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M22,7.1c0.2,0.4-0.4,1.5-1.6,3.1c-0.2,0.2-0.4,0.5-0.7,0.9c-0.5,0.7-0.9,1.1-0.9,1.4c-0.1,0.3-0.1,0.6,0.1,0.8 c0.1,0.1,0.4,0.4,0.8,0.9h0l0,0c1,0.9,1.6,1.7,2,2.3c0,0,0,0.1,0.1,0.1c0,0.1,0,0.1,0.1,0.3c0,0.1,0,0.2,0,0.4 c0,0.1-0.1,0.2-0.3,0.3c-0.1,0.1-0.4,0.1-0.6,0.1l-2.7,0c-0.2,0-0.4,0-0.6-0.1c-0.2-0.1-0.4-0.1-0.5-0.2l-0.2-0.1 c-0.2-0.1-0.5-0.4-0.7-0.7s-0.5-0.6-0.7-0.8c-0.2-0.2-0.4-0.4-0.6-0.6C14.8,15,14.6,15,14.4,15c0,0,0,0-0.1,0c0,0-0.1,0.1-0.2,0.2 c-0.1,0.1-0.2,0.2-0.2,0.3c-0.1,0.1-0.1,0.3-0.2,0.5c-0.1,0.2-0.1,0.5-0.1,0.8c0,0.1,0,0.2,0,0.3c0,0.1-0.1,0.2-0.1,0.2l0,0.1 c-0.1,0.1-0.3,0.2-0.6,0.2h-1.2c-0.5,0-1,0-1.5-0.2c-0.5-0.1-1-0.3-1.4-0.6s-0.7-0.5-1.1-0.7s-0.6-0.4-0.7-0.6l-0.3-0.3 c-0.1-0.1-0.2-0.2-0.3-0.3s-0.4-0.5-0.7-0.9s-0.7-1-1.1-1.6c-0.4-0.6-0.8-1.3-1.3-2.2C2.9,9.4,2.5,8.5,2.1,7.5C2,7.4,2,7.3,2,7.2 c0-0.1,0-0.1,0-0.2l0-0.1c0.1-0.1,0.3-0.2,0.6-0.2l2.9,0c0.1,0,0.2,0,0.2,0.1S5.9,6.9,5.9,7L6,7c0.1,0.1,0.2,0.2,0.3,0.3 C6.4,7.7,6.5,8,6.7,8.4C6.9,8.8,7,9,7.1,9.2l0.2,0.3c0.2,0.4,0.4,0.8,0.6,1.1c0.2,0.3,0.4,0.5,0.5,0.7s0.3,0.3,0.4,0.4 c0.1,0.1,0.3,0.1,0.4,0.1c0.1,0,0.2,0,0.3-0.1c0,0,0,0,0.1-0.1c0,0,0.1-0.1,0.1-0.2c0.1-0.1,0.1-0.3,0.1-0.5c0-0.2,0.1-0.5,0.1-0.8 c0-0.4,0-0.8,0-1.3c0-0.3,0-0.5-0.1-0.8c0-0.2-0.1-0.4-0.1-0.5L9.6,7.6C9.4,7.3,9.1,7.2,8.7,7.1C8.6,7.1,8.6,7,8.7,6.9 C8.9,6.7,9,6.6,9.1,6.5c0.4-0.2,1.2-0.3,2.5-0.3c0.6,0,1,0.1,1.4,0.1c0.1,0,0.3,0.1,0.3,0.1c0.1,0.1,0.2,0.1,0.2,0.3 c0,0.1,0.1,0.2,0.1,0.3s0,0.3,0,0.5c0,0.2,0,0.4,0,0.6c0,0.2,0,0.4,0,0.7c0,0.3,0,0.6,0,0.9c0,0.1,0,0.2,0,0.4c0,0.2,0,0.4,0,0.5 c0,0.1,0,0.3,0,0.4s0.1,0.3,0.1,0.4c0.1,0.1,0.1,0.2,0.2,0.3c0.1,0,0.1,0,0.2,0c0.1,0,0.2,0,0.3-0.1c0.1-0.1,0.2-0.2,0.4-0.4 s0.3-0.4,0.5-0.7c0.2-0.3,0.5-0.7,0.7-1.1c0.4-0.7,0.8-1.5,1.1-2.3c0-0.1,0.1-0.1,0.1-0.2c0-0.1,0.1-0.1,0.1-0.1l0,0l0.1,0 c0,0,0,0,0.1,0s0.2,0,0.2,0l3,0c0.3,0,0.5,0,0.7,0S21.9,7,21.9,7L22,7.1z"></path></svg>',
		'wordpress'       => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M12.158,12.786L9.46,20.625c0.806,0.237,1.657,0.366,2.54,0.366c1.047,0,2.051-0.181,2.986-0.51 c-0.024-0.038-0.046-0.079-0.065-0.124L12.158,12.786z M3.009,12c0,3.559,2.068,6.634,5.067,8.092L3.788,8.341 C3.289,9.459,3.009,10.696,3.009,12z M18.069,11.546c0-1.112-0.399-1.881-0.741-2.48c-0.456-0.741-0.883-1.368-0.883-2.109 c0-0.826,0.627-1.596,1.51-1.596c0.04,0,0.078,0.005,0.116,0.007C16.472,3.904,14.34,3.009,12,3.009 c-3.141,0-5.904,1.612-7.512,4.052c0.211,0.007,0.41,0.011,0.579,0.011c0.94,0,2.396-0.114,2.396-0.114 C7.947,6.93,8.004,7.642,7.52,7.699c0,0-0.487,0.057-1.029,0.085l3.274,9.739l1.968-5.901l-1.401-3.838 C9.848,7.756,9.389,7.699,9.389,7.699C8.904,7.67,8.961,6.93,9.446,6.958c0,0,1.484,0.114,2.368,0.114 c0.94,0,2.397-0.114,2.397-0.114c0.485-0.028,0.542,0.684,0.057,0.741c0,0-0.488,0.057-1.029,0.085l3.249,9.665l0.897-2.996 C17.841,13.284,18.069,12.316,18.069,11.546z M19.889,7.686c0.039,0.286,0.06,0.593,0.06,0.924c0,0.912-0.171,1.938-0.684,3.22 l-2.746,7.94c2.673-1.558,4.47-4.454,4.47-7.771C20.991,10.436,20.591,8.967,19.889,7.686z M12,22C6.486,22,2,17.514,2,12 C2,6.486,6.486,2,12,2c5.514,0,10,4.486,10,10C22,17.514,17.514,22,12,22z"></path></svg>',
		'whatsapp'        => '<svg viewBox="0 0 32 32"><path d="M23.813 6.063q-2-1.938-4.531-3t-5.281-1.063q-3.75 0-6.938 1.875t-5.063 5.063-1.875 6.938 1.875 6.938l-2 7.188 7.375-1.938q3.063 1.688 6.625 1.688v0q3.75 0 6.969-1.875t5.125-5.063 1.906-6.938q0-2.75-1.094-5.281t-3.094-4.531zM14 27.438q-3.188 0-5.875-1.625l-0.438-0.25-4.375 1.125 1.188-4.25-0.25-0.438q-1.813-2.813-1.813-6.125 0-3.125 1.563-5.781t4.219-4.219 5.781-1.563q2.313 0 4.406 0.875t3.75 2.531 2.594 3.781 0.938 4.375q0 3.125-1.594 5.781t-4.281 4.219-5.813 1.563zM20.313 18.75q-1.875-0.938-2.375-1.125-0.25-0.063-0.438-0.063t-0.313 0.25q-0.313 0.438-1.125 1.375-0.25 0.313-0.75 0.063-1.75-0.875-2.625-1.563-1.188-0.938-2.063-2.563-0.188-0.188-0.125-0.344t0.313-0.406q0.5-0.5 0.813-1.125 0.125-0.25-0.063-0.625l-1.063-2.563q-0.125-0.375-0.281-0.469t-0.406-0.094h-0.75q-0.5 0-0.938 0.438l-0.063 0.063q-1.125 1.188-1.125 2.813t1.375 3.563l0.125 0.125q2.625 3.75 5.813 5.125 1.563 0.688 2.5 0.875 0.813 0.125 1.688 0 0.563-0.063 1.344-0.594t1-1.063 0.25-1.031-0.031-0.625-0.5-0.313z"></path></svg>',
		'yelp'            => '<svg viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M12.271,16.718v1.417q-.011,3.257-.067,3.4a.707.707,0,0,1-.569.446,4.637,4.637,0,0,1-2.024-.424A4.609,4.609,0,0,1,7.8,20.565a.844.844,0,0,1-.19-.4.692.692,0,0,1,.044-.29,3.181,3.181,0,0,1,.379-.524q.335-.412,2.019-2.409.011,0,.669-.781a.757.757,0,0,1,.44-.274.965.965,0,0,1,.552.039.945.945,0,0,1,.418.324.732.732,0,0,1,.139.468Zm-1.662-2.8a.783.783,0,0,1-.58.781l-1.339.435q-3.067.981-3.257.981a.711.711,0,0,1-.6-.4,2.636,2.636,0,0,1-.19-.836,9.134,9.134,0,0,1,.011-1.857,3.559,3.559,0,0,1,.335-1.389.659.659,0,0,1,.625-.357,22.629,22.629,0,0,1,2.253.859q.781.324,1.283.524l.937.379a.771.771,0,0,1,.4.34A.982.982,0,0,1,10.609,13.917Zm9.213,3.313a4.467,4.467,0,0,1-1.021,1.8,4.559,4.559,0,0,1-1.512,1.417.671.671,0,0,1-.7-.078q-.156-.112-2.052-3.2l-.524-.859a.761.761,0,0,1-.128-.513.957.957,0,0,1,.217-.513.774.774,0,0,1,.926-.29q.011.011,1.327.446,2.264.736,2.7.887a2.082,2.082,0,0,1,.524.229.673.673,0,0,1,.245.68Zm-7.5-7.049q.056,1.137-.6,1.361-.647.19-1.272-.792L6.237,4.08a.7.7,0,0,1,.212-.691,5.788,5.788,0,0,1,2.314-1,5.928,5.928,0,0,1,2.5-.352.681.681,0,0,1,.547.5q.034.2.245,3.407T12.327,10.181Zm7.384,1.2a.679.679,0,0,1-.29.658q-.167.112-3.67.959-.747.167-1.015.257l.011-.022a.769.769,0,0,1-.513-.044.914.914,0,0,1-.413-.357.786.786,0,0,1,0-.971q.011-.011.836-1.137,1.394-1.908,1.673-2.275a2.423,2.423,0,0,1,.379-.435A.7.7,0,0,1,17.435,8a4.482,4.482,0,0,1,1.372,1.489,4.81,4.81,0,0,1,.9,1.868v.034Z"></path></svg>',
		'youtube'         => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path d="M549.655 124.083c-6.281-23.65-24.787-42.276-48.284-48.597C458.781 64 288 64 288 64S117.22 64 74.629 75.486c-23.497 6.322-42.003 24.947-48.284 48.597-11.412 42.867-11.412 132.305-11.412 132.305s0 89.438 11.412 132.305c6.281 23.65 24.787 41.5 48.284 47.821C117.22 448 288 448 288 448s170.78 0 213.371-11.486c23.497-6.321 42.003-24.171 48.284-47.821 11.412-42.867 11.412-132.305 11.412-132.305s0-89.438-11.412-132.305zm-317.51 213.508V175.185l142.739 81.205-142.739 81.201z"/></svg>',
		'telegram'        => '<svg viewBox="0 0 32 32"><path d="M27.938 6.188l-4.25 19.875q-0.25 1.063-0.844 1.344t-1.469-0.219l-6.438-4.75-3.125 3q-0.313 0.313-0.5 0.438-0.313 0.188-0.813 0.188l0.5-6.563 11.938-10.813q0.25-0.188 0.156-0.344t-0.375-0.125-0.594 0.219l-14.75 9.313-6.375-2q-1.063-0.313-1-0.938t1.313-1.125l24.813-9.563q0.938-0.313 1.5 0.219t0.313 1.844z"></path></svg>',
		'stumbleupon'     => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M502.9 266v69.7c0 62.1-50.3 112.4-112.4 112.4-61.8 0-112.4-49.8-112.4-111.3v-70.2l34.3 16 51.1-15.2V338c0 14.7 12 26.5 26.7 26.5S417 352.7 417 338v-72h85.9zm-224.7-58.2l34.3 16 51.1-15.2V173c0-60.5-51.1-109-112.1-109-60.8 0-112.1 48.2-112.1 108.2v162.4c0 14.9-12 26.7-26.7 26.7S86 349.5 86 334.6V266H0v69.7C0 397.7 50.3 448 112.4 448c61.6 0 112.4-49.5 112.4-110.8V176.9c0-14.7 12-26.7 26.7-26.7s26.7 12 26.7 26.7v30.9z"/></svg>',
		'tiktok' 		  => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M448,209.91a210.06,210.06,0,0,1-122.77-39.25V349.38A162.55,162.55,0,1,1,185,188.31V278.2a74.62,74.62,0,1,0,52.23,71.18V0l88,0a121.18,121.18,0,0,0,1.86,22.17h0A122.18,122.18,0,0,0,381,102.39a121.43,121.43,0,0,0,67,20.14Z"/></svg>',
		'houzz' 		  => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M275.9 330.7H171.3V480H17V32h109.5v104.5l305.1 85.6V480H275.9z"/></svg>',
		'rss' 			  => '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path d="M128.081 415.959c0 35.369-28.672 64.041-64.041 64.041S0 451.328 0 415.959s28.672-64.041 64.041-64.041 64.04 28.673 64.04 64.041zm175.66 47.25c-8.354-154.6-132.185-278.587-286.95-286.95C7.656 175.765 0 183.105 0 192.253v48.069c0 8.415 6.49 15.472 14.887 16.018 111.832 7.284 201.473 96.702 208.772 208.772.547 8.397 7.604 14.887 16.018 14.887h48.069c9.149.001 16.489-7.655 15.995-16.79zm144.249.288C439.596 229.677 251.465 40.445 16.503 32.01 7.473 31.686 0 38.981 0 48.016v48.068c0 8.625 6.835 15.645 15.453 15.999 191.179 7.839 344.627 161.316 352.465 352.465.353 8.618 7.373 15.453 15.999 15.453h48.068c9.034-.001 16.329-7.474 16.005-16.504z"/></svg>'
	);

	/**
	 * Get the SVG code for the specified icon
	 *
	 * @since 1.0.0
	 *
	 * @param string $icon Icon name.
	 * @param string $group Icon group.
	 * @param array  $size The icon attributes.
	 *
	 * @return string
	 */
	public static function get_svg( $icon, $group = 'ui', $attr = array() ) {
		$attr = wp_parse_args( $attr, array(
			'class' => '',
			'size'  => 24,
		) );
		$svg = '';

		if ( ! empty( $group ) ) {
			if ( 'ui' === $group ) {
				$arr = self::$ui_icons;
			} elseif ( 'social' === $group ) {
				$arr = self::$social_icons;
			} else {
				$arr = array();
			}

			$arr = apply_filters( "motta_svg_icons_{$group}", $arr );

			if ( array_key_exists( $icon, $arr ) ) {
				$svg = $arr[ $icon ];
			}
		} else {
			if ( array_key_exists( $icon, self::$ui_icons ) ) {
				$svg = self::$ui_icons[ $icon ];
			} elseif ( array_key_exists( $icon, self::$social_icons ) ) {
				$svg = self::$social_icons[ $icon ];
			}
		}

		if ( $svg ) {
			$size = absint( $attr['size'] );
			$repl = sprintf( '<svg width="%d" height="%d" aria-hidden="true" role="img" focusable="false" ', $size, $size );

			// Build attributes.
			unset( $attr['size'] );
			$attr_string = '';

			$attr['class'] = trim( 'motta-svg-icon motta-svg-icon--' . $icon . ' ' . $attr['class'] );

			foreach ( $attr as $name => $value ) {
				$attr_string .= esc_attr( $name ) . '="' . esc_attr( $value ) . '" ';
			}

			$svg = preg_replace( '/^<svg /', $repl, $svg );
			$svg = '<span ' . $attr_string . '>' . $svg . '</span>';
		}

		return $svg;
	}

	/**
	 * Sanitize SVG code.
	 *
	 * @since 1.0.0
	 *
	 * @param string $svg SVG code.
	 *
	 * @return string
	 */
	public static function sanitize_svg( $svg ) {
		$allowed   = array();
		$whitelist = array(
			'a'              => array( 'class', 'clip-path', 'clip-rule', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'id', 'mask', 'opacity', 'stroke', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'style', 'systemLanguage', 'transform', 'href', 'xlink:href', 'xlink:title' ),
			'circle'         => array( 'class', 'clip-path', 'clip-rule', 'cx', 'cy', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'id', 'mask', 'opacity', 'r', 'requiredFeatures', 'stroke', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'style', 'systemLanguage', 'transform' ),
			'clipPath'       => array( 'class', 'clipPathUnits', 'id' ),
			'defs'           => array(),
			'style'          => array( 'type' ),
			'desc'           => array(),
			'ellipse'        => array( 'class', 'clip-path', 'clip-rule', 'cx', 'cy', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'id', 'mask', 'opacity', 'requiredFeatures', 'rx', 'ry', 'stroke', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'style', 'systemLanguage', 'transform' ),
			'feGaussianBlur' => array( 'class', 'color-interpolation-filters', 'id', 'requiredFeatures', 'stdDeviation' ),
			'filter'         => array( 'class', 'color-interpolation-filters', 'filterRes', 'filterUnits', 'height', 'id', 'primitiveUnits', 'requiredFeatures', 'width', 'x', 'xlink:href', 'y' ),
			'foreignObject'  => array( 'class', 'font-size', 'height', 'id', 'opacity', 'requiredFeatures', 'style', 'transform', 'width', 'x', 'y' ),
			'g'              => array( 'class', 'clip-path', 'clip-rule', 'id', 'display', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'mask', 'opacity', 'requiredFeatures', 'stroke', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'style', 'systemLanguage', 'transform', 'font-family', 'font-size', 'font-style', 'font-weight', 'text-anchor', ),
			'image'          => array( 'class', 'clip-path', 'clip-rule', 'filter', 'height', 'id', 'mask', 'opacity', 'requiredFeatures', 'style', 'systemLanguage', 'transform', 'width', 'x', 'xlink:href', 'xlink:title', 'y', ),
			'line'           => array( 'class', 'clip-path', 'clip-rule', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'id', 'marker-end', 'marker-mid', 'marker-start', 'mask', 'opacity', 'requiredFeatures', 'stroke', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'style', 'systemLanguage', 'transform', 'x1', 'x2', 'y1', 'y2', ),
			'linearGradient' => array( 'class', 'id', 'gradientTransform', 'gradientUnits', 'requiredFeatures', 'spreadMethod', 'systemLanguage', 'x1', 'x2', 'xlink:href', 'y1', 'y2', ),
			'marker'         => array( 'id', 'class', 'markerHeight', 'markerUnits', 'markerWidth', 'orient', 'preserveAspectRatio', 'refX', 'refY', 'systemLanguage', 'viewBox', ),
			'mask'           => array( 'class', 'height', 'id', 'maskContentUnits', 'maskUnits', 'width', 'x', 'y' ),
			'metadata'       => array( 'class', 'id' ),
			'path'           => array( 'class', 'clip-path', 'clip-rule', 'd', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'id', 'marker-end', 'marker-mid', 'marker-start', 'mask', 'opacity', 'requiredFeatures', 'stroke', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'style', 'systemLanguage', 'transform', ),
			'pattern'        => array( 'class', 'height', 'id', 'patternContentUnits', 'patternTransform', 'patternUnits', 'requiredFeatures', 'style', 'systemLanguage', 'viewBox', 'width', 'x', 'xlink:href', 'y', ),
			'polygon'        => array( 'class', 'clip-path', 'clip-rule', 'id', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'id', 'class', 'marker-end', 'marker-mid', 'marker-start', 'mask', 'opacity', 'points', 'requiredFeatures', 'stroke', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'style', 'systemLanguage', 'transform', ),
			'polyline'       => array( 'class', 'clip-path', 'clip-rule', 'id', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'marker-end', 'marker-mid', 'marker-start', 'mask', 'opacity', 'points', 'requiredFeatures', 'stroke', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'style', 'systemLanguage', 'transform', ),
			'radialGradient' => array( 'class', 'cx', 'cy', 'fx', 'fy', 'gradientTransform', 'gradientUnits', 'id', 'r', 'requiredFeatures', 'spreadMethod', 'systemLanguage', 'xlink:href', ),
			'rect'           => array( 'class', 'clip-path', 'clip-rule', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'height', 'id', 'mask', 'opacity', 'requiredFeatures', 'rx', 'ry', 'stroke', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'style', 'systemLanguage', 'transform', 'width', 'x', 'y', ),
			'stop'           => array( 'class', 'id', 'offset', 'requiredFeatures', 'stop-color', 'stop-opacity', 'style', 'systemLanguage', ),
			'svg'            => array( 'class', 'clip-path', 'clip-rule', 'filter', 'id', 'mask', 'fill', 'stroke', 'preserveaspectRatio', 'requiredfeatures', 'style', 'systemlanguage', 'viewbox', 'width', 'height', 'xmlns', 'xmlns:se', 'xmlns:xlink', 'x', 'y', 'enable-background', ),
			'switch'         => array( 'class', 'id', 'requiredFeatures', 'systemLanguage' ),
			'symbol'         => array( 'class', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'font-family', 'font-size', 'font-style', 'font-weight', 'id', 'opacity', 'preserveAspectRatio', 'requiredFeatures', 'stroke', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'style', 'systemLanguage', 'transform', 'viewBox', ),
			'text'           => array( 'class', 'clip-path', 'clip-rule', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'font-family', 'font-size', 'font-style', 'font-weight', 'id', 'mask', 'opacity', 'requiredFeatures', 'stroke', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'style', 'systemLanguage', 'text-anchor', 'transform', 'x', 'xml:space', 'y', ),
			'textPath'       => array( 'class', 'id', 'method', 'requiredFeatures', 'spacing', 'startOffset', 'style', 'systemLanguage', 'transform', 'xlink:href', ),
			'title'          => array(),
			'tspan'          => array( 'class', 'clip-path', 'clip-rule', 'dx', 'dy', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'font-family', 'font-size', 'font-style', 'font-weight', 'id', 'mask', 'opacity', 'requiredFeatures', 'rotate', 'stroke', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'style', 'systemLanguage', 'text-anchor', 'textLength', 'transform', 'x', 'xml:space', 'y', ),
			'use'            => array( 'class', 'clip-path', 'clip-rule', 'fill', 'fill-opacity', 'fill-rule', 'filter', 'height', 'id', 'mask', 'stroke', 'stroke-dasharray', 'stroke-dashoffset', 'stroke-linecap', 'stroke-linejoin', 'stroke-miterlimit', 'stroke-opacity', 'stroke-width', 'style', 'transform', 'width', 'x', 'xlink:href', 'y', ),
		);

		foreach ( $whitelist as $tag => $attributes ) {
			$allowed[ $tag ] = array();

			foreach ( $attributes as $attribute ) {
				$allowed[ $tag ][ $attribute ] = true;
			}
		}

		return wp_kses( $svg, $allowed );
	}
}
