<?php
/**
 * My Account Dashboard
 *
 * Shows the first intro screen on the account dashboard.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/dashboard.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 4.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$allowed_html = array(
	'a' => array(
		'href' => array(),
	),
	'span' => array(),
	'p' => array(),
);
?>

<h3 class="greeting"> <?php echo wp_kses( __( 'Account overview', 'motta' ), $allowed_html ); ?> </h3>

<?php
/* translators: 1: Orders URL 2: Address URL 3: Account URL. */
$dashboard_desc = __( '<p>From your account dashboard you can view your <a href="%1$s">Recent orders</a>.</p><p>Manage your <a href="%2$s">Billing address</a>.</p><p>Edit your <a href="%3$s">Password and Account details</a>.</p>', 'motta' );

if ( wc_shipping_enabled() ) {
	/* translators: 1: Orders URL 2: Addresses URL 3: Account URL. */
	$dashboard_desc = __( '<p>From your account dashboard you can view your <a href="%1$s">Recent orders</a>.</p><p>Manage your <a href="%2$s">Shipping and Billing addresses</a>.</p><p>Edit your <a href="%3$s">Password and Account details</a>.</p>', 'motta' );
}

echo wp_kses(
	sprintf(
		$dashboard_desc,
		esc_url( wc_get_endpoint_url( 'orders' ) ),
		esc_url( wc_get_endpoint_url( 'edit-address' ) ),
		esc_url( wc_get_endpoint_url( 'edit-account' ) )
	),
	$allowed_html
);
?>

<?php
	/**
	 * My Account dashboard.
	 *
	 * @since 2.6.0
	 */
	do_action( 'woocommerce_account_dashboard' );

	/**
	 * Deprecated woocommerce_before_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	do_action( 'woocommerce_before_my_account' );

	/**
	 * Deprecated woocommerce_after_my_account action.
	 *
	 * @deprecated 2.6.0
	 */
	do_action( 'woocommerce_after_my_account' );

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
