<?php

namespace KeyDesign;
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$license_key = License\Admin::get_license_key();

if ( ! $license_key ) {
    return;
}

$license_data = License\API::get_license_data();
$support_status = false;
$support_message = '';
$disable_button = false;
$support_remaining = '';

if ( $license_data['status'] ) {
	$support_expiry = $license_data['data'];

    $current_time = current_time( 'timestamp' );
    $expiry_time = strtotime( $support_expiry );

	$support_remaining = human_time_diff( $current_time, $expiry_time );

	if ( $expiry_time > $current_time ) {
		$support_status = true;
        
        // Calculate the difference in months
        $diff_in_seconds = $expiry_time - $current_time;
        $diff_in_months = $diff_in_seconds / (30 * 24 * 60 * 60); // 30 days * 24 hours * 60 minutes * 60 seconds
        
        if ( $diff_in_months > 6 ) {
            $support_message = esc_html__( 'Thanks for securing your website with extended support.', 'keydesign-framework' );
            $disable_button = true; // Disable the buttons
        }
	}
}

?>
<div class="kdadmin-panel-column">
    <h3>
        <span class="dashboard-icon lnricons-lifebuoy"></span><?php echo esc_html__( 'Support Status', 'keydesign-framework' ); ?>
    </h3>
	
    <p>
        <?php if ( $support_status ) : ?>
            <span class="active"><?php printf( esc_html__( 'Your item support will expire in %1$s.', 'keydesign-framework' ), $support_remaining ); ?></span>
        <?php else : ?>
            <span class="expired"><?php echo esc_html__( 'Your support subscription has expired.', 'keydesign-framework' ); ?></span>
        <?php endif; ?>
    </p>
	
    <hr>
    <?php if ( $support_status ) : ?>
        <?php if ( !empty($support_message) ) : ?>
            <p><?php echo $support_message; ?></p>
        <?php else: ?>
            <p><?php echo esc_html__( 'Get an extra 6 months of support now and save.', 'keydesign-framework' ); ?></p>
        <?php endif; ?>
		<span class="support-badge active"><?php echo esc_html__( 'Active', 'keydesign-framework' ); ?></span>
    <?php else : ?>
        <p><?php echo esc_html__( 'Renew your support for 6 new months.', 'keydesign-framework' ); ?></p>
		<span class="support-badge expired"><?php echo esc_html__( 'Expired', 'keydesign-framework' ); ?></span>
    <?php endif; ?>
	
    <?php if ( defined( 'KEYDESIGN_THEMEFOREST_THEME_LINK' ) && !$disable_button ) : ?>
        <a class="kdadmin-button support-button" href="<?php echo esc_attr( KEYDESIGN_THEMEFOREST_THEME_LINK ); ?>" target="_blank">
            <?php if ( $support_status ) : ?>
                <?php echo esc_html__( 'Extend support', 'keydesign-framework' ); ?>
            <?php else : ?>
                <?php echo esc_html__( 'Renew support', 'keydesign-framework' ); ?>
            <?php endif; ?>
        </a>
    <?php endif; ?>
</div>