<?php
/**
 * Get started page.
 *
 * @package Kliken: Ads + Pixel for Meta
 */

defined( 'ABSPATH' ) || exit;

?>

<div class="wrap kk-wrapper">
	<div class="container getstarted flex">
		<div class="content">
			<h1 class="header">
			<?php esc_html_e( 'Grow your business', 'kliken-ads-pixel-for-meta' ); ?>
				<span class="flex align-center">
				<?php
					/* translators: "Facebook Ads" is product name. Do not translate. */
					esc_html_e( 'with Facebook Ads', 'kliken-ads-pixel-for-meta' );
				?>
					<svg width="41" height="40" viewBox="0 0 41 40" fill="none" xmlns="http://www.w3.org/2000/svg">
						<g clip-path="url(#clip0_913_34275)">
						<path fill-rule="evenodd" clip-rule="evenodd" d="M40.1729 20C40.1729 8.9543 31.2186 0 20.1729 0C9.12715 0 0.172852 8.9543 0.172852 20C0.172852 29.9826 7.48656 38.2566 17.0479 39.757V25.7812H11.9697V20H17.0479V15.5938C17.0479 10.5813 20.0337 7.8125 24.6021 7.8125C26.7903 7.8125 29.0791 8.20312 29.0791 8.20312V13.125H26.5571C24.0727 13.125 23.2979 14.6667 23.2979 16.2483V20H28.8447L27.958 25.7812H23.2979V39.757C32.8591 38.2566 40.1729 29.9826 40.1729 20Z" fill="#0866FF"/>
						<path fill-rule="evenodd" clip-rule="evenodd" d="M28.8447 20H23.2979V16.2483C23.2979 14.6667 24.0727 13.125 26.5571 13.125H29.0791V8.20312C29.0791 8.20312 26.7903 7.8125 24.6021 7.8125C20.0337 7.8125 17.0479 10.5812 17.0479 15.5938V20H11.9697V25.7812H17.0479V39.757C18.0661 39.9168 19.1097 40 20.1729 40C21.236 40 22.2796 39.9168 23.2979 39.757V25.7812H27.958L28.8447 20Z" fill="white"/>
						</g>
						<defs>
						<clipPath id="clip0_913_34275">
						<rect width="40" height="40" fill="white" transform="translate(0.172852)"/>
						</clipPath>
						</defs>
					</svg>
				</span>
			</h1>
			<ul>
				<li class="flex align-center">
					<svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
					<mask id="mask0_913_34218" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="25" height="24">
					<rect x="0.172852" width="24" height="24" fill="#101517"/>
					</mask>
					<g mask="url(#mask0_913_34218)">
					<path d="M11.0979 14.05L16.7729 8.4L15.3479 6.975L11.0979 11.225L8.97285 9.1L7.57285 10.5L11.0979 14.05ZM1.17285 21V19H23.1729V21H1.17285ZM4.17285 18C3.62285 18 3.15202 17.8042 2.76035 17.4125C2.36868 17.0208 2.17285 16.55 2.17285 16V5C2.17285 4.45 2.36868 3.97917 2.76035 3.5875C3.15202 3.19583 3.62285 3 4.17285 3H20.1729C20.7229 3 21.1937 3.19583 21.5854 3.5875C21.977 3.97917 22.1729 4.45 22.1729 5V16C22.1729 16.55 21.977 17.0208 21.5854 17.4125C21.1937 17.8042 20.7229 18 20.1729 18H4.17285ZM4.17285 16H20.1729V5H4.17285V16Z" fill="#101517"/>
					</g>
					</svg>
					<?php
						/* translators: "Facebook Advantage+" is product name. Do not translate. */
						esc_html_e( 'Effortless Facebook Advantage+ campaign creation', 'kliken-ads-pixel-for-meta' );
					?>
				</li>
				<li class="flex align-center">
					<svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
						<mask id="mask0_913_34221" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="25" height="24">
						<rect x="0.172852" width="24" height="24" fill="#101517"/>
						</mask>
						<g mask="url(#mask0_913_34221)">
						<path d="M5.17285 22C4.62285 22 4.15202 21.8042 3.76035 21.4125C3.36868 21.0208 3.17285 20.55 3.17285 20V8C3.17285 7.45 3.36868 6.97917 3.76035 6.5875C4.15202 6.19583 4.62285 6 5.17285 6H7.17285C7.17285 4.61667 7.66035 3.4375 8.63535 2.4625C9.61035 1.4875 10.7895 1 12.1729 1C13.5562 1 14.7354 1.4875 15.7104 2.4625C16.6854 3.4375 17.1729 4.61667 17.1729 6H19.1729C19.7229 6 20.1937 6.19583 20.5854 6.5875C20.977 6.97917 21.1729 7.45 21.1729 8V20C21.1729 20.55 20.977 21.0208 20.5854 21.4125C20.1937 21.8042 19.7229 22 19.1729 22H5.17285ZM5.17285 20H19.1729V8H5.17285V20ZM12.1729 14C13.5562 14 14.7354 13.5125 15.7104 12.5375C16.6854 11.5625 17.1729 10.3833 17.1729 9H15.1729C15.1729 9.83333 14.8812 10.5417 14.2979 11.125C13.7145 11.7083 13.0062 12 12.1729 12C11.3395 12 10.6312 11.7083 10.0479 11.125C9.46452 10.5417 9.17285 9.83333 9.17285 9H7.17285C7.17285 10.3833 7.66035 11.5625 8.63535 12.5375C9.61035 13.5125 10.7895 14 12.1729 14ZM9.17285 6H15.1729C15.1729 5.16667 14.8812 4.45833 14.2979 3.875C13.7145 3.29167 13.0062 3 12.1729 3C11.3395 3 10.6312 3.29167 10.0479 3.875C9.46452 4.45833 9.17285 5.16667 9.17285 6Z" fill="#101517"/>
						</g>
					</svg>
					<?php
						/* translators: Woo, or WooCommerce is product name. Do not translate. */
						esc_html_e( 'Seamless integration with your Woo store', 'kliken-ads-pixel-for-meta' );
					?>
				</li>
				<li class="flex align-center">
					<svg width="25" height="24" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg">
						<mask id="mask0_913_34224" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="25" height="24">
						<rect x="0.172852" width="24" height="24" fill="#101517"/>
						</mask>
						<g mask="url(#mask0_913_34224)">
						<path d="M4.17285 19H8.17285V11H4.17285V19ZM10.1729 19H14.1729V5H10.1729V19ZM16.1729 19H20.1729V13H16.1729V19ZM2.17285 21V9H8.17285V3H16.1729V11H22.1729V21H2.17285Z" fill="#101517"/>
						</g>
					</svg>
					<?php esc_html_e( 'Track ad performance, revenue, and sales with ease', 'kliken-ads-pixel-for-meta' ); ?>
				</li>
			</ul>
		</div>
		<div class="image">
			<svg viewBox="0 0 395 391" fill="none" xmlns="http://www.w3.org/2000/svg">
				<g clip-path="url(#clip0_913_34227)">
				<path opacity="0.2" d="M32.4282 101.781C0.585827 128.583 -8.49514 172.764 10.2958 207.973C11.1803 209.65 12.1238 211.269 13.1066 212.83C24.1531 230.561 26.728 251.978 21.6765 272.46C18.4703 285.134 18.3323 298.381 21.2737 311.118C24.2151 323.855 30.1524 335.721 38.6001 345.744C61.9118 373.462 99.9654 383.216 134.245 373.365C136.521 372.649 138.742 371.769 140.889 370.732C156.967 363.183 186.313 360.51 201.291 369.152C232.15 386.922 257.349 404.828 307.137 375.179C332.139 360.296 339.058 342.526 339.078 316.661C339.078 299.456 358.439 292.98 370.999 280.301C373.682 277.587 376.159 274.679 378.409 271.602C399.775 242.342 399.008 203.116 375.107 176.997C365.722 166.777 353.697 159.303 340.336 155.384C331.636 152.799 324.235 147.06 319.603 139.308C314.971 131.557 313.447 122.359 315.334 113.544C318.371 98.6692 317.694 83.2834 313.364 68.728C309.033 54.1726 301.18 40.8897 290.489 30.0379C256.799 -4.48795 201.645 -9.91065 159.483 17.2028C146.377 25.5663 135.312 36.7205 127.09 49.8561C122.01 58.0018 115.198 64.9485 107.132 70.2111C99.0651 75.4737 89.9382 78.9252 80.3883 80.3246C62.6843 82.8516 46.0595 90.2893 32.4282 101.781Z" fill="#0081FB"/>
				<path d="M100.83 112.159C100.508 111.012 99.908 109.961 99.0823 109.097C98.2566 108.234 97.2304 107.584 96.0934 107.204C95.1786 106.889 94.2074 106.767 93.2424 106.848C92.2774 106.929 91.3403 107.209 90.4915 107.672C89.8447 105.301 88.4303 103.207 86.4661 101.713C84.5019 100.218 82.097 99.4061 79.6219 99.4015H79.2288C77.7552 94.968 74.9025 91.1127 71.0809 88.3902C67.2594 85.6677 62.6661 84.2185 57.9619 84.251C53.2578 84.2835 48.6853 85.7961 44.9023 88.5712C41.1194 91.3462 38.321 95.2407 36.9099 99.6941C36.576 99.6749 36.2413 99.6749 35.9074 99.6941C25.5685 100.708 22.6988 108.043 21.9911 113.153C21.9088 113.773 21.9624 114.402 22.1482 114.999C22.3341 115.596 22.6479 116.145 23.068 116.611C23.4881 117.076 24.0046 117.445 24.5821 117.693C25.1596 117.942 25.7844 118.063 26.4137 118.049L96.8993 116.84C97.4889 116.852 98.0736 116.732 98.6102 116.489C99.1467 116.246 99.6214 115.887 99.9989 115.437C100.376 114.987 100.647 114.459 100.791 113.892C100.935 113.324 100.949 112.732 100.83 112.159Z" fill="white"/>
				<path d="M26.2364 118.537C25.5164 118.536 24.8047 118.384 24.1477 118.091C23.4908 117.799 22.9032 117.373 22.4232 116.84C21.9523 116.313 21.6 115.693 21.3899 115.02C21.1798 114.347 21.1166 113.638 21.2045 112.939C21.8728 108.179 24.6443 100.006 35.7301 98.9334C35.9327 98.9136 36.1368 98.9136 36.3394 98.9334C37.8664 94.4617 40.7601 90.5737 44.6178 87.8104C48.4754 85.047 53.1052 83.5459 57.8628 83.5158C62.6204 83.4858 67.269 84.9283 71.1619 87.6427C75.0547 90.3571 77.998 94.2083 79.5821 98.6603C82.0588 98.6802 84.4683 99.4619 86.4784 100.898C88.4886 102.334 90.0004 104.353 90.8056 106.677C92.5237 105.958 94.4492 105.896 96.2109 106.502C97.4569 106.908 98.5808 107.617 99.4803 108.564C100.38 109.511 101.026 110.666 101.361 111.924C101.517 112.561 101.524 113.224 101.381 113.863C101.238 114.502 100.948 115.101 100.535 115.611C100.093 116.175 99.5263 116.632 98.8792 116.947C98.232 117.261 97.5211 117.425 96.8006 117.425L26.2953 118.479L26.2364 118.537ZM35.966 100.201C26.2953 101.138 23.3863 107.731 22.6394 113.075C22.5694 113.591 22.6122 114.116 22.7649 114.614C22.9175 115.112 23.1764 115.572 23.5239 115.962C23.8837 116.369 24.3286 116.694 24.8276 116.912C25.3267 117.131 25.8678 117.24 26.4133 117.23L96.8989 116.177C97.4211 116.176 97.9364 116.058 98.4062 115.832C98.8759 115.606 99.288 115.277 99.6114 114.87C99.9011 114.518 100.104 114.103 100.203 113.66C100.302 113.216 100.294 112.755 100.181 112.315C99.8929 111.266 99.3496 110.303 98.5992 109.51C97.8487 108.718 96.914 108.12 95.8768 107.77C95.0424 107.481 94.156 107.37 93.2755 107.444C92.3949 107.518 91.5399 107.775 90.7663 108.199C90.6765 108.238 90.5794 108.258 90.4813 108.258C90.3831 108.258 90.2861 108.238 90.1963 108.199C90.1067 108.158 90.0269 108.099 89.9625 108.025C89.8981 107.95 89.8504 107.864 89.8228 107.77C89.2127 105.539 87.8829 103.569 86.037 102.159C84.191 100.75 81.9306 99.9803 79.6018 99.9672H79.2087C79.0684 99.9728 78.9303 99.9317 78.8163 99.8504C78.7024 99.7691 78.6191 99.6523 78.5797 99.5186C77.1226 95.2428 74.3438 91.5319 70.6387 88.9138C66.9336 86.2958 62.4909 84.904 57.9427 84.9364C53.3945 84.9688 48.9724 86.4238 45.3055 89.0944C41.6387 91.7649 38.9139 95.515 37.5188 99.8112C37.4726 99.9499 37.3827 100.07 37.2624 100.155C37.1421 100.239 36.9977 100.283 36.8505 100.279H36.3984L35.966 100.201Z" fill="#7F54B3"/>
				<path d="M46.2069 104.59C46.1187 104.593 46.0309 104.578 45.9494 104.544C45.868 104.51 45.7949 104.46 45.7351 104.395C44.4429 103.073 42.8972 102.021 41.1892 101.301C39.4811 100.581 37.6452 100.207 35.7893 100.201C35.6933 100.218 35.5949 100.213 35.5008 100.188C35.4067 100.163 35.3194 100.117 35.2448 100.055C35.1703 99.993 35.1104 99.9153 35.0692 99.8277C35.0281 99.74 35.0068 99.6445 35.0068 99.5478C35.0068 99.4511 35.0281 99.3556 35.0692 99.2679C35.1104 99.1803 35.1703 99.1026 35.2448 99.0403C35.3194 98.9781 35.4067 98.9328 35.5008 98.9075C35.5949 98.8823 35.6933 98.8778 35.7893 98.8943C38.1142 98.8806 40.41 99.4084 42.4919 100.435C44.0516 101.206 45.4674 102.235 46.6786 103.478C46.7749 103.568 46.8412 103.685 46.8686 103.814C46.896 103.942 46.8832 104.076 46.8318 104.197C46.7805 104.318 46.6931 104.42 46.5814 104.491C46.4697 104.561 46.339 104.596 46.2069 104.59ZM90.1375 107.282C90.0038 107.282 89.8734 107.24 89.7643 107.163C89.6553 107.086 89.5728 106.978 89.5282 106.853C88.7768 104.812 87.4131 103.048 85.6208 101.799C83.8285 100.551 81.6936 99.8773 79.5038 99.8696C79.4078 99.8862 79.3093 99.8816 79.2152 99.8564C79.1212 99.8312 79.0338 99.7859 78.9593 99.7236C78.8847 99.6614 78.8248 99.5837 78.7837 99.496C78.7426 99.4084 78.7213 99.3129 78.7213 99.2162C78.7213 99.1195 78.7426 99.024 78.7837 98.9363C78.8248 98.8487 78.8847 98.771 78.9593 98.7087C79.0338 98.6465 79.1212 98.6012 79.2152 98.5759C79.3093 98.5507 79.4078 98.5462 79.5038 98.5627C81.9598 98.5644 84.3562 99.3132 86.3701 100.708C88.3839 102.103 89.9184 104.078 90.7665 106.365C90.824 106.528 90.8151 106.707 90.7416 106.864C90.6682 107.02 90.5361 107.142 90.3734 107.204C90.3028 107.25 90.2216 107.276 90.1375 107.282Z" fill="#7F54B3"/>
				<path d="M100.948 114.577C100.774 114.572 100.609 114.5 100.488 114.376C100.367 114.253 100.299 114.087 100.3 113.914C100.299 112.593 99.8949 111.302 99.1404 110.213C98.3858 109.125 97.3163 108.288 96.0729 107.815C94.8296 107.342 93.4709 107.254 92.1762 107.563C90.8814 107.871 89.7114 108.563 88.8205 109.545C88.6929 109.664 88.5242 109.731 88.3488 109.731C88.1734 109.731 88.0047 109.664 87.8771 109.545C87.8133 109.486 87.7625 109.415 87.7277 109.337C87.6929 109.258 87.675 109.173 87.675 109.086C87.675 109 87.6929 108.915 87.7277 108.836C87.7625 108.757 87.8133 108.686 87.8771 108.628C88.9372 107.435 90.3393 106.592 91.8957 106.212C93.4521 105.832 95.0884 105.933 96.5852 106.502C98.0821 107.071 99.368 108.08 100.271 109.394C101.174 110.708 101.65 112.265 101.636 113.856C101.645 113.949 101.633 114.043 101.602 114.132C101.571 114.221 101.521 114.302 101.456 114.37C101.391 114.439 101.312 114.492 101.224 114.528C101.137 114.564 101.043 114.581 100.948 114.577ZM80.231 106.892C80.0537 106.892 79.8837 106.822 79.7584 106.698C79.6331 106.573 79.5627 106.405 79.5627 106.229C79.5627 100.538 77.2847 95.0805 73.2299 91.0566C69.1751 87.0326 63.6757 84.772 57.9413 84.772C57.7862 84.7453 57.6455 84.6651 57.5442 84.5456C57.4428 84.426 57.3872 84.2748 57.3872 84.1186C57.3872 83.9623 57.4428 83.8111 57.5442 83.6916C57.6455 83.572 57.7862 83.4918 57.9413 83.4651C60.956 83.46 63.9421 84.0451 66.7285 85.1871C69.515 86.329 72.047 88.0052 74.1796 90.1198C76.3122 92.2344 78.0035 94.7457 79.1566 97.5099C80.3097 100.274 80.9019 103.237 80.8993 106.229C80.8993 106.405 80.8289 106.573 80.7035 106.698C80.5782 106.822 80.4082 106.892 80.231 106.892Z" fill="#7F54B3"/>
				<path d="M48.0939 235.71C47.5726 235.71 47.0726 235.505 46.704 235.139C46.3354 234.773 46.1283 234.277 46.1283 233.76C46.1283 233.242 46.3354 232.746 46.704 232.381C47.0726 232.015 47.5726 231.809 48.0939 231.809L67.4941 231.634C68.0154 231.634 68.5154 231.839 68.884 232.205C69.2526 232.571 69.4597 233.067 69.4597 233.584C69.4597 234.102 69.2526 234.598 68.884 234.964C68.5154 235.329 68.0154 235.535 67.4941 235.535L48.0742 235.71H48.0939ZM32.3103 223.187C31.789 223.187 31.289 222.982 30.9204 222.616C30.5518 222.25 30.3447 221.754 30.3447 221.237C30.3447 220.72 30.5518 220.223 30.9204 219.858C31.289 219.492 31.789 219.286 32.3103 219.286L71.3467 218.935C71.868 218.935 72.3679 219.141 72.7366 219.506C73.1052 219.872 73.3123 220.368 73.3123 220.886C73.3123 221.403 73.1052 221.899 72.7366 222.265C72.3679 222.631 71.868 222.836 71.3467 222.836L32.2513 223.187H32.3103ZM317.044 264.677H260.534C260.012 264.677 259.512 264.471 259.144 264.106C258.775 263.74 258.568 263.244 258.568 262.726C258.568 262.209 258.775 261.713 259.144 261.347C259.512 260.981 260.012 260.776 260.534 260.776H317.044C317.565 260.776 318.065 260.981 318.434 261.347C318.802 261.713 319.009 262.209 319.009 262.726C319.009 263.244 318.802 263.74 318.434 264.106C318.065 264.471 317.565 264.677 317.044 264.677ZM333.614 278.721H276.297C275.776 278.721 275.276 278.516 274.908 278.15C274.539 277.784 274.332 277.288 274.332 276.771C274.332 276.253 274.539 275.757 274.908 275.391C275.276 275.026 275.776 274.82 276.297 274.82H333.614C334.135 274.82 334.635 275.026 335.004 275.391C335.372 275.757 335.579 276.253 335.579 276.771C335.579 277.288 335.372 277.784 335.004 278.15C334.635 278.516 334.135 278.721 333.614 278.721ZM349.496 264.677H333.358C332.837 264.677 332.337 264.471 331.968 264.106C331.6 263.74 331.393 263.244 331.393 262.726C331.393 262.209 331.6 261.713 331.968 261.347C332.337 260.981 332.837 260.776 333.358 260.776H349.496C350.017 260.776 350.517 260.981 350.885 261.347C351.254 261.713 351.461 262.209 351.461 262.726C351.461 263.244 351.254 263.74 350.885 264.106C350.517 264.471 350.017 264.677 349.496 264.677ZM167.66 36.4555C167.139 36.4555 166.639 36.25 166.27 35.8841C165.901 35.5183 165.694 35.0222 165.694 34.5049C165.694 33.9875 165.901 33.4914 166.27 33.1256C166.639 32.7598 167.139 32.5542 167.66 32.5542L194.176 32.3787C194.697 32.3787 195.197 32.5842 195.565 32.95C195.934 33.3158 196.141 33.812 196.141 34.3293C196.141 34.8466 195.934 35.3428 195.565 35.7086C195.197 36.0744 194.697 36.2799 194.176 36.2799L167.66 36.4555ZM138.51 64.1932C137.989 64.1932 137.489 63.9877 137.121 63.6218C136.752 63.256 136.545 62.7599 136.545 62.2425C136.545 61.7252 136.752 61.2291 137.121 60.8633C137.489 60.4974 137.989 60.2919 138.51 60.2919L192.662 60.0384C193.183 60.0384 193.683 60.2439 194.052 60.6097C194.421 60.9755 194.628 61.4716 194.628 61.989C194.628 62.2451 194.577 62.4988 194.478 62.7354C194.379 62.9721 194.235 63.1871 194.052 63.3683C193.869 63.5494 193.653 63.6931 193.414 63.7911C193.176 63.8891 192.92 63.9396 192.662 63.9396L138.51 64.1932ZM182.815 49.1539C182.293 49.1539 181.793 48.9484 181.425 48.5826C181.056 48.2168 180.849 47.7207 180.849 47.2033C180.849 46.686 181.056 46.1899 181.425 45.824C181.793 45.4582 182.293 45.2527 182.815 45.2527L221.89 44.8626C222.412 44.8626 222.912 45.0681 223.28 45.4339C223.649 45.7997 223.856 46.2959 223.856 46.8132C223.856 47.3305 223.649 47.8267 223.28 48.1925C222.912 48.5583 222.412 48.7638 221.89 48.7638L182.795 49.1149L182.815 49.1539ZM216.308 35.9093C215.787 35.9093 215.287 35.7038 214.918 35.338C214.55 34.9722 214.342 34.476 214.342 33.9587C214.342 33.4414 214.55 32.9452 214.918 32.5794C215.287 32.2136 215.787 32.0081 216.308 32.0081L226.509 31.8325C227.031 31.8325 227.531 32.038 227.899 32.4038C228.268 32.7697 228.475 33.2658 228.475 33.7831C228.475 34.3005 228.268 34.7966 227.899 35.1624C227.531 35.5282 227.031 35.7337 226.509 35.7337L216.308 35.9093ZM236.711 368.664C234.709 368.685 232.78 367.927 231.335 366.552C229.891 365.177 229.048 363.295 228.986 361.31C228.99 358.538 230.086 355.876 232.04 353.894C233.993 351.912 236.65 350.765 239.443 350.699C239.295 348.329 239.851 345.967 241.042 343.908C242.234 341.848 244.008 340.181 246.145 339.112C249.216 337.463 252.812 337.062 256.175 337.994C259.538 338.925 262.404 341.117 264.17 344.106C266.169 343.395 268.311 343.172 270.415 343.456C272.519 343.74 274.523 344.523 276.258 345.738C277.993 346.953 279.408 348.564 280.383 350.436C281.358 352.308 281.865 354.385 281.86 356.492C284.018 356.492 286.088 357.343 287.614 358.858C289.14 360.372 289.998 362.426 289.998 364.568C289.962 365.682 289.486 366.738 288.674 367.507C287.861 368.277 286.777 368.699 285.654 368.684L236.711 368.664Z" fill="white"/>
				<path d="M276.14 359.184C276.009 359.185 275.882 359.136 275.786 359.047C275.739 359.002 275.701 358.947 275.675 358.887C275.649 358.827 275.636 358.762 275.636 358.696C275.636 358.631 275.649 358.566 275.675 358.506C275.701 358.445 275.739 358.391 275.786 358.345C277.151 356.99 278.934 356.127 280.85 355.894C282.766 355.66 284.706 356.07 286.361 357.058C286.432 357.083 286.496 357.124 286.549 357.177C286.602 357.229 286.642 357.293 286.668 357.363C286.693 357.433 286.702 357.508 286.695 357.582C286.688 357.657 286.665 357.728 286.627 357.793C286.588 357.857 286.536 357.912 286.474 357.954C286.412 357.996 286.342 358.023 286.267 358.035C286.193 358.047 286.117 358.043 286.045 358.022C285.973 358.001 285.906 357.965 285.85 357.916C284.387 357.04 282.671 356.676 280.975 356.881C279.28 357.086 277.702 357.849 276.494 359.047C276.448 359.093 276.392 359.129 276.331 359.153C276.27 359.176 276.205 359.187 276.14 359.184Z" fill="#7F54B3"/>
				<path d="M236.711 369.093C234.584 369.12 232.532 368.317 230.996 366.858C229.46 365.399 228.561 363.4 228.495 361.291C228.497 358.468 229.573 355.75 231.508 353.681C233.444 351.612 236.095 350.345 238.932 350.133C238.862 347.743 239.483 345.383 240.724 343.333C241.964 341.283 243.77 339.628 245.929 338.566C249.046 336.888 252.69 336.453 256.119 337.348C259.548 338.243 262.505 340.402 264.386 343.384C266.412 342.73 268.564 342.553 270.671 342.865C272.778 343.177 274.783 343.97 276.529 345.182C278.275 346.394 279.713 347.992 280.73 349.85C281.747 351.708 282.316 353.775 282.391 355.888C284.595 356.012 286.668 356.968 288.184 358.56C289.701 360.152 290.546 362.26 290.548 364.451C290.522 365.706 289.997 366.901 289.088 367.774C288.179 368.647 286.958 369.128 285.693 369.113L236.711 369.093ZM252.711 337.883C250.479 337.893 248.279 338.414 246.283 339.405C244.23 340.426 242.527 342.026 241.387 344.004C240.247 345.982 239.721 348.25 239.875 350.523V351.109H239.364C236.705 351.184 234.179 352.283 232.319 354.171C230.46 356.06 229.413 358.592 229.399 361.232C229.435 363.098 230.214 364.874 231.566 366.172C232.918 367.469 234.732 368.183 236.612 368.157H285.595C286.093 368.175 286.59 368.096 287.057 367.923C287.525 367.751 287.953 367.488 288.318 367.152C288.683 366.815 288.978 366.409 289.185 365.959C289.392 365.509 289.508 365.023 289.526 364.529C289.526 362.513 288.722 360.579 287.289 359.149C285.856 357.72 283.911 356.912 281.88 356.902H281.388V356.414C281.383 353.053 280.035 349.831 277.641 347.454C275.246 345.078 271.999 343.74 268.612 343.735C267.15 343.738 265.699 343.995 264.327 344.496L263.934 344.632L263.718 344.281C262.607 342.353 261.006 340.747 259.075 339.624C257.143 338.501 254.949 337.901 252.711 337.883Z" fill="#7F54B3"/>
				<path d="M250.391 361.661C250.261 361.661 250.136 361.61 250.044 361.518C249.952 361.427 249.9 361.303 249.9 361.174C249.9 358.489 248.825 355.914 246.912 354.015C244.999 352.116 242.404 351.05 239.698 351.05C236.993 351.05 234.398 352.116 232.485 354.015C230.572 355.914 229.497 358.489 229.497 361.174C229.474 361.289 229.411 361.392 229.32 361.467C229.229 361.541 229.114 361.582 228.996 361.582C228.878 361.582 228.763 361.541 228.672 361.467C228.58 361.392 228.518 361.289 228.495 361.174C228.495 358.225 229.675 355.397 231.776 353.312C233.877 351.226 236.727 350.055 239.698 350.055C242.67 350.055 245.52 351.226 247.621 353.312C249.722 355.397 250.902 358.225 250.902 361.174C250.897 361.305 250.841 361.429 250.746 361.52C250.65 361.611 250.523 361.661 250.391 361.661ZM281.899 356.824C281.769 356.824 281.644 356.772 281.552 356.681C281.46 356.589 281.408 356.465 281.408 356.336C281.412 353.963 280.744 351.637 279.48 349.622C278.216 347.608 276.408 345.987 274.26 344.944C272.112 343.9 269.712 343.477 267.334 343.722C264.956 343.967 262.695 344.871 260.809 346.329C260.714 346.42 260.587 346.471 260.455 346.471C260.323 346.471 260.196 346.42 260.101 346.329C260.022 346.223 259.988 346.09 260.006 345.958C260.024 345.827 260.094 345.708 260.199 345.627C262.233 344.062 264.669 343.094 267.229 342.834C269.79 342.573 272.373 343.031 274.684 344.154C276.996 345.278 278.943 347.022 280.305 349.19C281.668 351.357 282.39 353.86 282.391 356.414C282.372 356.529 282.312 356.634 282.222 356.709C282.132 356.785 282.017 356.825 281.899 356.824Z" fill="#7F54B3"/>
				<path d="M239.954 350.543H238.951C238.948 347.537 239.945 344.614 241.788 342.227C243.63 339.841 246.214 338.125 249.139 337.344C252.064 336.564 255.167 336.764 257.967 337.912C260.766 339.061 263.105 341.094 264.622 343.696L263.757 344.203C262.352 341.79 260.184 339.904 257.589 338.838C254.994 337.772 252.116 337.586 249.404 338.308C246.691 339.031 244.294 340.621 242.586 342.833C240.877 345.046 239.952 347.756 239.954 350.543Z" fill="#7F54B3"/>
				<path d="M177.193 331.602C172.3 333.139 166.993 332.685 162.438 330.341C157.883 327.996 154.451 323.953 152.898 319.099L114.589 198.961C113.041 194.106 113.498 188.839 115.861 184.318C118.223 179.798 122.298 176.393 127.189 174.851C132.078 173.315 137.383 173.77 141.935 176.115C146.487 178.459 149.915 182.502 151.464 187.355L189.812 307.395C190.596 309.807 190.891 312.348 190.68 314.873C190.469 317.398 189.757 319.857 188.583 322.107C187.41 324.358 185.8 326.355 183.845 327.985C181.89 329.615 179.629 330.844 177.193 331.602Z" fill="#7F54B3"/>
				<path d="M130.176 174.247C133.329 175.063 136.221 176.66 138.583 178.888C140.945 181.115 142.698 183.901 143.68 186.984L182.028 307.044C182.798 309.446 183.083 311.974 182.867 314.485C182.651 316.996 181.938 319.44 180.77 321.677C179.602 323.914 178 325.901 176.058 327.524C174.115 329.147 171.869 330.373 169.449 331.134C168.46 331.439 167.447 331.661 166.422 331.798C169.769 332.682 173.294 332.656 176.627 331.723C179.961 330.79 182.98 328.984 185.368 326.494C187.756 324.005 189.425 320.923 190.2 317.573C190.975 314.223 190.827 310.728 189.773 307.454L151.424 187.413C150.036 183.072 147.135 179.362 143.242 176.95C139.348 174.537 134.717 173.579 130.176 174.247Z" fill="#7CA1CE"/>
				<path d="M171.355 334.47C166.815 334.467 162.393 333.03 158.729 330.369C155.064 327.708 152.348 323.959 150.972 319.665L112.624 199.624C110.911 194.262 111.415 188.444 114.025 183.451C116.635 178.458 121.137 174.698 126.54 172.998C131.943 171.299 137.806 171.799 142.837 174.389C147.869 176.979 151.658 181.446 153.37 186.809L191.719 306.849C192.574 309.509 192.892 312.311 192.656 315.093C192.419 317.875 191.632 320.584 190.339 323.064C189.047 325.545 187.274 327.748 185.123 329.547C182.972 331.347 180.484 332.708 177.802 333.553C175.712 334.18 173.539 334.489 171.355 334.47ZM132.987 176.022C130.273 176.038 127.601 176.686 125.185 177.914C122.77 179.142 120.679 180.916 119.08 183.092C117.482 185.269 116.42 187.787 115.982 190.445C115.543 193.103 115.739 195.826 116.555 198.395L154.903 318.455C156.293 322.801 159.364 326.421 163.443 328.519C165.463 329.558 167.669 330.191 169.935 330.384C172.202 330.577 174.484 330.325 176.652 329.642C178.821 328.959 180.832 327.86 182.572 326.405C184.312 324.951 185.746 323.171 186.793 321.167C187.84 319.163 188.479 316.974 188.673 314.725C188.867 312.475 188.613 310.21 187.925 308.059L149.498 188.018C148.382 184.54 146.181 181.504 143.214 179.348C140.246 177.192 136.665 176.027 132.987 176.022Z" fill="#7F54B3"/>
				<path d="M151.326 286.563C150.887 286.58 150.456 286.451 150.099 286.197C149.743 285.942 149.483 285.577 149.36 285.158L119.012 190.066C118.924 189.815 118.889 189.549 118.908 189.285C118.927 189.02 119.001 188.762 119.124 188.526C119.247 188.291 119.418 188.083 119.625 187.915C119.832 187.747 120.072 187.623 120.329 187.55C120.583 187.459 120.852 187.422 121.121 187.44C121.39 187.457 121.653 187.529 121.893 187.652C122.132 187.775 122.344 187.945 122.515 188.152C122.685 188.359 122.811 188.599 122.884 188.857L153.252 283.949C153.34 284.2 153.375 284.466 153.356 284.73C153.337 284.995 153.263 285.253 153.14 285.489C153.017 285.724 152.846 285.932 152.639 286.1C152.432 286.268 152.192 286.392 151.935 286.465C151.74 286.535 151.533 286.569 151.326 286.563ZM159.306 311.531C158.868 311.548 158.436 311.419 158.08 311.165C157.723 310.91 157.463 310.544 157.341 310.126L152.663 295.438C152.575 295.187 152.539 294.922 152.559 294.657C152.578 294.392 152.651 294.134 152.775 293.898C152.898 293.663 153.068 293.455 153.276 293.287C153.483 293.119 153.722 292.995 153.979 292.922C154.232 292.835 154.5 292.8 154.767 292.819C155.034 292.838 155.294 292.911 155.531 293.033C155.768 293.156 155.978 293.325 156.147 293.53C156.317 293.736 156.442 293.973 156.515 294.229L161.213 308.897C161.304 309.149 161.342 309.417 161.324 309.684C161.306 309.951 161.233 310.211 161.11 310.449C160.986 310.687 160.815 310.897 160.606 311.066C160.397 311.236 160.155 311.36 159.896 311.433C159.704 311.491 159.506 311.523 159.306 311.531Z" fill="white"/>
				<path d="M98.0408 163.705L97.9488 163.739C90.2677 166.608 86.384 175.112 89.2742 182.735L95.1649 198.271C98.0551 205.893 106.625 209.748 114.306 206.879L114.398 206.845C122.079 203.977 125.963 195.472 123.072 187.85L117.182 172.314C114.292 164.691 105.722 160.837 98.0408 163.705Z" fill="#7F54B3"/>
				<path d="M109.086 209.845C105.646 209.842 102.289 208.798 99.4626 206.853C96.6358 204.909 94.4732 202.156 93.2628 198.961L87.366 183.356C86.0451 179.244 86.3698 174.786 88.2728 170.905C90.1758 167.025 93.511 164.02 97.5866 162.515C101.662 161.009 106.165 161.119 110.162 162.82C114.158 164.521 117.342 167.684 119.051 171.652L124.948 187.257C126.524 191.414 126.375 196.022 124.532 200.07C122.69 204.118 119.305 207.276 115.12 208.85C113.185 209.539 111.141 209.876 109.086 209.845ZM113.606 205.008L114.393 206.958L113.685 205.008C116.868 203.809 119.443 201.408 120.846 198.33C122.25 195.252 122.367 191.748 121.174 188.584L115.277 172.979C114.073 169.807 111.649 167.241 108.538 165.843C105.426 164.446 101.883 164.332 98.6878 165.527C95.4922 166.722 92.9058 169.128 91.4977 172.216C90.0896 175.303 89.975 178.819 91.1793 181.99L97.076 197.595C98.288 200.746 100.706 203.293 103.802 204.681C106.899 206.07 110.423 206.187 113.606 205.008Z" fill="#7F54B3"/>
				<path d="M312.208 212.771L283.629 209.319C244.713 204.612 205.382 204.33 166.402 208.48L144.073 210.86L122.452 142.725L142.107 131.938C176.376 113.041 208.36 90.3257 237.438 64.2321L258.804 45.0576L312.208 212.771Z" fill="#C2E7FE"/>
				<path d="M258.627 45.0576L237.261 64.2321C234.509 66.7094 231.698 69.1086 228.888 71.5274C228.534 90.9165 232.386 115.494 240.681 141.242C249.506 168.882 261.673 192.524 274.096 208.265C277.3 208.597 280.504 208.928 283.707 209.319L312.248 212.771L258.627 45.0576Z" fill="#FAC261"/>
				<path d="M312.208 212.771L309.417 204.032C298.862 193.226 289.368 184.702 286.027 185.131C277.182 186.301 187.748 193.441 154.137 198.785C149.262 199.546 144.8 200.034 140.731 200.307L144.073 210.86L166.382 208.48C205.363 204.33 244.693 204.612 283.609 209.319L312.208 212.771Z" fill="#97D4FE"/>
				<path d="M145.724 184.663L138.884 163.206C137.118 157.691 136.713 151.837 137.701 146.134C138.69 140.432 141.043 135.048 144.564 130.436L141.93 131.938L121.312 141.691C114.311 143.895 108.479 148.769 105.098 155.24C101.718 161.711 101.067 169.249 103.287 176.197L109.046 194.221C111.267 201.168 116.178 206.956 122.699 210.31C129.22 213.665 136.816 214.311 143.817 212.108L166.441 208.382L169.409 208.109C163.864 206.358 158.821 203.316 154.7 199.237C150.58 195.159 147.503 190.162 145.724 184.663Z" fill="#FAC261"/>
				<path d="M154.137 198.707C130.746 202.374 116.791 199.624 110.363 197.615C113.197 203.66 118.151 208.474 124.3 211.159C130.449 213.844 137.373 214.216 143.778 212.206L166.402 208.48L169.37 208.207C163.578 206.341 158.344 203.077 154.137 198.707Z" fill="#F0A374"/>
				<path d="M135.464 215.502C129.148 215.5 122.996 213.505 117.898 209.806C112.799 206.107 109.018 200.895 107.1 194.923L101.361 176.899C98.9619 169.457 99.6368 161.375 103.237 154.426C106.838 147.478 113.07 142.231 120.564 139.838L141.046 130.085L142.343 129.343L143.581 128.641C176.736 110.12 207.719 88.0077 235.964 62.7106L259.668 41.4294L315.157 215.034L283.472 211.133C244.713 206.439 205.541 206.151 166.716 210.274L144.348 213.98C141.48 214.928 138.485 215.441 135.464 215.502ZM257.644 48.6272L238.617 65.7145C210.172 91.2223 178.957 113.512 145.547 132.172L144.368 132.874L142.913 133.693L121.921 143.7C115.436 145.752 110.036 150.271 106.904 156.268C103.772 162.265 103.164 169.249 105.213 175.69L110.972 193.714C113.036 200.147 117.586 205.506 123.626 208.615C129.665 211.723 136.701 212.327 143.188 210.294H143.483L166.107 206.549C205.277 202.379 244.798 202.661 283.904 207.387L309.319 210.469L257.644 48.6272Z" fill="#7F54B3"/>
				<path d="M260.416 187.55C264.129 194.615 268.21 201.483 272.641 208.129C276.324 208.48 279.999 208.876 283.668 209.319L312.208 212.771L309.417 204.032C298.862 193.226 289.368 184.702 286.027 185.131C283.393 185.482 273.664 186.36 260.416 187.55Z" fill="#F0A374"/>
				<path d="M323.412 117.035C338.645 164.689 336.817 207.758 319.343 213.259C301.869 218.76 275.373 184.585 260.16 136.931C244.946 89.2779 246.755 46.2084 264.229 40.7272C281.703 35.246 308.199 69.3232 323.412 117.035Z" fill="#7F54B3"/>
				<path d="M264.229 40.6492C258.745 42.3658 254.813 47.7885 252.435 55.903C253.989 54.209 255.96 52.9452 258.155 52.2359C275.629 46.7352 302.125 80.9099 317.338 128.544C327.795 161.236 330.213 191.783 325.043 209.514C336.975 197.03 336.837 158.798 323.392 116.957C308.198 69.3232 281.663 35.1095 264.229 40.6492Z" fill="#7CA1CE"/>
				<path d="M285.909 123.414C280.582 109.116 265.939 101.43 253.123 106.365C252.573 106.58 252.062 106.814 251.531 107.048C255.15 125.107 261.303 142.572 269.811 158.934C270.705 158.715 271.585 158.441 272.445 158.115C285.202 153.239 291.236 137.712 285.909 123.414Z" fill="#97D4FE"/>
				<path d="M268.278 153.726C281.054 148.85 287.089 133.303 281.762 119.025C280.702 116.229 279.239 113.601 277.418 111.222C274.193 108.302 270.226 106.311 265.944 105.466C261.662 104.62 257.229 104.951 253.123 106.424C252.573 106.638 252.062 106.872 251.531 107.106C253.537 117.27 256.384 127.252 260.042 136.951C262.322 143.056 264.779 148.752 267.335 154.058L268.278 153.726Z" fill="#C2E7FE"/>
				<path d="M315.511 215.775C307.078 215.775 297.251 208.987 287.305 196.171C275.983 181.581 265.683 160.729 258.234 137.458C242.509 88.01 244.809 44.6479 263.62 38.718C272.936 35.7921 284.533 42.5217 296.268 57.639C307.589 72.249 317.889 93.0816 325.339 116.352C341.063 165.8 338.783 209.182 319.953 215.092C318.517 215.546 317.018 215.777 315.511 215.775ZM268.042 42.0731C266.955 42.0652 265.873 42.2298 264.838 42.5607C248.74 47.6128 247.482 90.5263 262.086 136.19C269.379 159.012 279.482 179.435 290.509 193.655C300.985 207.153 311.265 213.532 318.734 211.211C334.832 206.139 336.09 163.226 321.486 117.581C314.194 94.7591 304.11 74.3557 293.064 60.1162C284.022 48.4321 275.118 42.0731 268.042 42.0731Z" fill="#7F54B3"/>
				<path d="M255.639 162.25C255.237 162.257 254.842 162.141 254.508 161.918C254.174 161.694 253.917 161.375 253.772 161.002C250.961 154.389 248.406 147.348 246.126 140.345C238.263 115.923 234.725 92.1453 235.944 73.3609C235.978 72.8281 236.224 72.3304 236.627 71.9774C237.031 71.6244 237.559 71.445 238.096 71.4786C238.633 71.5122 239.135 71.7562 239.491 72.1567C239.846 72.5573 240.027 73.0817 239.993 73.6145C238.814 91.6577 242.45 115.533 249.998 139.116C252.219 146.099 254.755 152.946 257.506 159.461C257.615 159.703 257.672 159.965 257.675 160.23C257.677 160.495 257.626 160.758 257.523 161.003C257.42 161.247 257.268 161.469 257.076 161.653C256.883 161.837 256.656 161.981 256.406 162.075C256.166 162.188 255.905 162.248 255.639 162.25ZM266.155 183.668C265.795 183.676 265.439 183.586 265.127 183.407C264.815 183.228 264.559 182.967 264.386 182.654C262.067 178.596 259.826 174.266 257.683 169.76C257.571 169.521 257.507 169.262 257.496 168.998C257.485 168.734 257.526 168.47 257.617 168.222C257.708 167.974 257.848 167.746 258.028 167.551C258.208 167.357 258.425 167.199 258.666 167.088C258.907 166.976 259.169 166.913 259.435 166.902C259.7 166.891 259.966 166.931 260.216 167.022C260.466 167.113 260.696 167.251 260.892 167.43C261.088 167.608 261.247 167.824 261.359 168.063C263.442 172.452 265.644 176.704 267.904 180.664C268.045 180.892 268.138 181.147 268.176 181.412C268.213 181.677 268.196 181.947 268.124 182.205C268.052 182.463 267.927 182.703 267.758 182.911C267.588 183.119 267.377 183.291 267.138 183.414C266.838 183.583 266.499 183.67 266.155 183.668Z" fill="white"/>
				<path d="M112.82 168.453C112.59 168.437 112.372 168.344 112.202 168.189C112.032 168.035 111.92 167.828 111.883 167.602C111.847 167.376 111.889 167.144 112.002 166.945C112.115 166.745 112.292 166.589 112.506 166.503L126.697 162.036C126.824 161.997 126.957 161.983 127.089 161.995C127.221 162.007 127.349 162.045 127.466 162.107C127.583 162.169 127.686 162.253 127.77 162.354C127.854 162.456 127.917 162.573 127.955 162.699C127.998 162.823 128.015 162.954 128.005 163.085C127.995 163.216 127.959 163.343 127.898 163.46C127.838 163.576 127.754 163.68 127.652 163.763C127.551 163.847 127.433 163.91 127.307 163.947L113.115 168.414C113.02 168.446 112.92 168.459 112.82 168.453ZM117.125 181.932C116.895 181.916 116.677 181.823 116.507 181.668C116.337 181.514 116.224 181.306 116.188 181.08C116.152 180.854 116.193 180.623 116.306 180.423C116.419 180.224 116.597 180.068 116.81 179.981L131.002 175.553C131.131 175.514 131.267 175.5 131.401 175.512C131.536 175.524 131.667 175.563 131.786 175.625C131.906 175.688 132.012 175.773 132.098 175.876C132.184 175.979 132.249 176.098 132.289 176.226C132.329 176.354 132.344 176.489 132.331 176.623C132.319 176.756 132.28 176.886 132.217 177.005C132.154 177.123 132.068 177.228 131.964 177.314C131.86 177.4 131.74 177.464 131.611 177.504L117.42 181.971L117.125 181.932ZM121.43 195.411C121.214 195.412 121.004 195.344 120.831 195.218C120.658 195.091 120.53 194.913 120.466 194.708C120.424 194.584 120.407 194.453 120.417 194.322C120.427 194.191 120.463 194.064 120.523 193.947C120.584 193.831 120.667 193.728 120.769 193.644C120.871 193.56 120.988 193.498 121.115 193.46L135.307 188.993C135.567 188.913 135.849 188.939 136.091 189.065C136.332 189.191 136.513 189.407 136.594 189.666C136.675 189.925 136.649 190.205 136.522 190.444C136.394 190.684 136.176 190.864 135.916 190.944L121.744 195.411C121.64 195.428 121.534 195.428 121.43 195.411Z" fill="#7F54B3"/>
				<path d="M90.7663 349.041C89.835 349.46 88.7994 349.595 87.7905 349.43C86.7816 349.265 85.8447 348.807 85.0984 348.113C84.352 347.419 83.8297 346.522 83.5975 345.533C83.3653 344.545 83.4336 343.511 83.7938 342.561C84.1541 341.611 84.79 340.789 85.6213 340.198C86.4525 339.607 87.4417 339.274 88.4637 339.241C89.4857 339.208 90.4946 339.476 91.3628 340.013C92.231 340.549 92.9195 341.328 93.3412 342.253C93.6238 342.866 93.7813 343.528 93.8047 344.202C93.8281 344.876 93.7169 345.548 93.4776 346.179C93.2382 346.81 92.8754 347.387 92.4101 347.879C91.9448 348.37 91.3862 348.765 90.7663 349.041Z" fill="white"/>
				<path d="M88.6435 350.328C87.567 350.329 86.51 350.043 85.5837 349.498C84.6573 348.954 83.8957 348.172 83.3788 347.235C82.8619 346.298 82.6089 345.24 82.6462 344.173C82.6835 343.105 83.0098 342.067 83.5909 341.168C84.172 340.268 84.9864 339.541 85.9485 339.062C86.9107 338.582 87.9851 338.369 89.059 338.444C90.1328 338.519 91.1665 338.88 92.0514 339.488C92.9364 340.097 93.6399 340.93 94.0882 341.902C94.5008 342.808 94.6788 343.802 94.6058 344.794C94.5328 345.786 94.2113 346.744 93.6703 347.581C93.1294 348.418 92.3862 349.108 91.5083 349.588C90.6304 350.068 89.6457 350.322 88.6435 350.328ZM88.6435 340.068C88.028 340.069 87.4193 340.195 86.8548 340.439C85.8589 340.874 85.0608 341.66 84.6143 342.645C84.1678 343.629 84.1046 344.743 84.4369 345.772C84.7692 346.8 85.4735 347.67 86.4139 348.213C87.3543 348.757 88.4641 348.935 89.5293 348.714C90.5946 348.494 91.5397 347.889 92.1824 347.018C92.8251 346.146 93.1198 345.07 93.0098 343.995C92.8997 342.921 92.3926 341.925 91.5863 341.2C90.7801 340.475 89.7317 340.071 88.6435 340.068Z" fill="#7F54B3"/>
				<path d="M48.0934 235.712C47.5721 235.712 47.0721 235.506 46.7035 235.141C46.3349 234.775 46.1278 234.279 46.1278 233.761C46.1278 233.244 46.3349 232.748 46.7035 232.382C47.0721 232.016 47.5721 231.811 48.0934 231.811L67.4937 231.635C68.015 231.635 68.5149 231.841 68.8835 232.206C69.2522 232.572 69.4592 233.068 69.4592 233.586C69.4592 234.103 69.2522 234.599 68.8835 234.965C68.5149 235.331 68.015 235.536 67.4937 235.536L48.0737 235.712H48.0934ZM32.3098 223.189C31.7885 223.189 31.2886 222.983 30.9199 222.618C30.5513 222.252 30.3442 221.756 30.3442 221.238C30.3442 220.721 30.5513 220.225 30.9199 219.859C31.2886 219.493 31.7885 219.288 32.3098 219.288L71.3462 218.937C71.8675 218.937 72.3674 219.142 72.7361 219.508C73.1047 219.874 73.3118 220.37 73.3118 220.887C73.3118 221.405 73.1047 221.901 72.7361 222.267C72.3674 222.632 71.8675 222.838 71.3462 222.838L32.2508 223.189H32.3098ZM317.043 264.678H260.533C260.012 264.678 259.512 264.473 259.143 264.107C258.775 263.741 258.567 263.245 258.567 262.728C258.567 262.211 258.775 261.714 259.143 261.349C259.512 260.983 260.012 260.777 260.533 260.777H317.043C317.565 260.777 318.065 260.983 318.433 261.349C318.802 261.714 319.009 262.211 319.009 262.728C319.009 263.245 318.802 263.741 318.433 264.107C318.065 264.473 317.565 264.678 317.043 264.678ZM333.613 278.723H276.297C275.776 278.723 275.276 278.517 274.907 278.152C274.538 277.786 274.331 277.29 274.331 276.772C274.331 276.255 274.538 275.759 274.907 275.393C275.276 275.027 275.776 274.822 276.297 274.822H333.613C334.134 274.822 334.634 275.027 335.003 275.393C335.372 275.759 335.579 276.255 335.579 276.772C335.579 277.29 335.372 277.786 335.003 278.152C334.634 278.517 334.134 278.723 333.613 278.723ZM349.495 264.678H333.358C332.836 264.678 332.336 264.473 331.968 264.107C331.599 263.741 331.392 263.245 331.392 262.728C331.392 262.211 331.599 261.714 331.968 261.349C332.336 260.983 332.836 260.777 333.358 260.777H349.495C350.016 260.777 350.516 260.983 350.885 261.349C351.254 261.714 351.461 262.211 351.461 262.728C351.461 263.245 351.254 263.741 350.885 264.107C350.516 264.473 350.016 264.678 349.495 264.678ZM167.659 36.4569C167.138 36.4569 166.638 36.2514 166.27 35.8856C165.901 35.5198 165.694 35.0237 165.694 34.5063C165.694 33.989 165.901 33.4928 166.27 33.127C166.638 32.7612 167.138 32.5557 167.659 32.5557L194.175 32.3802C194.696 32.3802 195.196 32.5857 195.565 32.9515C195.934 33.3173 196.141 33.8134 196.141 34.3308C196.141 34.8481 195.934 35.3442 195.565 35.7101C195.196 36.0759 194.696 36.2814 194.175 36.2814L167.659 36.4569ZM138.51 64.1946C137.989 64.1946 137.489 63.9891 137.12 63.6233C136.751 63.2575 136.544 62.7613 136.544 62.244C136.544 61.7267 136.751 61.2305 137.12 60.8647C137.489 60.4989 137.989 60.2934 138.51 60.2934L192.662 60.0398C193.183 60.0398 193.683 60.2453 194.052 60.6111C194.42 60.977 194.627 61.4731 194.627 61.9904C194.627 62.2466 194.576 62.5002 194.478 62.7369C194.379 62.9736 194.234 63.1886 194.052 63.3697C193.869 63.5509 193.652 63.6945 193.414 63.7926C193.175 63.8906 192.92 63.941 192.662 63.941L138.51 64.1946ZM182.814 49.1554C182.293 49.1554 181.793 48.9499 181.424 48.5841C181.056 48.2183 180.849 47.7221 180.849 47.2048C180.849 46.6875 181.056 46.1913 181.424 45.8255C181.793 45.4597 182.293 45.2542 182.814 45.2542L221.89 44.8641C222.411 44.8641 222.911 45.0696 223.28 45.4354C223.648 45.8012 223.855 46.2973 223.855 46.8147C223.855 47.332 223.648 47.8282 223.28 48.194C222.911 48.5598 222.411 48.7653 221.89 48.7653L182.794 49.1164L182.814 49.1554ZM216.308 35.9108C215.786 35.9108 215.286 35.7053 214.918 35.3394C214.549 34.9736 214.342 34.4775 214.342 33.9602C214.342 33.4428 214.549 32.9467 214.918 32.5809C215.286 32.215 215.786 32.0095 216.308 32.0095L226.509 31.834C227.03 31.834 227.53 32.0395 227.899 32.4053C228.267 32.7711 228.474 33.2673 228.474 33.7846C228.474 34.3019 228.267 34.7981 227.899 35.1639C227.53 35.5297 227.03 35.7352 226.509 35.7352L216.308 35.9108ZM236.71 368.666C234.709 368.687 232.779 367.929 231.335 366.554C229.891 365.179 229.047 363.297 228.986 361.312C228.99 358.539 230.086 355.878 232.039 353.895C233.993 351.913 236.649 350.767 239.442 350.7C239.294 348.33 239.85 345.969 241.042 343.909C242.233 341.849 244.008 340.182 246.145 339.114C249.215 337.465 252.811 337.063 256.174 337.995C259.537 338.927 262.404 341.118 264.169 344.107C266.168 343.397 268.31 343.174 270.414 343.458C272.518 343.742 274.522 344.524 276.257 345.739C277.992 346.954 279.407 348.565 280.382 350.437C281.357 352.309 281.864 354.387 281.86 356.494C284.018 356.494 286.088 357.345 287.614 358.859C289.14 360.373 289.997 362.427 289.997 364.569C289.961 365.683 289.486 366.739 288.673 367.509C287.861 368.279 286.776 368.701 285.653 368.685L236.71 368.666Z" fill="white"/>
				</g>
				<defs>
				<clipPath id="clip0_913_34227">
				<rect width="394" height="391" fill="white" transform="translate(0.172852)"/>
				</clipPath>
				</defs>
				</svg>
		</div>
		<button type="button" class="primary-button flex align-center" style="text-decoration: none;" onclick="getStarted(this)">
			<span class="start-text">
				<?php esc_html_e( 'Get Started', 'kliken-ads-pixel-for-meta' ); ?>
			</span>
			<svg width="24" height="24" viewBox="0 0 41 40" fill="none" xmlns="http://www.w3.org/2000/svg">
				<mask id="mask0_1182_3077" style="mask-type:alpha" maskUnits="userSpaceOnUse" x="0" y="0" width="41" height="40">
				<rect x="0.5" width="40" height="40" fill="white"/>
				</mask>
				<g mask="url(#mask0_1182_3077)">
				<path d="M20.5 36.6667C18.2223 36.6667 16.0695 36.2292 14.0417 35.3542C12.0139 34.4792 10.2431 33.2848 8.72921 31.7709C7.21532 30.257 6.02087 28.4862 5.14587 26.4584C4.27087 24.4306 3.83337 22.2778 3.83337 20C3.83337 17.6945 4.27087 15.5348 5.14587 13.5209C6.02087 11.507 7.21532 9.7431 8.72921 8.22921C10.2431 6.71532 12.0139 5.52087 14.0417 4.64587C16.0695 3.77087 18.2223 3.33337 20.5 3.33337C20.9723 3.33337 21.3681 3.4931 21.6875 3.81254C22.007 4.13199 22.1667 4.52782 22.1667 5.00004C22.1667 5.47226 22.007 5.8681 21.6875 6.18754C21.3681 6.50698 20.9723 6.66671 20.5 6.66671C16.8056 6.66671 13.6598 7.96532 11.0625 10.5625C8.46532 13.1598 7.16671 16.3056 7.16671 20C7.16671 23.6945 8.46532 26.8403 11.0625 29.4375C13.6598 32.0348 16.8056 33.3334 20.5 33.3334C24.1945 33.3334 27.3403 32.0348 29.9375 29.4375C32.5348 26.8403 33.8334 23.6945 33.8334 20C33.8334 19.5278 33.9931 19.132 34.3125 18.8125C34.632 18.4931 35.0278 18.3334 35.5 18.3334C35.9723 18.3334 36.3681 18.4931 36.6875 18.8125C37.007 19.132 37.1667 19.5278 37.1667 20C37.1667 22.2778 36.7292 24.4306 35.8542 26.4584C34.9792 28.4862 33.7848 30.257 32.2709 31.7709C30.757 33.2848 28.9931 34.4792 26.9792 35.3542C24.9653 36.2292 22.8056 36.6667 20.5 36.6667Z" fill="white"/>
				</g>
			</svg>
		</button>
	</div>
</div>
