<?php

// Set framework constants
define( 'KEYDESIGN_THEME_THUMBNAIL', KEYDESIGN_THEME_URI . 'assets/img/thumbnail.png' );

define( 'KEYDESIGN_ELEMENTOR_PRIMARY_COLOR', '#00b30f' );
define( 'KEYDESIGN_ELEMENTOR_SECONDARY_COLOR', '#00473c' );
define( 'KEYDESIGN_ELEMENTOR_TEXT_COLOR', '#00473c' );
define( 'KEYDESIGN_ELEMENTOR_ACCENT_COLOR', '#00b30f' );
define( 'KEYDESIGN_ELEMENTOR_LIGHT_COLOR', '#efeee7' );

define( 'KEYDESIGN_ELEMENTOR_PRIMARY_FONT_FAMILY', '"Plus Jakarta Sans"' );
define( 'KEYDESIGN_ELEMENTOR_PRIMARY_FONT_WEIGHT', '700' );

define( 'KEYDESIGN_ELEMENTOR_SECONDARY_FONT_FAMILY', '"Plus Jakarta Sans"' );
define( 'KEYDESIGN_ELEMENTOR_SECONDARY_FONT_WEIGHT', '600' );

define( 'KEYDESIGN_ELEMENTOR_TEXT_FONT_FAMILY', 'DM Sans' );
define( 'KEYDESIGN_ELEMENTOR_TEXT_FONT_WEIGHT', '400' );

define( 'KEYDESIGN_ELEMENTOR_ACCENT_FONT_FAMILY', '"Plus Jakarta Sans"' );
define( 'KEYDESIGN_ELEMENTOR_ACCENT_FONT_WEIGHT', '500' );

define( 'KEYDESIGN_THEMEFOREST_THEME_LINK', 'https://1.envato.market/finpath-support' );

update_option( 'KEYDESIGN_API_PRODUCT_ID', '07943AA4' );

// Return demo import config
if ( ! function_exists( 'keydesign_demo_content' ) ) {
    function keydesign_demo_content() {
        $keydesign_demos = [
            ["id" => 1,"name" => 'Accounting', "file" => "accounting", "preview" => "https://finpath.keydesign.xyz/accounting/" ],
            ["id" => 2,"name" => 'Business Consulting', "file" => "business-consulting", "preview" => "https://finpath.keydesign.xyz/business-consulting/" ],
            ["id" => 3,"name" => 'Cashback', "file" => "cashback", "preview" => "https://finpath.keydesign.xyz/cashback/" ],
            ["id" => 4,"name" => 'Crypto AI Assistant', "file" => "crypto-ai-assistant", "preview" => "https://finpath.keydesign.xyz/crypto-ai-assistant/", "disable_inner_pages" => true],
			["id" => 5,"name" => 'DeFi Startup', "file" => "defi-startup", "preview" => "https://finpath.keydesign.xyz/defi-startup/", "disable_inner_pages" => true],
            ["id" => 6,"name" => 'Financial Planning', "file" => "financial-planning", "preview" => "https://finpath.keydesign.xyz/financial-planning/" ],
            ["id" => 7,"name" => 'Fintech Software', "file" => "fintech-software", "preview" => "https://finpath.keydesign.xyz/fintech-software/" ],
            ["id" => 8,"name" => 'Insurance', "file" => "insurance", "preview" => "https://finpath.keydesign.xyz/insurance/" ],
            ["id" => 9,"name" => 'Investments App', "file" => "investments-app", "preview" => "https://finpath.keydesign.xyz/investments-app/" ],
            ["id" => 10,"name" => 'Loan Specialist', "file" => "loan-specialist", "preview" => "https://finpath.keydesign.xyz/loan-specialist/" ],
            ["id" => 11,"name" => 'Payroll', "file" => "payroll", "preview" => "https://finpath.keydesign.xyz/payroll/" ],
            ["id" => 12,"name" => 'Tax Advisor', "file" => "tax-advisor", "preview" => "https://finpath.keydesign.xyz/tax-advisor/" ],
        ];
        return $keydesign_demos;
    }
}